package de.accxia.jira.addon.IUM.servlet;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServletHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ServletHelper.class);

    // Regular expression pattern to detect common XSS attack patterns
    public static final String xssPattern = "<script>|<\\/script>|javascript:|<|>|&|\"|'";
    public static final Pattern pattern = Pattern.compile(xssPattern, Pattern.CASE_INSENSITIVE);

    public ServletHelper() {
    }

    public static  boolean doCheckOriginAndReferrer(String baseURL, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws MalformedURLException {
        String referer = httpRequest.getHeader("referer");
        String origin = httpRequest.getHeader("origin");

        if(origin==null || !origin.startsWith(baseURL)){
            URL urlOrigin = new URL(origin);
            URL urlBaseURL = new URL(baseURL);
            if(!urlBaseURL.getHost().equalsIgnoreCase(urlOrigin.getHost())){
                LOG.info("origin.startsWith(baseURL)  {} {}", origin, baseURL);
                return false;
            }
        }

        if(referer!=null && !referer.startsWith(baseURL)){
            LOG.info("referer.startsWith(baseURL)  {} {}", referer, baseURL);
            return false;
        }


        return true;

    }
    public static  boolean doValidateInput(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        Enumeration parameterNames = httpRequest.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String) parameterNames.nextElement();
            Matcher matcher = pattern.matcher(httpRequest.getParameter(parameterName));
            if (matcher.find()) {
                LOG.warn(parameterName + "=" + httpRequest.getParameter(parameterName));
                return false;
            }

        }

        return true;
    }
}

