package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.IOUtil;
import com.atlassian.jira.web.JiraMultipartRequestWrapper;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.ContentCachingResponseWrapper;
import webwork.config.Configuration;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Scanned
public class IUMAssignIssueFilter implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(IUMAssignIssueFilter.class);

    public static final String  WATCHERS = "/rest/api/[\\d\\.\\w]+/issue/[\\d\\-\\w]+/watchers";
    public static final String  WATCHERS_FILTER = "/rest/api/[\\d\\.\\w]+/users/picker/filter";

    public static final Pattern PATTERN_WATCHERS = Pattern.compile(WATCHERS);
    public static final Pattern PATTERN_WATCHERS_FILTER = Pattern.compile(WATCHERS_FILTER);
    private static com.atlassian.jira.user.util.UserManager userManagerJira=ComponentAccessor.getUserManager();

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!ConditionEvaluatorImpl.isLicenseValid()) {
            chain.doFilter(request, response); // no vaild license do nothing
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest) request;
        if(httpRequest.getRequestURI()==null){
            chain.doFilter(request, response); // no vaild license do nothing
            return;
        }


        //1.
        //  /secure/*Issue
        //  /secure/*IssueAction*
        if (httpRequest.getRequestURI().contains("/secure/") && httpRequest.getMethod().equalsIgnoreCase("POST")) {
            String[] unamesAssignee = null;
            String[] unamesUsers = null;
            String issueId;

            //multipart/form-data; boundary=----WebKitFormBoundaryivXVg6OOFnVPnATq
            if (request.getContentType() != null && request.getContentType().indexOf("multipart/form-data") != -1) {
                ResettableStreamHttpServletRequest resettableStreamHttpServletRequest = new ResettableStreamHttpServletRequest(httpRequest);
                String maxSizeStr = Configuration.getString("webwork.multipart.maxSize");

                JiraMultipartRequestWrapper jiraMultipartRequestWrapper = new JiraMultipartRequestWrapper(resettableStreamHttpServletRequest,
                        ((File) request.getServletContext().getAttribute("javax.servlet.context.tempdir")).getAbsolutePath(),Integer.parseInt(maxSizeStr));

                resettableStreamHttpServletRequest.resetInputStream();

                unamesAssignee = jiraMultipartRequestWrapper.getParameterValues("assignee");
                unamesUsers = jiraMultipartRequestWrapper.getParameterValues("userNames");
                request = httpRequest=resettableStreamHttpServletRequest;
            }else {
                unamesAssignee = request.getParameterValues("assignee");
                unamesUsers = request.getParameterValues("userNames");
                issueId= request.getParameter("issueId");
            }

            List<String> unames = new ArrayList<>();
            if (unamesAssignee !=null &&  unamesAssignee.length > 0) {
                unames.addAll(Arrays.asList(unamesAssignee));
            }
            if (unamesUsers !=null &&  unamesUsers.length > 0) {
                unames.addAll(Arrays.stream(unamesUsers).flatMap(uname-> Arrays.stream(uname.split(","))).map(uname-> uname.trim()).filter(uname-> uname.length()>0).collect(Collectors.toList()));
            }
            // Arrays.stream(unamesUsers).flatMap(uname-> Arrays.stream(uname.split(","))).filter(uname-> uname.length()>0).collect(Collectors.toList())
            if (unames.size() == 0) {
                chain.doFilter(request, response);
                return;
            }

            shouldEnableUser(unames);
            chain.doFilter(request, response);
            return;
            /*
            ApplicationUser user = userManagerJira.getUserByName(unames[0]);
            // test whether user already has been re-enabled and is in the enabled group
            if (IntelligentUserManagerHelper.isUserInJiraAndSDGroups(user, DAO.getIUMGroups())) {
                chain.doFilter(request, response);
                return;
            }

            if (IntelligentUserManagerHelper.isUserInGroups(user, DAO.getIUMGroupsDisabled())) {
                //simulate move user in Enable group
                try {
                    boolean success=IntelligentUserManagerHelper.simulateUserToEnabledGroup(user);
                    if(LOG.isDebugEnabled()){
                        LOG.debug("Simulation "+user.getUsername() + " "+success);
                    }
                } catch (Exception e) {
                    LOG.error("Exception "+e.getMessage(),e);
                }
                chain.doFilter(request, response);
                return;
            }
            */
        }

        // 2.
        // /rest/api/*/issue/*/watchers
        if (PATTERN_WATCHERS.matcher(httpRequest.getRequestURI()).matches() && httpRequest.getRequestURI().startsWith("/rest/api/") && httpRequest.getMethod().equalsIgnoreCase("POST") ) {
            if (request.getContentType() != null && request.getContentType().indexOf("application/json") != -1) {
                ResettableStreamHttpServletRequest resettableStreamHttpServletRequest = new ResettableStreamHttpServletRequest(httpRequest);
                String watchers = IOUtils.toString(resettableStreamHttpServletRequest.getInputStream());
                List<String> unames = new ArrayList<>();
                resettableStreamHttpServletRequest.resetInputStream();

                if (watchers !=null &&  watchers.length() > 0) {
                    unames.addAll(Arrays.asList(watchers.replaceAll("\"","").split(",")));
                }

                if (unames.size() == 0) {
                    chain.doFilter(request, response);
                    return;
                }
                shouldEnableUser(unames);
                chain.doFilter(resettableStreamHttpServletRequest, response);
                return;
            }
        }


        //3.
        // /rest/api/*/users/picker/filter
        /*
        if (PATTERN_WATCHERS_FILTER.matcher(httpRequest.getRequestURI()).matches()
                && httpRequest.getMethod().equalsIgnoreCase("GET")
         ) {
            httpRequest.getServletContext().getRequestDispatcher("/rest/api/1.0/users/picker").forward(request,response);
            return;
        }
         */



        chain.doFilter(request, response);

    }


    @Override
    public void destroy() {

    }

    private void shouldEnableUser(List<String> unames){
        if (unames ==null || unames.size() == 0) {
            return ;
        }

        for (String uname:unames){
            ApplicationUser user = userManagerJira.getUserByName(uname);
            // test whether user already has been re-enabled and is in the enabled group
            if (IntelligentUserManagerHelper.isUserInJiraAndSDGroups(user, DAO.getIUMGroups())) {
                continue;
            }

            if (IntelligentUserManagerHelper.isUserInGroups(user, DAO.getIUMGroupsDisabled())) {
                //simulate move user in Enable group
                try {
                    boolean success=IntelligentUserManagerHelper.simulateUserToEnabledGroup(user);
                    if(LOG.isDebugEnabled()){
                        LOG.debug("Simulation "+user.getUsername() + " "+success);
                    }
                } catch (Exception e) {
                    LOG.error("Exception "+e.getMessage(),e);
                }
            }
        }
        return;
    }
}
