package de.accxia.jira.addon.IUM.servlet.session;

import com.atlassian.jira.util.http.HttpRequestType;
import com.atlassian.jira.web.filters.accesslog.AccessLogIPAddressUtil;
import com.atlassian.jira.web.session.currentusers.JiraUserSession;
import com.atlassian.jira.web.session.currentusers.JiraUserSessionInvalidator;
import com.atlassian.jira.web.session.currentusers.JiraUserSessionTracker;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AccxiaUserSessionTracker extends JiraUserSessionTracker {
    private static final Logger log = LoggerFactory.getLogger(AccxiaUserSessionTracker.class);

    private final AccxiaUserSessionTrackerDeletionStrategy deletionStrategy = new AccxiaUserSessionTrackerDeletionStrategy();
    private static AccxiaUserSessionTracker instance;
    private JiraUserSessionInvalidator jiraUserSessionInvalidator;

    public static final long INTERVAL = 15000;
    public AccxiaUserSessionTracker() {
        this.jiraUserSessionInvalidator=new JiraUserSessionInvalidator();
    }

    public static AccxiaUserSessionTracker getInstance() {
        if(instance==null){
            instance=new AccxiaUserSessionTracker();
        }
        return instance;
    }

    public static void recordInteraction(HttpServletRequest httpServletRequest) {
        AccxiaUserSessionTracker tracker = getInstance();
        if (tracker != null) {
            tracker.recordInteractionImpl(httpServletRequest);
        }

    }

    public boolean markSessionAsInvalid(String sessionId) {
        if (StringUtils.isEmpty(sessionId)) {
            return false;
        }

        AccxiaMutableJiraUserSession session = (AccxiaMutableJiraUserSession)this.sessionMap.get(sessionId);
        if (session != null) {
            session.setInvalidateSessionFlag(false);
            this.jiraUserSessionInvalidator.invalidateSession(sessionId);
            this.sessionMap.remove(sessionId);
        }


        return true;
    }
    public boolean isMarkSessionAsInvalid(String sessionId) {
        if (StringUtils.isEmpty(sessionId)) {
            return false;
        }

        AccxiaMutableJiraUserSession session = (AccxiaMutableJiraUserSession)this.sessionMap.get(sessionId);
        if(session==null){
            return false;
        }
        return session.getInvalidateSessionFlag();
    }

    public List<JiraUserSession> getAccxiaSnapshot() {
        List<JiraUserSession> userSessions = Lists.newArrayListWithCapacity(this.sessionMap.size());
        Iterator iSessionMap = this.sessionMap.values().iterator();

        while(iSessionMap.hasNext()) {
            AccxiaMutableJiraUserSession jiraUserSession = (AccxiaMutableJiraUserSession)iSessionMap.next();
            userSessions.add(new SnapshotAccxiaUserSession(jiraUserSession));
        }

        Collections.sort(userSessions, Collections.reverseOrder(BY_LAST_ACCESS_TIME));
        return userSessions;
    }

    protected void recordInteractionImpl(HttpServletRequest httpServletRequest) {
        String asessionId = (String)httpServletRequest.getAttribute("jira.request.assession.id");
        this.recordHttpInteraction(httpServletRequest, asessionId);
    }


    private HttpRequestType determineRequestType(HttpServletRequest httpServletRequest) {
        return AccessLogIPAddressUtil.getShortenedRequestUrl(httpServletRequest).startsWith("/rest/") ? HttpRequestType.REST : HttpRequestType.HTTP;
    }

    private void recordHttpInteraction(final HttpServletRequest httpServletRequest, final String asessionId) {
            HttpSession httpSession = httpServletRequest.getSession(false);
            if (httpSession != null) {
                final String httpSessionId = httpSession.getId();
                HttpRequestType httpRequestType =  determineRequestType(httpServletRequest);
                if(httpRequestType == HttpRequestType.HTTP && httpServletRequest.getRemoteUser()!=null &&
                        (httpServletRequest.getRequestURI()==null ||
                                (httpServletRequest!=null && (httpServletRequest.getRequestURI().contains("/secure") ||
                                        httpServletRequest.getRequestURI().contains("/browse") ||
                                        httpServletRequest.getRequestURI().contains("/servlet") ||
                                        httpServletRequest.getRequestURI().contains("/plugins") ||
                                        httpServletRequest.getRequestURI().equals(httpServletRequest.getContextPath() + "/")
                                )))
                ){
                    this.recordInteractionImpl(httpSessionId, httpServletRequest, httpServletRequest.getRemoteUser(), new AccxiaMutableSessionFactory() {
                        public AccxiaMutableJiraUserSession createUserSession() {
                            return new AccxiaMutableJiraUserSession(HttpRequestType.HTTP, httpSessionId, asessionId);
                        }
                    });
                }

            }

    }
    private final ConcurrentMap<String, AccxiaMutableJiraUserSession> sessionMap = new ConcurrentHashMap();

    private void recordInteractionImpl(String sessionId, HttpServletRequest httpServletRequest, String userName, AccxiaMutableSessionFactory sessionFactory) {
        this.deletionStrategy.deleteStaleSessions(this.sessionMap);
        AccxiaMutableJiraUserSession userSession = (AccxiaMutableJiraUserSession)this.sessionMap.get(sessionId);
        if (userSession == null) {
            AccxiaMutableJiraUserSession newSession = sessionFactory.createUserSession();
            AccxiaMutableJiraUserSession previousValue = (AccxiaMutableJiraUserSession)this.sessionMap.putIfAbsent(sessionId, newSession);
            userSession = previousValue != null ? previousValue : newSession;
        }

        long currentTime= System.currentTimeMillis();
        if(currentTime- userSession.getLastAccessTime().getTime()>INTERVAL){
            userSession.recordInteraction(httpServletRequest, userName);
            userSession.recordInteractionDB();
        }else{
            userSession.recordInteraction(httpServletRequest, userName);
        }


    }


    private interface AccxiaMutableSessionFactory {
        AccxiaMutableJiraUserSession createUserSession();
    }
}
