package de.accxia.jira.addon.IUM.agents;


import com.atlassian.servicedesk.api.user.CheckedUser;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class AgentResponse {
    private final String key;
    private final String name;
    private final String displayName;
    private final Boolean canAdministerJira;
    private final AvatarUrls avatarUrls;

    public AgentResponse(String key, String name, String displayName, Boolean canAdministerJira, AvatarUrls avatarUrls) {
        this.key = key;
        this.name = name;
        this.displayName = displayName;
        this.canAdministerJira = canAdministerJira;
        this.avatarUrls = avatarUrls;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Boolean getCanAdministerJira() {
        return this.canAdministerJira;
    }

    public AvatarUrls getAvatarUrls() {
        return this.avatarUrls;
    }

    public static AgentResponse build(CheckedUser user, Boolean isJiraAdmin, AvatarUrls avatarUrls) {
        return new AgentResponse(user.getKey(), user.getName(), user.getDisplayName(), isJiraAdmin, avatarUrls);
    }

    @JsonAutoDetect
    public static class AvatarUrls {
        private final String small;
        private final String medium;
        private final String large;

        public AvatarUrls(String small, String medium, String large) {
            this.small = small;
            this.medium = medium;
            this.large = large;
        }

        public String getSmall() {
            return this.small;
        }

        public String getMedium() {
            return this.medium;
        }

        public String getLarge() {
            return this.large;
        }
    }
}
