package de.accxia.jira.addon.IUM.authorisation;


import com.atlassian.jira.security.auth.Authorisation;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.google.common.collect.Sets;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import java.util.Set;

@Scanned
public class IUMReferenceAuthorisation  implements Authorisation {

    @Override
    public Decision authoriseForLogin(@Nonnull ApplicationUser applicationUser, HttpServletRequest httpServletRequest) {
        if (IntelligentUserManagerHelper.isUserInGroups(applicationUser, DAO.getIUMGroupsDisabled())){
            return Decision.GRANTED;
        }
        return Decision.ABSTAIN;
    }

    @Override
    public Set<String> getRequiredRoles(HttpServletRequest httpServletRequest) {
        Set<String> requiredRoles = Sets.newHashSet();
        return requiredRoles;
    }

    @Override
    public Decision authoriseForRole(@Nullable ApplicationUser applicationUser, HttpServletRequest httpServletRequest, String s) {
        return Decision.ABSTAIN;
    }
}
