package de.accxia.jira.addon.IUM.conditions;

import java.util.Map;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.webresource.condition.SimpleUrlReadingCondition;

public class IsPluginSideLicensedWrong extends SimpleUrlReadingCondition implements Condition {

	@ComponentImport
	private final ConditionEvaluator conditionEvaluator;

	public IsPluginSideLicensedWrong(final ConditionEvaluator conditionEvaluator) {
		this.conditionEvaluator = conditionEvaluator;
	}

	@Override
	protected boolean isConditionTrue() {
		return conditionEvaluator.evaluate(ConditionType.WRONGSIDELICENSE);
	}

	@Override
	protected String queryKey() {
		// This string will be appended to URLs as a GET parameter
		// whenever 'isConditionTrue' returns true.
		// You should make the string short, but unique to your plugin.
		return "IUM-confirm";
	}

	@Override
	public boolean shouldDisplay(Map<String, Object> context) {
		return isConditionTrue();
	}
}
