package de.accxia.jira.addon.IUM.config;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleAdminService;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.cluster.logging.LoggingManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.collect.Sets;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.job.JobClusterService;
import de.accxia.jira.addon.IUM.job.JobSyncService;
import de.accxia.jira.addon.IUM.job.RunDetailsBean;
import de.accxia.jira.addon.IUM.listener.IUMListener;
import de.accxia.jira.addon.IUM.model.JobResultDTO;
import de.accxia.jira.addon.IUM.servlet.ServletHelper;
import de.accxia.jira.addon.IUM.servlet.filter.XSSHttpServletRequestWrapper;
import de.accxia.jira.addon.IUM.utils.Constants;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;


@WebSudoRequired
@Scanned
public class IntelligentUserManagerConfigServlet extends HttpServlet {
	private static final Logger LOG = LoggerFactory.getLogger(IntelligentUserManagerConfigServlet.class);
	private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	enum Page{
		None("","empty.vm"),
		PageGroupSettings("group","admin_group_IUM.vm"),
		PageDesign("design","admin_design_IUM.vm"),
		PageRest("rest","admin_rest_IUM.vm"),
		PageLogging("logging","admin_logging_IUM.vm"),
		PageUserManagement("user","user_IUM.vm"),

		PageJob("job","admin_job_IUM.vm"),
		PageSync("sync","admin_sync_IUM.vm"),
		PageLicense("sl","sidelicense_IUM.vm"),
		PageSAMLSSO("saml","SAML_IUM.vm");

		String pageId;
		String pageName;

		Page(String pageId, String pageName) {
			this.pageId = pageId;
			this.pageName = pageName;
		}

		public static  Page getPage(String pageId) {
			if(pageId==null){
				return PageGroupSettings;
			}
			for(Page p : values()){
				if( p.pageId.equals(pageId)){
					return p;
				}
			}
			return None;
		}
	}
	/**
	 * 
	 */
	private static final long serialVersionUID = -5623574103725530973L;

	/*Audit management user key. */
	public static final String AUDIT_USER_MANAGEMENT= "com.atlassian.audit.plugin:audit-config:coverage:user_management";

	@ComponentImport
	private final UserManager userManager;
	@ComponentImport
	private final LoginUriProvider loginUriProvider;
	@ComponentImport
	private final TemplateRenderer renderer;

	@ComponentImport
	private final WebSudoManager webSudoManager;
	
	@ComponentImport
	private final JiraAuthenticationContext jiraAuthenticationContext;

	@ComponentImport
	private final PluginSettingsFactory pluginSettingsFactory;

	@ComponentImport
	private final ApplicationProperties applicationProperties;

	@ComponentImport
	private final ApplicationRoleAdminService applicationRoleAdminService;
	@ComponentImport
	private final GroupManager groupManager;
	@ComponentImport
	private final LoggingManager loggingManager;
	private final IUMListener iumListener;

	private final JobClusterService jobClusterService;
	private final JobSyncService jobSyncService;
	private final I18nHelper i18nHelper;
	private final BuildUtilsInfo buildUtilsInfo;

	//private String currentWorkingJob;
	@Inject
	public IntelligentUserManagerConfigServlet(JobClusterService jobClusterService, JobSyncService jobSyncService,
											   UserManager userManager,GroupManager groupManager,
											   LoginUriProvider loginUriProvider,
											   TemplateRenderer renderer,
											   ApplicationRoleAdminService applicationRoleAdminService,
											   //PluginLicenseManager pluginLicenseManager,PluginController pluginController,
											   IUMListener iumListener, LoggingManager loggingManager,
											   // JiraLicenseManager jiraLicenseManager,GroupManager groupManager,
											   WebSudoManager webSudoManager,
											   JiraAuthenticationContext jiraAuthenticationContext,
											   PluginSettingsFactory pluginSettingsFactory, ApplicationProperties applicationProperties) {
		this.jobClusterService = jobClusterService;
		this.jobSyncService=jobSyncService;
		this.groupManager=groupManager;
		this.userManager = userManager;
		this.loginUriProvider = loginUriProvider;
		this.renderer = renderer;

		this.applicationRoleAdminService=applicationRoleAdminService;
		this.webSudoManager=webSudoManager;
		this.jiraAuthenticationContext=jiraAuthenticationContext;
		//this.jiraLicenseManager = jiraLicenseManager;
		//this.groupManager=groupManager;
		this.pluginSettingsFactory=pluginSettingsFactory;
		this.applicationProperties=applicationProperties;
		this.iumListener=iumListener;
		this.loggingManager=loggingManager;
		this.i18nHelper = (I18nHelper) ComponentAccessor.getComponent(I18nHelper.class);
		this.buildUtilsInfo=(BuildUtilsInfo) ComponentAccessor.getComponent(BuildUtilsInfo.class);
	}

	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		try {
			//xss wrapper
			XSSHttpServletRequestWrapper xssRequest = new XSSHttpServletRequestWrapper(request);

			//validate refer
			if(!ServletHelper.doCheckOriginAndReferrer(this.applicationProperties.getBaseUrl(),request,response)){
				forceToLogin(request, response);
				// response.sendError(HttpServletResponse.SC_BAD_REQUEST, "message goes here");
				return;
			}

			UserKey userKey = userManager.getRemoteUserKey();
			if (userKey == null || !userManager.isAdmin(userKey)) {
				redirectToLogin(xssRequest, response);
				return;
			}

			//validation input
			if(!ServletHelper.doValidateInput(request,response)){
				redirectToLogin(request, response);
				// response.sendError(HttpServletResponse.SC_BAD_REQUEST, "message goes here");
				return;
			}




			webSudoManager.willExecuteWebSudoRequest(xssRequest);

			String pageId=xssRequest.getParameter("page");
			Page page = Page.getPage(pageId);

			if (page == Page.PageLicense) {
				try {
					String sideLicense = xssRequest.getParameter("sideLicense");
					if ((sideLicense == null) || ("".equals(sideLicense))) {
						deleteSideLicense();
						ConditionEvaluatorImpl.deleteSideLicense();
					}
					DAO.updateSideLicense(sideLicense);
					setSideLicense(sideLicense);
					ConditionEvaluatorImpl.setSideLicense();
					renderSideLicenseVM(response, this.i18nHelper.getText("de.accxia.apps.jira.IUM.save.license"),null);
				}catch (Exception e){
					LOG.error("Exception: "+e.getMessage(),e);
					renderSideLicenseVM(response, null, e.getMessage());
				}

				return;
			}

			boolean showSideLicense = (!("".equals(DAO.getSideLicense())));
			if (!ConditionEvaluatorImpl.isLicenseValid()) {
				renderLicenseErrorVM(response, showSideLicense);
				return;
			}

			String action=xssRequest.getParameter("action");

			if ("remove".equals(action)) {
				String successMessage=IntelligentUserManagerHelper.disabelAllUsersFromTheEnabledGroups(xssRequest.getParameter("groupName"));
				renderAdminVM(response, successMessage,null,Page.PageUserManagement ,showSideLicense);
				return;
			}

				switch (page){
					case PageSAMLSSO:{
						try{
							String samlIdp="";
							if (xssRequest.getParameterValues("samlIdp")!=null) {
								samlIdp = xssRequest.getParameter("samlIdp");
							}
							setValue("samlIdp", samlIdp);
							String samlMapping="";
							if (xssRequest.getParameterValues("samlMapping")!=null) {
								samlMapping = xssRequest.getParameter("samlMapping");
							}
							setValue("samlMapping", samlMapping);

							renderSamlVM(response,  this.i18nHelper.getText("de.accxia.apps.jira.IUM.save.saml"),null);
						}catch (Exception e){
							LOG.error("Exception: "+e.getMessage(),e);
							renderSamlVM(response, null, e.getMessage());
						}
						return;
					}
					case PageGroupSettings:{
						try {
							/*
							IUMGroupSoftware
							IUMGroupDisableSoftware
							queueSizeSoftware
							*/
							String IUMGroupSoftware=xssRequest.getParameter("IUMGroupSoftware");
							String IUMGroupDisableSoftware=xssRequest.getParameter("IUMGroupDisableSoftware");
							String queueSizeSoftware=xssRequest.getParameter("queueSizeSoftware");
							if(StringUtils.isEmpty(IUMGroupSoftware)){IUMGroupDisableSoftware=queueSizeSoftware="";}

							/*
							IUMGroupServiceDesk
							IUMGroupDisableServiceDesk
							queueSizeServiceDesk
							*/
							String IUMGroupServiceDesk=xssRequest.getParameter("IUMGroupServiceDesk");
							String IUMGroupDisableServiceDesk=xssRequest.getParameter("IUMGroupDisableServiceDesk");
							String queueSizeServiceDesk=xssRequest.getParameter("queueSizeServiceDesk");
							if(StringUtils.isEmpty(IUMGroupServiceDesk)){IUMGroupDisableServiceDesk=queueSizeServiceDesk="";}
							/*
							IUMGroupCore
							IUMGroupDisableCore
							queueSizeCore
							*/
							String IUMGroupCore=xssRequest.getParameter("IUMGroupCore");
							String IUMGroupDisableCore=xssRequest.getParameter("IUMGroupDisableCore");
							String queueSizeCore=xssRequest.getParameter("queueSizeCore");
							if(StringUtils.isEmpty(IUMGroupCore)){IUMGroupDisableCore=queueSizeCore="";}

							//1. Prepare IUMGroup
							String IUMGroup = (IUMGroupSoftware != null ? IUMGroupSoftware : "") + "," +
									(IUMGroupServiceDesk != null ? IUMGroupServiceDesk : "") + "," +
									(IUMGroupCore != null ? IUMGroupCore : "");
							//2. Prepare IUMGroupDIS
							String IUMGroupDIS = (IUMGroupDisableSoftware != null ? IUMGroupDisableSoftware : "") + "," +
									(IUMGroupDisableServiceDesk != null ? IUMGroupDisableServiceDesk : "") + "," +
									(IUMGroupDisableCore != null ? IUMGroupDisableCore : "");
							//2. Prepare queueSize
							String queueSize = (queueSizeSoftware != null ? queueSizeSoftware : "") + "," +
									(queueSizeServiceDesk != null ? queueSizeServiceDesk : "") + "," +
									(queueSizeCore != null ? queueSizeCore : "");

							setValue("IUMGroup", IUMGroup);
							setValue("IUMGroupDIS", IUMGroupDIS);
							setValue("queueSize", queueSize);

							patchGroupsForSyncJob(IUMGroupDIS);

							String duration = xssRequest.getParameter("duration");
							setValue("duration", duration);

							renderAdminVM(response, this.i18nHelper.getText("de.accxia.apps.jira.IUM.save.group"),null, page ,showSideLicense);
						}catch (Exception e){
							LOG.error("Exception: "+e.getMessage(),e);
							renderAdminVM(response, null, e.getMessage(),page ,showSideLicense);
						}
						return;

					}
					case PageRest:{
						try {
							String urlRest = xssRequest.getParameter("urlRest");
							setValue(DAO.REST_ROUTE, urlRest);

							RestRoute.getInstance().updateRestRoute(urlRest);
							renderAdminVM(response, this.i18nHelper.getText("de.accxia.apps.jira.IUM.save.rest"),null, page ,showSideLicense);
						}catch (Exception e){
							LOG.error("Exception: "+e.getMessage(),e);
							renderAdminVM(response, null, e.getMessage(),page ,showSideLicense);
						}
						return;
					}
					case PageJob:{
						try {
							boolean shouldRestart= false;
							String repeatInterval = xssRequest.getParameter("repeatInterval");
							if(repeatInterval!=null && !repeatInterval.equalsIgnoreCase(DAO.getRepeatInterval())){

								try{
									Long.parseLong(repeatInterval);
									DAO.updateRepeatInterval(repeatInterval);
								}catch (Exception e){
									repeatInterval =null;
									LOG.error("Exception "+e.getMessage(),e);
								}

								shouldRestart =true;
							}
							String inactivityDuration = xssRequest.getParameter("inactivityDuration");
							if(inactivityDuration!=null && repeatInterval!=null && !inactivityDuration.equalsIgnoreCase(DAO.getInactivityDuration())){

								try{
									Long.parseLong(inactivityDuration);
									DAO.updateInactivityDuration(inactivityDuration);
								}catch (Exception e){
									inactivityDuration =null;
									LOG.error("Exception "+e.getMessage(),e);
								}

								shouldRestart =true;
							}

							String startingFrom = xssRequest.getParameter("startingFrom");
							if(startingFrom!=null && ! startingFrom.equalsIgnoreCase(DAO.getStartingFrom())){
								try{
									Long.parseLong(startingFrom);
									DAO.updateStartingFrom(startingFrom);
								}catch (Exception e){
									startingFrom =null;
									LOG.error("Exception "+e.getMessage(),e);
								}

								shouldRestart=true;
							}


							String workingJob = xssRequest.getParameter("workingJob");

							if ((workingJob != null) && "on".equalsIgnoreCase(workingJob)) {
								DAO.updateWorkingJob(workingJob);
								if (shouldRestart || !jobClusterService.isWorking()) {
									//TODO error analyse case
									LOG.warn("Start JobClusterService " + (new Date()));
									jobClusterService.start();
									iumListener.publishJobNotification(true);
								}
							} else if (workingJob == null || ("off".equalsIgnoreCase(workingJob))) {
								DAO.updateWorkingJob("off");
								if (jobClusterService.isWorking()) {
									//TODO error analyse case
									LOG.warn("Stop JobClusterService " + (new Date()));
									jobClusterService.stop();
									iumListener.publishJobNotification(false);
								}
							}

							renderAdminVM(response, this.i18nHelper.getText("de.accxia.apps.jira.IUM.save.job"),null, page ,showSideLicense);
						}catch (Exception e){
							LOG.error("Exception: "+e.getMessage(),e);
							renderAdminVM(response, null, e.getMessage(),page ,showSideLicense);
						}
						return;
					}
					case PageSync:{
						try {
							String syncSoftwareSrcGroup=xssRequest.getParameter(DAO.SYNC_SOFTWARE_SRC_GROUP +"-groups");
							String syncSoftwareTargetGroup=xssRequest.getParameter(DAO.SYNC_SOFTWARE_TARGET_GROUP+"-groups");
							String syncSDeskSrcGroup=xssRequest.getParameter(DAO.SYNC_SERVICE_DESK_SRC_GROUP +"-groups");
							String syncSDeskTargetGroup=xssRequest.getParameter(DAO.SYNC_SERVICE_DESK_TARGET_GROUP+"-groups");

							// fix multiselect "," ==> ";"
							if(syncSoftwareSrcGroup!=null){syncSoftwareSrcGroup=syncSoftwareSrcGroup.replaceAll(",",";");}
							if(syncSDeskSrcGroup!=null){syncSDeskSrcGroup=syncSDeskSrcGroup.replaceAll(",",";");}
							boolean shouldRestart= false;
							if(!DAO.getSyncSoftwareSrcGoups().equals(syncSoftwareSrcGroup)){
								DAO.updateSyncSoftwareSrcGoups(syncSoftwareSrcGroup);
								shouldRestart=true;
							}

							if(!DAO.getSyncSoftwareTargetGoups().equals(syncSoftwareTargetGroup)){
								DAO.updateSyncSoftwareTargetGoups(syncSoftwareTargetGroup);
								shouldRestart=true;
							}

							if(!DAO.getSyncSDeskSrcGoups().equals(syncSDeskSrcGroup)){
								DAO.updateSyncSDeskSrcGoups(syncSDeskSrcGroup);
								shouldRestart=true;
							}
							if(!DAO.getSyncSDeskTargetGoups().equals(syncSDeskTargetGroup)){
								DAO.updateSyncSDeskTargetGoups(syncSDeskTargetGroup);
								shouldRestart=true;
							}


							String repeatInterval = xssRequest.getParameter(DAO.SYNC_REPEAT_INTERVAL);
							if(repeatInterval!=null && !repeatInterval.equalsIgnoreCase(DAO.getSyncRepeatInterval())){

								try{
									Long.parseLong(repeatInterval);
									DAO.updateSyncRepeatInterval(repeatInterval);
								}catch (Exception e){
									repeatInterval =null;
									LOG.error("Exception "+e.getMessage(),e);
								}

								shouldRestart =true;
							}

							String startingFrom = xssRequest.getParameter(DAO.SYNC_STARTING_FROM);
							if(startingFrom!=null && ! startingFrom.equalsIgnoreCase(DAO.getSyncStartingFrom())){
								try{
									Long.parseLong(startingFrom);
									DAO.updateSyncStartingFrom(startingFrom);
								}catch (Exception e){
									startingFrom =null;
									LOG.error("Exception "+e.getMessage(),e);
								}

								shouldRestart=true;
							}


							String workingJob = xssRequest.getParameter(DAO.WORKING_SYNC_JOB);

							if ((workingJob!=null) && "on".equalsIgnoreCase(workingJob)){
								DAO.updateSyncWorkingJob(workingJob);
								if (shouldRestart || !jobSyncService.isWorking()) {
									//TODO error analyse case
									LOG.warn("Start JobClusterService " + (new Date()));
									jobSyncService.start();
									iumListener.publishSyncJobNotification(true);
								}
							}else if(workingJob==null || ("off".equalsIgnoreCase(workingJob))){
								DAO.updateSyncWorkingJob("off");
								if (jobSyncService.isWorking()) {
									//TODO error analyse case
									LOG.warn("Stop JobClusterService "+ (new Date()));
									jobSyncService.stop();
									iumListener.publishSyncJobNotification(false);
								}
							}

							renderAdminVM(response, this.i18nHelper.getText("de.accxia.apps.jira.IUM.save.sync"),null, page ,showSideLicense);
						}catch (Exception e){
							LOG.error("Exception: "+e.getMessage(),e);
							renderAdminVM(response, null, e.getMessage(),page ,showSideLicense);
						}
						return;
					}
					case PageDesign:{
						//logo
						try{
							String urlLogo = xssRequest.getParameter("urlLogo");
							urlLogo = setValue("urlLogo", urlLogo);

							String queueMessage = xssRequest.getParameter("queueMessage");
							//default value
							if (StringUtils.isEmpty(queueMessage)){
								queueMessage=this.i18nHelper.getText("IUM-queueMessage.default");
							}
							queueMessage = setValue("queueMessage", queueMessage);

							renderAdminVM(response, this.i18nHelper.getText("de.accxia.apps.jira.IUM.save.design"),null, page ,showSideLicense);
						}catch (Exception e){
							LOG.error("Exception: "+e.getMessage(),e);
							renderAdminVM(response, null, e.getMessage(),page ,showSideLicense);
						}
						return;
					}
					case PageLogging:{
						//audit

							try {
								if(isJira8x()) {
									String audit = xssRequest.getParameter("audit");
									if (audit != null && "on".equalsIgnoreCase(audit)) {
										setAuditUserManagement(EffectiveCoverageLevelMock.BASE());
									} else {
										setAuditUserManagement(EffectiveCoverageLevelMock.OFF());
									}
								}

								String logger = xssRequest.getParameter("logger");
								if (logger != null && "on".equalsIgnoreCase(logger)) {
									setDebugLogger(true);
								} else {
									setDebugLogger(false);
								}

								renderAdminVM(response, this.i18nHelper.getText("de.accxia.apps.jira.IUM.save.logging"), null, page, showSideLicense);
							} catch (Exception e) {
								LOG.error("Exception: " + e.getMessage(), e);
								renderAdminVM(response, null, e.getMessage(), page, showSideLicense);
							}
							return;
						}
				}

				renderAdminVM(response,null,null, page ,showSideLicense);

		} catch (WebSudoSessionException wes) {
			LOG.error("Exception:" + wes.getMessage(),wes);
			// Send an error or redirect the user to the initial form.
			// response.sendError(HttpServletResponse.SC_FORBIDDEN);
			webSudoManager.enforceWebSudoProtection(request, response);
		}
	}

	//check if non empty groups is in list
	private void patchGroupsForSyncJob(String iumDisableGroups) {
		if (iumDisableGroups == null || iumDisableGroups.length() == 1) {
			return;
		}

		boolean shouldRestart= false;
		String[] disableGroups = iumDisableGroups.split(",") ;
		//disableGroups[0] -- SyncSoftware
		if (!containsNonEmptyGroup(disableGroups, DAO.getSyncSoftwareTargetGoups())) {
			DAO.updateSyncSoftwareTargetGoups("");
			shouldRestart = true;
		}
		//disableGroups[1] -- SyncSoftware
		if (!containsNonEmptyGroup(disableGroups, DAO.getSyncSDeskTargetGoups())) {
			DAO.updateSyncSDeskTargetGoups("");
			shouldRestart = true;
		}

		//	//disableGroups[2] -- CoreSoftware
		//	if (!containsNonEmptyGroup(disableGroups, DAO.getSyncSDeskTargetGoups())) {
		//		DAO.updateSyncSDeskTargetGoups("");
		//		shouldRestart=true;
		//	}


		if(shouldRestart){
			//change config
			if (jobSyncService.isWorking()) {
				this.jobSyncService.start();
			}
		}
	}

	private boolean containsNonEmptyGroup(String[] arrays, String value){
		//
		if(value == null || value.length()==0){
			return  true;
		}

		for (int i=0;i<arrays.length;i++){
			if(value.equalsIgnoreCase(arrays[i])){
				return true;
			}
		}
		return false;
	}

	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		try {
			//xss wrapper
			XSSHttpServletRequestWrapper xssRequest = new XSSHttpServletRequestWrapper(request);

			UserKey userKey = userManager.getRemoteUserKey();
			if (userKey == null || !userManager.isAdmin(userKey)) {
				redirectToLogin(xssRequest, response);
				return;
			}

			webSudoManager.willExecuteWebSudoRequest(xssRequest);
			String pageId=xssRequest.getParameter("page");

            Page page = Page.getPage(pageId);
			if (page == Page.PageLicense) {
    			renderSideLicenseVM(response);
				return;
    		}

			boolean showSideLicense = (!("".equals(DAO.getSideLicense())));
			if (!ConditionEvaluatorImpl.isLicenseValid()) {
				renderLicenseErrorVM(response, showSideLicense);
				return;
			}

			switch (page){
				case PageGroupSettings:
				case PageDesign:
				case PageRest:
				case PageLicense:{
					renderAdminVM(response,page, showSideLicense);
					return;
				}
				case PageSAMLSSO:{
					renderSamlVM(response);
					return;
				}
			}

			renderAdminVM(response,page, showSideLicense);

		} catch (WebSudoSessionException wes) {
			LOG.error("Exception:" + wes.getMessage(),wes);
			// Send an error or redirect the user to the initial form.
			//response.sendError(HttpServletResponse.SC_FORBIDDEN);
			webSudoManager.enforceWebSudoProtection(request, response);
		}	
	}
	
	private void renderLicenseErrorVM(HttpServletResponse response, boolean showSideLicense) throws IOException {
		Map<String, Object> context = new HashMap<String, Object>();
		context.put("showSideLicense", showSideLicense);
		context.put("baseurl", this.applicationProperties.getBaseUrl());

		response.setContentType("text/html;charset=utf-8");
		renderer.render("templates/checklicense_IUM.vm", context, response.getWriter());
	}

	private void renderAdminVM(HttpServletResponse response, Page page, boolean showSideLicense) throws IOException {
		renderAdminVM(response,null,null,page,showSideLicense);
	}
	private void renderAdminVM(HttpServletResponse response, String successMessage,String errorMessages, Page page, boolean showSideLicense) throws IOException {
		Map<String, Object> context = new HashMap<String, Object>();
		context.put("successMessage", successMessage);
		context.put("showSideLicense", showSideLicense);

		if (page == Page.PageGroupSettings) {
			addGroupSettings(context);
		}

		// added for enhanced mode
		context.put("testing", Constants.TESTING);

		// added for enhanced mode
		if (ConditionEvaluatorImpl.getSideLicense()!=null) {
			context.put("enhanced", ConditionEvaluatorImpl.getSideLicense().getAppKey().contains("Enhanced"));
		}

		context.put("isJira8", isJira8x());
		if(isJira8x()) {
			context.put("audit", EffectiveCoverageLevelMock.OFF().equalsIgnoreCase(getAuditUserManagement()) ? Boolean.FALSE : Boolean.TRUE);
		}

		if (page == Page.PageDesign) {
			String urlLogo = DAO.getValue("urlLogo");
			String queueMessage = DAO.getValue("queueMessage");

			context.put("urlLogo",StringUtils.isEmpty(urlLogo) ? "" : urlLogo);

			//default value
			if (StringUtils.isEmpty(queueMessage)){
				queueMessage=this.i18nHelper.getText("IUM-queueMessage.default");
				queueMessage=setValue("queueMessage", queueMessage);
			}

			context.put("queueMessage",queueMessage);
		}

		if (page == Page.PageRest) {
			String urlRest = DAO.getValue(DAO.REST_ROUTE);
			//Fix older version that define /api/rest
			if (!StringUtils.isEmpty(urlRest)) {
				urlRest = RestRoute.removeDefaultRoute(urlRest);
			}
			context.put("urlRest", StringUtils.isEmpty(urlRest) ? "" : urlRest);
		}
		if (page == Page.PageJob) {
			context.put("repeatInterval",DAO.getRepeatInterval());
			context.put("inactivityDuration",DAO.getInactivityDuration());
			context.put("startingFrom",DAO.getStartingFrom());

			//context.put("startingAt",startingAt);
			//context.put("duration",DAO.getDuration());

			context.put("serverTime", SDF.format(new Date()));
			context.put("workingJob", jobClusterService.isWorking());
			if(jobClusterService.getNextRunDate()!=null) {
				context.put("nextRunDate", SDF.format(jobClusterService.getNextRunDate()));
			}
			if(jobClusterService.getLastSuccessfulRunForJob()!=null) {
				context.put("runDetails",new RunDetailsBean(jobClusterService.getLastSuccessfulRunForJob()));
			}
		}

		if (page == Page.PageSync) {
			context.put(DAO.SYNC_REPEAT_INTERVAL,DAO.getSyncRepeatInterval());
			context.put(DAO.SYNC_STARTING_FROM,DAO.getSyncStartingFrom());

			//context.put("startingAt",startingAt);
			//context.put("duration",DAO.getDuration());

			context.put("serverTime", SDF.format(new Date()));
			context.put("maxRules", DAO.getIUMGroups()!=null ? (DAO.getIUMGroups().split(",").length) : 1);
			context.put(DAO.WORKING_SYNC_JOB, jobSyncService.isWorking());
			if(jobSyncService.getNextRunDate()!=null) {
				context.put("nextRunDate", SDF.format(jobSyncService.getNextRunDate()));
			}
			if(jobSyncService.getLastSuccessfulRunForJob()!=null) {
				context.put("runDetails",new RunDetailsBean(jobSyncService.getLastSuccessfulRunForJob()));
				context.put("lastSuccessfulRunDate", SDF.format(jobSyncService.getLastSuccessfulRunForJob().getStartTime()));
			}
			addSyncGroups(context);

			addLatestSyncResults(context);
		}

		if (page == Page.PageLogging) {
			context.put("logger", getDebugLogger());
		}


		response.setContentType("text/html;charset=utf-8");
		renderer.render("templates/"+page.pageName, context, response.getWriter());
	}



	@WebSudoRequired
	private void addGroupSettings(Map<String, Object> context) {
//		List<IUMGroup> groupPairs = new ArrayList<>();

		String wvg = DAO.getIUMGroups();
		String iumGroups[]=StringUtils.isEmpty(wvg) ? (new String[0]) : wvg.split(",",-1);

		wvg = DAO.getIUMGroupsDisabled();
		String iumGroupDISs[]=StringUtils.isEmpty(wvg)  ? (new String[0]) : wvg.split(",",-1);

		wvg = DAO.getValue("queueSize");
		String queueSizes[]=StringUtils.isEmpty(wvg)  ? (new String[0]) : wvg.split(",",-1);

//		for(int i=0;i<iumGroups.length;i++){
//			groupPairs.add(new IUMGroup(iumGroups[i],
//					(iumGroupDISs.length>i ? iumGroupDISs[i]:""),
//					(queueSizes.length>i ? safeParseInt(queueSizes[i],1):0)
//			));
//		}


		String duration =DAO.getValue("duration");
		context.put("duration",StringUtils.isEmpty(duration) ? "24" : duration);

		ServiceOutcome<ApplicationRole> applicationRoleOutcome =null;

		try{

			//1.Jira Software, key=jira-software
			applicationRoleOutcome = this.applicationRoleAdminService.getRole(ApplicationKeys.SOFTWARE);
			if(applicationRoleOutcome.isValid()){
				context.put("hasSoftware",Boolean.TRUE);
				context.put("groupsSoftware",IntelligentUserManagerConfigServlet.convertGroupToListOfString(applicationRoleOutcome.get().getGroups()));
				context.put("groupsSoftwareSeats",(applicationRoleOutcome.get().getNumberOfSeats()==-1 ? Integer.valueOf(50000) : applicationRoleOutcome.get().getNumberOfSeats()));

				context.put("IUMGroupSoftware", iumGroups.length>0 ? iumGroups[0]:"");
				context.put("IUMGroupDisableSoftware", iumGroupDISs.length>0 ? iumGroupDISs[0]:"");
				context.put("queueSizeSoftware", queueSizes.length>0 ? queueSizes[0]:"");

			}
			//1.Jira Service Management, key=jira-servicedesk
			applicationRoleOutcome = this.applicationRoleAdminService.getRole(ApplicationKeys.SERVICE_DESK);
			if(applicationRoleOutcome.isValid()){
				context.put("hasServiceDesk",Boolean.TRUE);
				context.put("groupsServiceDesk",IntelligentUserManagerConfigServlet.convertGroupToListOfString(applicationRoleOutcome.get().getGroups()));
				context.put("groupsServiceDeskSeats",(applicationRoleOutcome.get().getNumberOfSeats()==-1 ? Integer.valueOf(50000): applicationRoleOutcome.get().getNumberOfSeats()));

				context.put("IUMGroupServiceDesk", iumGroups.length>1 ? iumGroups[1]:"");
				context.put("IUMGroupDisableServiceDesk", iumGroupDISs.length>1 ? iumGroupDISs[1]:"");
				context.put("queueSizeServiceDesk", queueSizes.length>1 ? queueSizes[1]:"");

			}

			//3.Jira Core, key=jira-core
			applicationRoleOutcome = this.applicationRoleAdminService.getRole(ApplicationKeys.CORE);
			if(applicationRoleOutcome.isValid()){
				context.put("hasCore",Boolean.TRUE);
				context.put("groupsCore",IntelligentUserManagerConfigServlet.convertGroupToListOfString(applicationRoleOutcome.get().getGroups()));
				context.put("groupsCoreSeats",applicationRoleOutcome.get().getNumberOfSeats());

				context.put("IUMGroupCore", iumGroups.length>2 ? iumGroups[2]:"");
				context.put("IUMGroupDisableCore", iumGroupDISs.length>2 ? iumGroupDISs[2]:"");
				context.put("queueSizeCore", queueSizes.length>2 ? queueSizes[2]:"");
			}

		}catch (Exception e){
			LOG.error("Exception: "+e.getMessage(),e);
		}

	}

	@WebSudoRequired
	private void addSyncGroups(Map<String, Object> context) {
		try{
			//1.Jira Software, key=jira-software
			ServiceOutcome<ApplicationRole>  applicationSoftwareRoleOutcome = this.applicationRoleAdminService.getRole(ApplicationKeys.SOFTWARE);
			ServiceOutcome<ApplicationRole>  applicationSDeskRoleOutcome= this.applicationRoleAdminService.getRole(ApplicationKeys.SERVICE_DESK);

			String wvg = DAO.getIUMGroupsDisabled();
			String iumGroupDISs[]=StringUtils.isEmpty(wvg)  ? (new String[0]) : wvg.split(",",-1);


			if(applicationSoftwareRoleOutcome.isValid()){
				context.put("hasSoftware",Boolean.TRUE);

				String syncSoftwareSrcGroups =DAO.getSyncSoftwareSrcGoups();
				String syncSoftwareTargetGroups =DAO.getSyncSoftwareTargetGoups();

				context.put(DAO.SYNC_SOFTWARE_SRC_GROUP,(syncSoftwareSrcGroups!=null ? syncSoftwareSrcGroups.replaceAll(";",","):""));
				context.put(DAO.SYNC_SOFTWARE_TARGET_GROUP,syncSoftwareTargetGroups);

				//context.put("validSyncSrcSoftwareGroups",IntelligentUserManagerConfigServlet.convertGroupToString(groups));
				context.put("validSyncTargetSoftwareGroups", (iumGroupDISs.length > 0 ? iumGroupDISs[0] : ""));

			}else{
				context.put("hasSoftware",Boolean.FALSE);
			}

			if(applicationSDeskRoleOutcome.isValid()){
				context.put("hasServiceDesk",Boolean.TRUE);

				String syncSDeskSrcGoups =DAO.getSyncSDeskSrcGoups();
				String syncSDeskTargetGoups =DAO.getSyncSDeskTargetGoups();

				context.put(DAO.SYNC_SERVICE_DESK_SRC_GROUP,(syncSDeskSrcGoups!=null ? syncSDeskSrcGoups.replaceAll(";",","):""));
				context.put(DAO.SYNC_SERVICE_DESK_TARGET_GROUP,syncSDeskTargetGoups);

				//context.put("validSyncSrcSDeskGroups",IntelligentUserManagerConfigServlet.convertGroupToString(groups));
				context.put("validSyncTargetSDeskGroups", (iumGroupDISs.length > 1 ? iumGroupDISs[1] : ""));

			}else{
				context.put("hasServiceDesk",Boolean.FALSE);
			}

			context.put("hasCore",Boolean.FALSE);

		}catch (Exception e){
			LOG.error("Exception: "+e.getMessage(),e);
		}

	}


	private void addLatestSyncResults(Map<String, Object> context) {
		List<JobResultDTO> jobResultDTOList= this.jobSyncService.findLatest(0,10);
		customProcessJobResult(jobResultDTOList);
		context.put("jobResults",jobResultDTOList);

	}

	private void customProcessJobResult(List<JobResultDTO> jobResultDTOList) {
		for (JobResultDTO jobResult:jobResultDTOList) {
			if(jobResult.getSourceGroups()!=null) {
				String tmpSourceGroups[] = jobResult.getSourceGroups().split(";");
				jobResult.setShortSourceGroups(tmpSourceGroups.length > 0 ? tmpSourceGroups[0] : "");
				jobResult.setSourceGroups(jobResult.getSourceGroups().replaceAll(";", ",&nbsp; "));
			}

			if(jobResult.getTargetGroup()!=null) {
				String tmpTargetGroup[]= jobResult.getTargetGroup().split(";");
				jobResult.setShortTargetGroup(tmpTargetGroup.length>0 ? tmpTargetGroup[0]:"");
				jobResult.setTargetGroup(jobResult.getTargetGroup().replaceAll(";",",,&nbsp; "));
			}
		}
	}

	private static List<String> convertGroupToListOfString(Set<Group> groups ){
		if(groups == null){
			return Collections.EMPTY_LIST;
		}
		List<String> retVal = groups.stream().map(Group::getName).collect(Collectors.toList());
		retVal.add(0,"");


		return retVal;

	}

	private static String convertGroupToString(Set<Group> groups){
		if(groups == null){
			return "";
		}
		String retVal = groups.stream().map(Group::getName).collect(Collectors.joining(","));

		return retVal;

	}

	private void renderSamlVM(HttpServletResponse response) throws IOException {
		renderSamlVM(response,null,null);
	}
	private void renderSamlVM(HttpServletResponse response, String successMessage,String errorMessages) throws IOException {
		Map<String, Object> context = new HashMap<String, Object>();

		context.put("samlIdp", DAO.getSamlIdp());
		context.put("samlMapping",  DAO.getSamlMapping());
		context.put("successMessage", successMessage);
		context.put("errorMessages", errorMessages);
		renderer.render("templates/SAML_IUM.vm", context, response.getWriter());
	}

	private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.sendRedirect(loginUriProvider.getLoginUri(getUri(request)).toASCIIString());
	}

	private void forceToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
		URI origin = getUri(request);
		request.getSession().invalidate();
		response.sendRedirect(loginUriProvider.getLoginUri(origin).toASCIIString());
	}

	private URI getUri(HttpServletRequest request) {
		StringBuffer builder = request.getRequestURL();
		if (request.getQueryString() != null) {
			builder.append("?");
			builder.append(request.getQueryString());
		}
		return URI.create(builder.toString());
	}

	private void renderSideLicenseVM(HttpServletResponse response) throws IOException {
		renderSideLicenseVM(response,null,null);
	}
	private void renderSideLicenseVM(HttpServletResponse response,String successMessage,String errorMessages) throws IOException {
		Map<String, Object> context = new HashMap<String, Object>();
		context.put("sideLicense", getSideLicense());
		context.put("successMessage", successMessage);
		context.put("errorMessages", errorMessages);

		response.setContentType("text/html;charset=utf-8");
		renderer.render("templates/sidelicense_IUM.vm", context, response.getWriter());
	}

	public String setValue(String key, String value) {
		if (value == null) value = "";

		DAO.setValue(key, value);
		return (value);
	}

	private static int safeParseInt(String value, int defValue){
		if(org.apache.commons.lang3.StringUtils.isEmpty(value)){
			return defValue;
		}

		try{
			return  Integer.parseInt(value);
		}catch (Exception e){
			LOG.error("Exception: "+e.getMessage(),e);
		}

		return defValue;
	}

	private boolean isEmpty(String contextPath) {
		return contextPath == null || contextPath.isEmpty();
	}

	public String getSideLicense() {
		String sideLicense = DAO.getSideLicense();


		if(LOG.isDebugEnabled()){
			LOG.debug("sideLicense= " + sideLicense);
		}
		return sideLicense;
	}

	public void setSideLicense(String sideLicense) {
		DAO.updateSideLicense(sideLicense);

	}

	public void deleteSideLicense() {
		DAO.updateSideLicense(null);
	}

	/*Helpers for get/set AuditUserManagement*/
	private String getAuditUserManagement(){
		PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
		return (String)settings.get(AUDIT_USER_MANAGEMENT);
	}


	private void  setAuditUserManagement(String key){
		PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
		settings.put("com.atlassian.audit.plugin:audit-config:coverage:user_management"  , key);
	}

	//debugging info

	private void setDebugLogger(boolean b) {
		DAO.updateLoggerLevel(b);
		this.loggingManager.setLogLevel(DAO.LOGGER_KEY,b ? "DEBUG":"INFO");
	}

	private static boolean getDebugLogger() {
		org.apache.log4j.Logger logger = getLogger(DAO.LOGGER_KEY);
		if(LOG.isWarnEnabled()){
			LOG.warn("IntelligentUserManagerConfigServlet=" + ((logger !=null &&  logger.getLevel()!=null) ? logger.getLevel().toString():"NULL"));
		}
		if(logger== null || logger.getLevel()==null){
			return false;
		}

		return  logger.getLevel()== org.apache.log4j.Level.DEBUG;
	}

	private static org.apache.log4j.Logger getLogger(String loggerName) {
		return "root".equals(loggerName) ? org.apache.log4j.Logger.getRootLogger() : org.apache.log4j.Logger.getLogger(loggerName);
	}
	private boolean isJira8x(){
		// [8, 22, 3]
		int[] versions= this.buildUtilsInfo.getVersionNumbers();
		if(versions !=null && versions.length>0 && versions[0]>7){
			return true;
		}

		return false;
	}
}
