package de.accxia.jira.addon.IUM.job;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import de.accxia.jira.addon.IUM.model.NavUserDTO;
import de.accxia.jira.addon.IUM.repository.JobResultRepository;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import de.accxia.jira.addon.IUM.servlet.session.AccxiaUserSessionTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.*;

public class IUMClusterJob implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMClusterJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private static IUMClusterJob instance;

    private PocketRepository pocketRepository;
    private JobResultRepository jobResultRepository;
    private JobSyncService jobSyncService;
    private IUMClusterJob(){}

    //singleton pattern
    public static IUMClusterJob getInstance() {
        if (instance == null)
            instance = new IUMClusterJob();

        return instance;
    }

    @Override
    public void injectService(PocketRepository pocketRepository, JobResultRepository jobResultRepository){
        this.instance.pocketRepository=pocketRepository;
        this.instance.jobResultRepository=jobResultRepository;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) throws RemoveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("IUMSyncJob Process #[" + SDF.format(new java.util.Date())+"] " );
        }
        List<ProcessResult> processResultList = new ArrayList<>();

        long inactivityInterval = (Long) parameters.get(JobData.USER_INACTIVITY_INTERVAL);
        if (inactivityInterval <= 0) {
            inactivityInterval = JobData.DEFAULT_USER_INACTIVITY_INTERVAL;
        }

        String enableGroups = (String) parameters.get(JobData.ENABLE_GROUPS);
        //String disableGroups =(String) parameters.get(JobData.DISABLE_GROUPS);

        if (LOG.isDebugEnabled()) {
            LOG.debug("IUMClusterJob Process with groups={} interval={} at [ {} ] ",new Object[]{
                    enableGroups,
                    inactivityInterval,
                    SDF.format(new Date())
            });
        }

        ProcessResult processResult = new ProcessResult(Process.CLEAN_JOB, (String) parameters.get(JobData.ENABLE_GROUPS),(String) parameters.get(JobData.DISABLE_GROUPS));

        if(pocketRepository!=null) {
            String[] arrayEnableGroups = isEmpty(enableGroups) ? null : enableGroups.split(",");
            Timestamp ts = new Timestamp(new Date().getTime() - inactivityInterval);

            if (LOG.isDebugEnabled()) {
                LOG.debug("IUMClusterJob Process with groups={} interval={} at [ {} ] ", new Object[]{
                        enableGroups,
                        inactivityInterval,
                        SDF.format(new java.util.Date())
                });
            }

            GroupManager groupManager = ComponentAccessor.getGroupManager();
            UserManager userManager = ComponentAccessor.getUserManager();
            UserUtil userUtil = ComponentAccessor.getUserUtil();

            //compute list with inactive users
            Map<String, List<NavUserDTO>> usersEnabled = new HashMap<>();
            long now = new Date().getTime();
            if (arrayEnableGroups != null) {
                AccxiaUserSessionTracker accxiaUserSessionTracker = AccxiaUserSessionTracker.getInstance();

                for (String group : arrayEnableGroups) {
                    int count = groupManager.getUsersInGroupCount(group);
                    int cnt = 100;
                    // add user active = false
                    if(count ==0) count=cnt;
                    for(int i=0;i<count;i+=cnt){
                        List<NavUserDTO> oldestUsers = pocketRepository.getNavUserDisableForGroupLtTime(group,ts,i,cnt);
                        for (NavUserDTO oldestUser : oldestUsers) {
                            doAddUserActive(oldestUser, group, usersEnabled);
                        }
                    }
                }

                processResult.setUserRemoved(0);
                //remove from ium_enable
                for (Map.Entry<String, List<NavUserDTO>> userEnabled : usersEnabled.entrySet()) {
                    if (userEnabled.getValue().size() > 0) {
                        for (NavUserDTO navUser : userEnabled.getValue()){
                            if(navUser.getGroupNameEx()!=null){
                                try {
                                    userUtil.removeUserFromGroup(groupManager.getGroup(navUser.getGroupNameEx()), userManager.getUserByName(userEnabled.getKey()));
                                    processResult.setUserRemoved(processResult.getUserRemoved()+1);
                                    if (LOG.isInfoEnabled()) {
                                        LOG.info("IUMClusterJob removed user {} from group {} ", new Object[]{
                                                userEnabled.getKey(),navUser.getGroupNameEx()
                                        });
                                    }
                                } catch (Exception e) {
                                    LOG.error("Exception[removeUserFromGroup]: " + e.getMessage(), e);
                                }
                            }
                        }
                    }

                    for (NavUserDTO navUser : userEnabled.getValue()) {
                        if(navUser.getID()!=null && navUser.getUserName()!=null && navUser.getSessionId()!=null){
                            try {
                                if (LOG.isInfoEnabled()) {
                                    LOG.info("IUMJob markSessionAsInvalid user {} from sessionId {} ", new Object[]{navUser.getUserName(), navUser.getSessionId()});
                                }

                                accxiaUserSessionTracker.markSessionAsInvalid(navUser.getSessionId());
                            } catch (Exception e) {
                                LOG.error("Exception[markSessionAsInvalid]: " + e.getMessage(), e);
                            }
                        }
                    }
                }
            }
        }

        if (LOG.isDebugEnabled()) {
            LOG.debug("IUMClusterJob Processed #[" + SDF.format(new java.util.Date())+"] " );
        }

        processResultList.add(processResult);
        return processResultList;
    }

    private static boolean isEmpty(String value){
        return value == null || value.length()==0;
    }
    private void doAddUserActive(NavUserDTO navUser, String group, Map<String, List<NavUserDTO>> usersEnabled) {
        String userName = navUser.getUserName() == null ? navUser.getUserNameEx():navUser.getUserName();
        if (userName != null) {
            if(navUser.getGroupNameEx()==null){
                navUser.setGroupNameEx(group);
            }
            if (!usersEnabled.containsKey(userName)) {
                usersEnabled.put(userName, new ArrayList<>());
            }
            List<NavUserDTO> userActiveList = usersEnabled.get(userName);
            userActiveList.add(navUser);
        }
    }
}
