package de.accxia.jira.addon.IUM.job;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Sets;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.repository.JobResultRepository;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

public class IUMDailyJob  implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMDailyJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private static IUMDailyJob instance;

    private PocketRepository pocketRepository;
    private JobResultRepository jobResultRepository;
    private ApplicationRoleManager applicationRoleManager;
    private static UserUtil userUtil = ComponentAccessor.getUserUtil();

    private IUMDailyJob(){}

    //singleton pattern
    public static IUMDailyJob getInstance() {
        if (instance == null)
            instance = new IUMDailyJob();

        return instance;
    }

    public void injectService(PocketRepository pocketRepository, JobResultRepository jobResultRepository){
        this.instance.pocketRepository=pocketRepository;
        this.instance.jobResultRepository=jobResultRepository;
    }

    public void injectService( ApplicationRoleManager applicationRoleManager){
        this.instance.applicationRoleManager=applicationRoleManager;

    }

    int syncUsers = 0;
    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) throws RemoveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("IUMDailyJob Process #[" + SDF.format(new java.util.Date())+"] " );
        }
        List<ProcessResult> processResultList = new ArrayList<>();

        String sourceGroups = DAO.getIUMGroups();
        String targetGroup = DAO.getIUMGroupsDisabled();

        if (LOG.isDebugEnabled()) {
            LOG.debug("IUMDailyJob Sync groups = {} -> {}  at [ {} ] ",new Object[]{
                    sourceGroups,
                    targetGroup,
                    SDF.format(new Date())
            });
        }

        if(jobResultRepository!=null && ! StringUtils.isEmpty(sourceGroups) && !StringUtils.isEmpty(targetGroup)) {

            String iumGroups[]= sourceGroups.split(",");
            String iumGroupDISs[]= targetGroup.split(",");

            GroupManager groupManager = ComponentAccessor.getGroupManager();
            UserManager userManager = ComponentAccessor.getUserManager();
            UserUtil userUtil = ComponentAccessor.getUserUtil();

            //1.Jira Software, key=jira-software
            if(iumGroups.length>0 && iumGroupDISs.length>0){
                Set<ApplicationUser> userJiraAccess=this.getUsersWithJiraAccessExceptGroup(iumGroups[0]);

                ProcessResult processResult= processPair(groupManager,userUtil,iumGroups[0],iumGroupDISs[0],userJiraAccess);
                processResultList.add(processResult);
            }
            //2.Jira Service Management, key=jira-servicedesk
            if(iumGroups.length>1 && iumGroupDISs.length>1){
                Set<ApplicationUser> userSDeskAccess=this.getUsersWithSDeskAccessExceptGroup(iumGroups[1]);
                ProcessResult processResult= processPair(groupManager,userUtil,iumGroups[1],iumGroupDISs[1],userSDeskAccess);
                processResultList.add(processResult);
            }

            if (LOG.isDebugEnabled()) {
                LOG.debug("IUMDailyJob copied #" + syncUsers+" to group "+targetGroup );
            }

        }

        if (LOG.isDebugEnabled()) {
            LOG.debug("IUMDailyJob Processed #[" + SDF.format(new java.util.Date())+"] " );
        }

        return processResultList;
    }

    private ProcessResult processPair(GroupManager groupManager ,UserUtil userUtil, String sourceGroups, String targetGroup, Set<ApplicationUser> applicationUserAccess){

        if (LOG.isDebugEnabled()) {
            LOG.debug("IUMDailyJob Sync groups = {} -> {}  at [ {} ] ",new Object[]{
                    sourceGroups,
                    targetGroup,
                    SDF.format(new Date())
            });
        }
        ProcessResult processResult = new ProcessResult(Process.DAILY_JOB,sourceGroups,targetGroup);


        if (sourceGroups!=null && targetGroup != null) {
            Group jiraSourceGroup = groupManager.getGroup(sourceGroups);
            Group jiraTargetGroup = groupManager.getGroup(targetGroup);

            if (jiraSourceGroup != null && jiraTargetGroup != null) {



                Set<ApplicationUser> sourceUsers = groupManager.getUsersInGroup(sourceGroups).stream().collect(Collectors.toSet());;
                Set<ApplicationUser> targetUsers = groupManager.getUsersInGroup(targetGroup).stream().collect(Collectors.toSet());;

                Sets.SetView<ApplicationUser> set1RemoveView = Sets.intersection(sourceUsers,applicationUserAccess);
                Sets.SetView<ApplicationUser> set2RemoveView = Sets.intersection(targetUsers,applicationUserAccess);

                processResult.setUserRemoved(0);
                set2RemoveView.stream().forEach(user -> {
                    try {
                        userUtil.removeUserFromGroup(jiraTargetGroup, user);
                        processResult.setUserRemoved(processResult.getUserRemoved()+1);
                        if (LOG.isInfoEnabled()) {
                            LOG.info("IUMDailyJob removed user {} to group   {} ", new Object[]{user.getUsername(), targetGroup});
                        }
                    } catch (Exception e) {
                        LOG.error("Exception " + e.getMessage(), e);
                        //continue
                    }
                });
                targetUsers.stream().filter(user -> !user.isActive()).forEach(user -> {
                    try {
                        userUtil.removeUserFromGroup(jiraTargetGroup, user);
                        processResult.setUserRemoved(processResult.getUserRemoved()+1);
                        if (LOG.isInfoEnabled()) {
                            LOG.info("IUMDailyJob removed user {} to group   {} ", new Object[]{user.getUsername(), targetGroup});
                        }
                    } catch (Exception e) {
                        LOG.error("Exception " + e.getMessage(), e);
                        //continue
                    }
                });



                processResult.setUserCopied(0);
                set1RemoveView.stream().forEach(user -> {
                    try {
                        //TODO
                        userUtil.removeUserFromGroup(jiraSourceGroup, user);
                        processResult.setUserCopied(processResult.getUserCopied()+1);

                        if (LOG.isInfoEnabled()) {
                            LOG.info("IUMDailyJob removed user {} to group   {} ", new Object[]{user.getUsername(), jiraSourceGroup});
                        }
                    } catch (Exception e) {
                        LOG.error("Exception " + e.getMessage(), e);
                        //continue
                    }
                });
                sourceUsers.stream().filter(user -> !user.isActive()).forEach(user -> {
                    try {
                        //TODO
                        userUtil.removeUserFromGroup(jiraSourceGroup, user);
                        processResult.setUserRemoved(processResult.getUserRemoved()+1);

                        if (LOG.isInfoEnabled()) {
                            LOG.info("IUMDailyJob removed user {} to group   {} ", new Object[]{user.getUsername(), jiraSourceGroup});
                        }
                    } catch (Exception e) {
                        LOG.error("Exception " + e.getMessage(), e);
                        //continue
                    }
                });

            }
        }else{
            LOG.warn("IUMDailyJob skipped Empty Source/Target config");
        }

        return processResult;
    }


    @WebSudoRequired
    public SortedSet<ApplicationUser> getUsersWithJiraAccessExceptGroup (String filterGroup) {
        ApplicationRole  applicationRole =getApplicationRole(applicationRoleManager,ApplicationKeys.SOFTWARE);

        if(applicationRole!=null){
            List<String> groups =applicationRole.getGroups().stream().map(Group::getName).filter(name -> !name.equalsIgnoreCase(filterGroup)).collect(Collectors.toList());
            SortedSet<ApplicationUser> users = userUtil.getAllUsersInGroupNames(groups);
            return users;
        }

        return new TreeSet();
    }

    @WebSudoRequired
    public SortedSet<ApplicationUser> getUsersWithSDeskAccessExceptGroup  (String filterGroup) {
        ApplicationRole  applicationRole =getApplicationRole(applicationRoleManager,ApplicationKeys.SERVICE_DESK);

        if(applicationRole!=null){
            List<String> groups =applicationRole.getGroups().stream().map(Group::getName).filter(name -> !name.equalsIgnoreCase(filterGroup)).collect(Collectors.toList());
            SortedSet<ApplicationUser> users = userUtil.getAllUsersInGroupNames(groups);
            return users;
        }

        return new TreeSet();
    }
    private static boolean isEmpty(String value){
        return value == null || value.length()==0;
    }

    private static ApplicationRole getApplicationRole(ApplicationRoleManager applicationRoleManager, ApplicationKey applicationKey) {
        if (applicationRoleManager == null || applicationKey == null) {
            return null;
        }

        List<ApplicationRole> applicationRoleList= applicationRoleManager.getRoles().stream()
                .filter(applicationRole -> applicationRole.getKey().equals(applicationKey))
                .collect(Collectors.toList());

        return (applicationRoleList.size()>0) ? applicationRoleList.get(0):null;
    }
}


