package de.accxia.jira.addon.IUM.job;


import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.session.currentusers.JiraUserSession;
import de.accxia.jira.addon.IUM.repository.JobResultRepository;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import de.accxia.jira.addon.IUM.servlet.session.AccxiaUserSessionTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Deprecated
public class IUMJob implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private static IUMJob instance;
    private PocketRepository pocketRepository;
    private JobResultRepository jobResultRepository;

    private IUMJob(){}

    //singleton pattern
    public static IUMJob getInstance() {
        if (instance == null)
            instance = new IUMJob();

        return instance;
    }

    public void injectService(PocketRepository pocketRepository, JobResultRepository jobResultRepository){
        this.instance.pocketRepository=pocketRepository;
        this.instance.jobResultRepository=jobResultRepository;
    }
    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) throws RemoveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("IUMJob Process #[" + SDF.format(new java.util.Date())+"] " );
        }
        List<ProcessResult> processResultList = new ArrayList<>();

        String enableGroups =(String) parameters.get(JobData.ENABLE_GROUPS);
        //String disableGroups =(String) parameters.get(JobData.DISABLE_GROUPS);
        long inactivityInterval = (Long) parameters.get(JobData.USER_INACTIVITY_INTERVAL);
        if(inactivityInterval<=0){
            inactivityInterval=JobData.DEFAULT_USER_INACTIVITY_INTERVAL;
        }

        if (LOG.isDebugEnabled()) {
            LOG.debug("IUMJob Process with groups={} interval={} at [ {} ] ",new Object[]{
                            enableGroups,
                            inactivityInterval,
                            SDF.format(new java.util.Date())
                    });
        }

        ProcessResult processResult = new ProcessResult(Process.CLEAN_JOB, (String) parameters.get(JobData.ENABLE_GROUPS),(String) parameters.get(JobData.DISABLE_GROUPS));

        GroupManager groupManager = ComponentAccessor.getGroupManager();
        UserManager userManager=ComponentAccessor.getUserManager();
        UserUtil userUtil = ComponentAccessor.getUserUtil();

        //all enabled users
        Map<String,List<UserActive>> usersEnabled = new HashMap<>();
        Map<String,List<String>> usersSession = new HashMap<>();

        if (!isEmpty(enableGroups)) {

            Arrays.stream(enableGroups.split(",")).forEach(group -> {
                groupManager.getUserNamesInGroup(group).stream().forEach(username -> {
                    doAddUserActive(username,group, usersEnabled);
                    usersSession.put(username,new ArrayList<>());
                });
            });

            if (LOG.isDebugEnabled()) {
                LOG.debug("Verify enabled users count #" +usersEnabled.size());
                if(usersEnabled.size()>0){
                    LOG.debug("Verify " +usersEnabled.keySet().stream().collect(Collectors.joining(",")));
                }
            }

            processResult.setUserRemoved(0);
            if(usersEnabled.size()>0){
                long now = new Date().getTime();
                AccxiaUserSessionTracker accxiaUserSessionTracker = AccxiaUserSessionTracker.getInstance();
                List<JiraUserSession> snapshotSession = accxiaUserSessionTracker.getAccxiaSnapshot();
                for(JiraUserSession jiraUserSession:snapshotSession){
                    if(jiraUserSession.getUserName()!=null && usersEnabled.get(jiraUserSession.getUserName())!=null){
                        if((now-jiraUserSession.getLastAccessTime().getTime())<inactivityInterval){
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("IUMJob user {} has active http session will not removed from enable group  {} / {}",
                                        new Object[]{jiraUserSession.getUserName(),SDF.format(jiraUserSession.getCreationTime()),SDF.format(jiraUserSession.getLastAccessTime()) });

                            }
                            usersEnabled.put(jiraUserSession.getUserName(),null);
                        }else if(usersSession.containsKey(jiraUserSession.getUserName())){
                            usersSession.get(jiraUserSession.getUserName()).add(jiraUserSession.getId());
                        }
                    }
                }

                for(String ukey:usersEnabled.keySet()){
                    List<UserActive> userActiveList = usersEnabled.get(ukey);
                    if(userActiveList!=null && userActiveList.size()>0){
                        for (UserActive userActive:userActiveList){
                            try {
                                userUtil.removeUserFromGroup(groupManager.getGroup(userActive.group), userManager.getUserByName(ukey));
                                processResult.setUserRemoved(processResult.getUserRemoved()+1);

                                if (LOG.isInfoEnabled()) {
                                    LOG.info("IUMJob removed user {} from group {} ", new Object[]{ukey, userActive.group});
                                }
                            } catch (Exception e) {
                                LOG.error("Exception[removeUserFromGroup]: " + e.getMessage(), e);
                            }
                        }
                    }
                }

                for(String ukey:usersSession.keySet()){
                    List<String> sessionList = usersSession.get(ukey);
                    if(sessionList!=null && sessionList.size()>0){
                        for (String sessionId:sessionList){
                            try {
                                if (LOG.isInfoEnabled()) {
                                    LOG.info("IUMJob markSessionAsInvalid user {} from sessionId {} ", new Object[]{ukey, sessionId});
                                }

                                accxiaUserSessionTracker.markSessionAsInvalid(sessionId);
                            }catch (Exception e) {
                                LOG.error("Exception[markSessionAsInvalid]: " + e.getMessage(), e);
                            }
                        }
                    }
                }
            }

            if (LOG.isDebugEnabled()) {
                LOG.debug("IUMJob Processed #[" + SDF.format(new java.util.Date())+"] " );
            }
        }

        processResultList.add(processResult);
        return processResultList;
    }

    private void addSessionUserActive(String username, String sessionId,Map<String,List<String>> usersSession) {
        if(!usersSession.containsKey(username)){
            usersSession.put(username,new ArrayList<>());
        }
        usersSession.get(username).add(sessionId);
    }

    private void doAddUserActive(String username, String group, Map<String, List<UserActive>> usersEnabled) {
        if(!usersEnabled.containsKey(username)){
            usersEnabled.put(username,new ArrayList<>());
        }
        List<UserActive> userActiveList = usersEnabled.get(username);
        userActiveList.add(new UserActive(group));
    }

    private static boolean isEmpty(String value){
        return value == null || value.length()==0;
    }



    class UserActive{
        String group;
        Boolean active=false;

        List<String> sessions= new ArrayList<>();

        public UserActive(String group) {
            this.group = group;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserActive that = (UserActive) o;

            if (group != null ? !group.equals(that.group) : that.group != null) return false;
            return active != null ? active.equals(that.active) : that.active == null;
        }

        @Override
        public int hashCode() {
            int result = group != null ? group.hashCode() : 0;
            result = 31 * result + (active != null ? active.hashCode() : 0);
            return result;
        }
    }
}
