package de.accxia.jira.addon.IUM.job;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.google.common.collect.Sets;
import de.accxia.jira.addon.IUM.repository.JobResultRepository;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

public class IUMSyncJob  implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMSyncJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private static IUMSyncJob instance;

    private PocketRepository pocketRepository;
    private JobResultRepository jobResultRepositor;
    private ApplicationRoleManager applicationRoleManager;
    private static UserUtil userUtil = ComponentAccessor.getUserUtil();

    private IUMSyncJob(){}

    //singleton pattern
    public static IUMSyncJob getInstance() {
        if (instance == null)
            instance = new IUMSyncJob();

        return instance;
    }

    public void injectService(PocketRepository pocketRepository, JobResultRepository jobResultRepositor){
        this.instance.pocketRepository=pocketRepository;
        this.instance.jobResultRepositor=jobResultRepositor;
    }

    public void injectService( ApplicationRoleManager applicationRoleManager){
        this.instance.applicationRoleManager=applicationRoleManager;

    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) throws RemoveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("IUMSyncJob Process #[" + SDF.format(new java.util.Date())+"] " );
        }
        List<ProcessResult> processResultList = new ArrayList<>();

        String sourceGroups = (String) parameters.get(JobData.SYNC_SOFTWARE_SRC_GROUP);
        String targetGroup = (String) parameters.get(JobData.SYNC_SOFTWARE_TARGET_GROUP);

        String sourceGroups2 = (String) parameters.get(JobData.SYNC_SDESK_SRC_GROUP);
        String targetGroup2 = (String) parameters.get(JobData.SYNC_SDESK_TARGET_GROUP);

        if (LOG.isDebugEnabled()) {
            LOG.debug("IUMSyncJob Sync groups = {} -> {}  at [ {} ] ",new Object[]{
                    sourceGroups,
                    targetGroup,
                    SDF.format(new Date())
            });
        }

        if(pocketRepository!=null) {


            GroupManager groupManager = ComponentAccessor.getGroupManager();
            UserManager userManager = ComponentAccessor.getUserManager();
            UserUtil userUtil = ComponentAccessor.getUserUtil();

            //TODO
            if(!isEmpty(sourceGroups) && !isEmpty(targetGroup)){
                Set<ApplicationUser> userJiraAccess=this.getUsersWithJiraAccess();
                ProcessResult processResult= processPair(groupManager,userUtil,sourceGroups,targetGroup,userJiraAccess);
                processResultList.add(processResult);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("IUMSyncJob copied #" + processResult.getUserCopied()+" to group "+targetGroup );
                    LOG.debug("IUMSyncJob removed #" + processResult.getUserRemoved()+" to group "+sourceGroups );
                }
            }
            if(!isEmpty(sourceGroups2) && !isEmpty(targetGroup2)){
                Set<ApplicationUser> userSDeskAccess=this.getUsersWithSDeskAccess();
                ProcessResult processResult=processPair(groupManager,userUtil,sourceGroups2,targetGroup2,userSDeskAccess);
                processResultList.add(processResult);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("IUMSyncJob copied #" + processResult.getUserCopied()+" to group "+targetGroup2 );
                    LOG.debug("IUMSyncJob removed #" + processResult.getUserRemoved()+" to group "+sourceGroups2 );
                }

            }


        }

        if (LOG.isDebugEnabled()) {
            LOG.debug("IUMSyncJob Processed #[" + SDF.format(new java.util.Date())+"] " );
        }

        return processResultList;
    }

    private ProcessResult processPair(GroupManager groupManager ,UserUtil userUtil, String sourceGroups, String targetGroup,
                                      Set<ApplicationUser> applicationUserAccess) {
        String[] arrayEnableGroups = isEmpty(sourceGroups) ? null : sourceGroups.split(";");
        if (LOG.isDebugEnabled()) {
            LOG.debug("IUMSyncJob Sync groups = {} -> {}  at [ {} ] ",new Object[]{
                    sourceGroups,
                    targetGroup,
                    SDF.format(new Date())
            });
        }
        ProcessResult processResult = new ProcessResult(Process.SYNC_JOB,sourceGroups,targetGroup);


        if (targetGroup != null) {
            Group jiraTargetGroup = groupManager.getGroup(targetGroup);
            if (arrayEnableGroups != null && jiraTargetGroup != null) {


                Collection<ApplicationUser> targetUsers = groupManager.getUsersInGroup(targetGroup);
                Set<ApplicationUser> targetUserSet = targetUsers.stream().collect(Collectors.toSet());
                Set<ApplicationUser> sourceUserSet = new HashSet<>();

                for (String group : arrayEnableGroups) {
                    Set<ApplicationUser> groupUsers = groupManager.getUsersInGroup(group).stream().filter(ApplicationUser::isActive).collect(Collectors.toSet());
                    sourceUserSet.addAll(groupUsers);
                }

                Sets.SetView<ApplicationUser> set2AddView = Sets.difference(Sets.difference(sourceUserSet, targetUserSet),applicationUserAccess);
                Sets.SetView<ApplicationUser> set2RemoveView = Sets.difference(Sets.difference(targetUserSet, sourceUserSet),applicationUserAccess);

                processResult.setUserCopied(0);
                set2AddView.stream().forEach(user -> {
                    try {
                        //TODO
                        userUtil.addUserToGroup(jiraTargetGroup, user);
                        processResult.setUserCopied(processResult.getUserCopied()+1);

                        if (LOG.isInfoEnabled()) {
                            LOG.info("IUMSyncJob added user {} to group   {} ", new Object[]{user.getUsername(), targetGroup});
                        }
                    } catch (Exception e) {
                        LOG.error("Exception " + e.getMessage(), e);
                        //continue
                    }
                });

                processResult.setUserRemoved(0);
                set2RemoveView.stream().forEach(user -> {
                    try {
                        userUtil.removeUserFromGroup(jiraTargetGroup, user);
                        processResult.setUserRemoved(processResult.getUserRemoved()+1);
                        if (LOG.isInfoEnabled()) {
                            LOG.info("IUMSyncJob added user {} to group   {} ", new Object[]{user.getUsername(), targetGroup});
                        }
                    } catch (Exception e) {
                        LOG.error("Exception " + e.getMessage(), e);
                        //continue
                    }
                });

            }
        }else{
            LOG.warn("IUMSyncJob skipped Empty Source/Target config");
        }

        return processResult;
    }


    public SortedSet<ApplicationUser> getUsersWithJiraAccess () {
        ApplicationRole  applicationRole =getApplicationRole(applicationRoleManager,ApplicationKeys.SOFTWARE);

        if(applicationRole!=null){
            List<String> groups =applicationRole.getGroups().stream().map(Group::getName).collect(Collectors.toList());
            SortedSet<ApplicationUser> users = userUtil.getAllUsersInGroupNames(groups);
            return users;
        }

        return new TreeSet();
    }

    public SortedSet<ApplicationUser> getUsersWithSDeskAccess () {
        ApplicationRole  applicationRole =getApplicationRole(applicationRoleManager,ApplicationKeys.SERVICE_DESK);

        if(applicationRole!=null){
            List<String> groups =applicationRole.getGroups().stream().map(Group::getName).collect(Collectors.toList());
            SortedSet<ApplicationUser> users = userUtil.getAllUsersInGroupNames(groups);
            return users;
        }

        return new TreeSet();
    }
    private static boolean isEmpty(String value){
        return value == null || value.length()==0;
    }
    private static ApplicationRole getApplicationRole(ApplicationRoleManager applicationRoleManager, ApplicationKey applicationKey) {
        if (applicationRoleManager == null || applicationKey == null) {
            return null;
        }

        List<ApplicationRole> applicationRoleList= applicationRoleManager.getRoles().stream()
                .filter(applicationRole -> applicationRole.getKey().equals(applicationKey))
                .collect(Collectors.toList());

        return (applicationRoleList.size()>0) ? applicationRoleList.get(0):null;
    }
}
