package de.accxia.jira.addon.IUM.job;


import de.accxia.jira.addon.IUM.config.DAO;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class JobData {
    public static final String  ENABLE_GROUPS="enable_groups";
    public static final String  DISABLE_GROUPS="disable_groups";
    public static final String  REPEAT_INTERVAL="repeat_interval";
    public static final String  STARTING_FROM="starting_from";
    public static final String  USER_INACTIVITY_INTERVAL="inactivity_interval";
    public static final String JOB_NEXT_RUN="job_next_run";
    public static final String RESTART="restart";
    public static final String SYNC_SOFTWARE_SRC_GROUP="source_software_groups";
    public static final String SYNC_SOFTWARE_TARGET_GROUP="target_software_group";
    public static final String SYNC_SDESK_SRC_GROUP="source_sdesk_groups";
    public static final String SYNC_SDESK_TARGET_GROUP="target_sdesk_group";
    public static final String SYNC_REPEAT_INTERVAL="sync_repeat_interval";
    public static final String SYNC_STARTING_FROM="sync_starting_from";

    public static final String DAILY_REPEAT_INTERVAL="daily_repeat_interval";
    public static final String DAILY_STARTING_FROM="daily_starting_from";

    public static final String CURRENT_USER="current_user";

    public static final long DEFAULT_REPEAT_INTERVAL= 60; //TimeUnit.HOURS.toMillis(1);
    public static final int DEFAULT_STARTING_FROM=1;
    public static final long DEFAULT_USER_INACTIVITY_INTERVAL= TimeUnit.MINUTES.toMillis(10);



    private int startingFrom= DEFAULT_STARTING_FROM;
    private long repeatInterval= DEFAULT_REPEAT_INTERVAL;
    private long  userInactivityInterval=DEFAULT_USER_INACTIVITY_INTERVAL;


    private Map<String, Serializable> parameters = new HashMap<>();

    public long getRepeatInterval() {
        return repeatInterval;
    }

    public void setRepeatInterval(long repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    public long getUserInactivityInterval() {
        return userInactivityInterval;
    }

    public void setUserInactivityInterval(long userInactivityInterval) {
        this.userInactivityInterval = userInactivityInterval;
    }

    public int getStartingFrom() {
        return startingFrom;
    }

    public void setStartingFrom(int startingFrom) {
        this.startingFrom = startingFrom;
    }

    public Map<String, Serializable> getParameters() {
        return parameters;
    }

    public void setParameters(Map<String, Serializable> parameters) {
        this.parameters = parameters;
    }

}
