package de.accxia.jira.addon.IUM.mailaddresshandler;

import com.atlassian.jira.plugins.mail.handlers.CreateOrCommentHandler;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.user.ApplicationUser;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;

import javax.mail.Message;
import javax.mail.MessagingException;

public class IUMCreateOrCommentHandler extends CreateOrCommentHandler {

    public IUMCreateOrCommentHandler() {
        super();
    }

    public boolean handleMessage(Message message, MessageHandlerContext context) throws MessagingException {

        ApplicationUser reporter = this.getReporter(message, context);
        if (reporter != null && IntelligentUserManagerHelper.isUserInGroups(reporter, DAO.getIUMGroupsDisabled())){
            IntelligentUserManagerHelper.simulateUserToEnabledGroup(reporter);
        }
        return  super.handleMessage(message,context);

    }

}
