package de.accxia.jira.addon.IUM.migration;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import de.accxia.jira.addon.IUM.model.JobResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobResultUpgradeTask001  implements ActiveObjectsUpgradeTask{
    private static final Logger LOG = LoggerFactory.getLogger(JobResultUpgradeTask001.class);

    @Override
    public ModelVersion getModelVersion()    {
        return ModelVersion.valueOf("1");
    }

    @Override
    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        try{
            ao.migrate(JobResult.class);
        }catch (Exception e){
            LOG.error("Exception: "+e.getMessage(),e);
        }
    }
}
