package de.accxia.jira.addon.IUM.model;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class NavUserDTO implements Serializable {
    //id
    private Integer ID;

    //requestCount
    private Long requestCount;

    //userName
    private String userName;

    //lastAccessTime
    private Date lastAccessTime;
    private Date lastViewTime;
    //creationTime
    private Date creationTime;

    //invalidateSessionFlag
    private Boolean invalidateSessionFlag;

    //asessionId
    private String  asessionId;

    //sessionId
    private String  sessionId;

    private String userNameEx;
    private String groupNameEx;

    private String displayNameEx;
    private String userEmailEx;

    //========================================================================

    public static NavUserDTO fromAO(NavUser navUser) {
        NavUserDTO navUserDTO = new NavUserDTO();
        if(navUser !=null){
            navUserDTO.setID(navUser.getID());
            navUserDTO.setRequestCount(navUser.getRequestCount());
            navUserDTO.setUserName(navUser.getUserName());

            navUserDTO.setLastAccessTime(navUser.getLastAccessTime());
            navUserDTO.setInvalidateSessionFlag(navUser.getInvalidateSessionFlag());
            navUserDTO.setASessionId(navUser.getASessionId());
            navUserDTO.setSessionId(navUser.getSessionId());

            navUserDTO.setSessionId(navUser.getSessionId());

        }
        return navUserDTO;
    }
    //========================================================================

    public Integer getID() {
        return ID;
    }

    public void setID(Integer ID) {
        this.ID = ID;
    }

    public Long getRequestCount() {
        return requestCount;
    }

    public void setRequestCount(Long requestCount) {
        this.requestCount = requestCount;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Date getLastAccessTime() {
        return lastAccessTime;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public Date getLastViewTime() {
        return lastViewTime;
    }

    public void setLastViewTime(Date lastViewTime) {
        this.lastViewTime = lastViewTime;
    }

    public Date getCreationTime() {
        return creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Boolean getInvalidateSessionFlag() {
        return invalidateSessionFlag;
    }

    public void setInvalidateSessionFlag(Boolean invalidateSessionFlag) {
        this.invalidateSessionFlag = invalidateSessionFlag;
    }

    public String getAsessionId() {
        return asessionId;
    }

    public void setASessionId(String asessionId) {
        this.asessionId = asessionId;
    }

    public String getSessionId() {
        return sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getUserNameEx() {
        return userNameEx;
    }

    public void setUserNameEx(String userNameEx) {
        this.userNameEx = userNameEx;
    }

    public String getGroupNameEx() {
        return groupNameEx;
    }

    public void setGroupNameEx(String groupNameEx) {
        this.groupNameEx = groupNameEx;
    }

    public String getDisplayNameEx() {
        return displayNameEx;
    }

    public void setDisplayNameEx(String displayNameEx) {
        this.displayNameEx = displayNameEx;
    }

    public String getUserEmailEx() {
        return userEmailEx;
    }

    public void setUserEmailEx(String userEmailEx) {
        this.userEmailEx = userEmailEx;
    }
//========================================================================

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NavUserDTO that = (NavUserDTO) o;
        return ID == that.ID && Objects.equals(requestCount, that.requestCount) && Objects.equals(userName, that.userName) && Objects.equals(lastAccessTime, that.lastAccessTime) && Objects.equals(creationTime, that.creationTime) && Objects.equals(invalidateSessionFlag, that.invalidateSessionFlag) && Objects.equals(asessionId, that.asessionId) && Objects.equals(sessionId, that.sessionId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ID, requestCount, userName, lastAccessTime, creationTime, invalidateSessionFlag, asessionId, sessionId);
    }

    //========================================================================

    @Override
    public String toString() {
        return "NavUserDTO{" +
                "ID=" + ID +
                ", requestCount=" + requestCount +
                ", userName='" + userName + '\'' +
                ", lastAccessTime=" + lastAccessTime +
                ", lastViewTime=" + lastViewTime +
                ", creationTime=" + creationTime +
                ", invalidateSessionFlag=" + invalidateSessionFlag +
                ", asessionId='" + asessionId + '\'' +
                ", sessionId='" + sessionId + '\'' +
                ", userNameEx='" + userNameEx + '\'' +
                ", groupNameEx='" + groupNameEx + '\'' +
                ", displayNameEx='" + displayNameEx + '\'' +
                ", userEmailEx='" + userEmailEx + '\'' +
                '}';
    }


    //========================================================================


}
