package de.accxia.jira.addon.IUM.repository;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.jira.addon.IUM.model.NavUser;
import de.accxia.jira.addon.IUM.model.NavUserDTO;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.inject.Inject;
import javax.inject.Named;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

@ExportAsService({NavUserRepository.class})
@Named ("NavUserRepository")
public class NavUserRepository {
    private static final Logger logger = LoggerFactory.getLogger(NavUserRepository.class);

    @ComponentImport
    private final ActiveObjects ao;

    @Inject
    public NavUserRepository(final ActiveObjects ao) {
        this.ao = ao;
    }

    public NavUser save(NavUserDTO navUserDTO) {
        logger.debug("Called save for user {}", navUserDTO.getUserName());
        final Map<String, Object> values = new HashMap<String, Object>();
        values.put(NavUser.REQUEST_COUNT,navUserDTO.getRequestCount());
        values.put(NavUser.USER_NAME,navUserDTO.getUserName());
        values.put(NavUser.LAST_ACCESS_TIME,navUserDTO.getLastAccessTime());
        values.put(NavUser.CREATION_TIME,navUserDTO.getCreationTime());
        values.put(NavUser.INVALIDATE_SESSION_FLAG,navUserDTO.getInvalidateSessionFlag());
        values.put(NavUser.ASESSION_ID,navUserDTO.getAsessionId());
        values.put(NavUser.SESSION_ID,navUserDTO.getSessionId());

        NavUser response =  ao.create(NavUser.class, values);

        logger.debug("Successfully save for user {}",  navUserDTO.getUserName());
        return response;
    }

    public NavUser update(Long id, String  asessionId,String  sessionId,Long requestCount,String userName){
        //NavUser[] navUsers = getByIdSession(asessionId,sessionId);
        NavUser navUser =ao.get(NavUser.class,new Integer(id.intValue()));
        if(navUser!=null){
            navUser.setRequestCount(requestCount);
            navUser.setLastAccessTime(new Date());
            navUser.setUserName(userName);
            navUser.save();
        }else{
            final Map<String, Object> values = new HashMap<String, Object>();
            values.put(NavUser.REQUEST_COUNT,requestCount);
            values.put(NavUser.USER_NAME,userName);
            values.put(NavUser.LAST_ACCESS_TIME,new Date());
            values.put(NavUser.CREATION_TIME,new Date());
            values.put(NavUser.ASESSION_ID,asessionId);
            values.put(NavUser.SESSION_ID,sessionId);

            navUser =  ao.create(NavUser.class, values);
        }
        return navUser;
    }

    public NavUser[] getBySession(String asessionId, String sessionId) {
        if(logger.isDebugEnabled()){
            logger.debug("Called getAllByUsers for session {} asession {} ", asessionId,sessionId);
        }

        final NavUser[] queryResult = ao.find(
                NavUser.class, Query.select().where(NavUser.ASESSION_ID + " = ? AND " + NavUser.SESSION_ID + " = ? ", asessionId, sessionId)
                        .order(NavUser.LAST_ACCESS_TIME +" DESC"));
        if(logger.isDebugEnabled()){
            logger.debug("Successfully fetch result for session {} asession {} ", asessionId,sessionId);
        }

        return queryResult;
    }

    public NavUser[] getByUserName(String userName) {
        if(logger.isDebugEnabled()){
            logger.debug("Called getByUserName for userName {} ", userName);
        }

        final NavUser[] queryResult = ao.find(
                NavUser.class, Query.select().where(NavUser.USER_NAME + " = ? ", userName)
                        .order(NavUser.LAST_ACCESS_TIME +" DESC"));

        if(logger.isDebugEnabled()){
            logger.debug("Successfully fetch result for userName {} ", userName);
        }

        return queryResult;
    }

    public NavUser[] getAllByUsers(String[] userNames) {
        if(logger.isDebugEnabled()){
            logger.debug("Called getAllByUsers for userNames {}", Arrays.stream(userNames).collect(Collectors.joining(",")));
        }
        String placeholderUsers = Arrays.stream(userNames).collect(Collectors.joining(","));
        final NavUser[] queryResult = ao.find(
                NavUser.class, Query.select().where(NavUser.USER_NAME + " in (?)", placeholderUsers));
        if(logger.isDebugEnabled()){
            logger.debug("Successfully fetch result for userNames {}", Arrays.stream(userNames).collect(Collectors.joining(",")));
        }

        return queryResult;
    }

    public NavUser[] getOldestUsers(String[] userNames ,int ctx) {
        if(logger.isDebugEnabled()){
            logger.debug("Called getAllByUsers for userNames {}", Arrays.stream(userNames).collect(Collectors.joining(",")));
        }
        String placeholderCommaList = Arrays.stream(userNames).map(un-> "?").collect(Collectors.joining(","));
        final NavUser[] queryResult =ao.find(NavUser.class, Query.select().where(NavUser.USER_NAME+ " in  ( "  + placeholderCommaList+" )",userNames).order(NavUser.LAST_ACCESS_TIME +" ASC").limit(ctx));

        if(logger.isDebugEnabled()){
            logger.debug("Successfully fetch result for userNames {}", Arrays.stream(userNames).collect(Collectors.joining(",")));
        }

        return queryResult;
    }

    public NavUser[] getAll() {
        if(logger.isDebugEnabled()){
            logger.debug("Called getAll ");
        }

        final NavUser[] queryResult = ao.find(NavUser.class, Query.select());
        if(logger.isDebugEnabled()){
            logger.debug("Successfully fetch result for getAll");
        }

        return queryResult;

    }

    public int deleteBySession(String asessionId, String sessionId) {
        return ao.deleteWithSQL(NavUser.class, NavUser.ASESSION_ID + " = ? AND " + NavUser.SESSION_ID + " = ? ", asessionId, sessionId);
    }

    public int deleteOldestExceptUsers(String userName ,NavUser navUser) {
        if(logger.isDebugEnabled()){
            logger.debug("Called deleteOldestExceptUsers for userName {} except {}", userName, navUser.getID());
        }

        int cnt = ao.deleteWithSQL(NavUser.class, NavUser.USER_NAME + " = ? AND " + NavUser.ID + " != ? ", userName, navUser.getID());


        if(logger.isDebugEnabled()){
            logger.debug("Successfully deleteOldestExceptUsers  for userName {} except {}", userName, navUser.getID());
        }

        return cnt;
    }

    public void delete(NavUser navUser) {
        ao.delete(navUser);
    }

}
