package de.accxia.jira.addon.IUM.repository;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.SQLQuery;
import de.accxia.jira.addon.IUM.model.NavUserDTO;
import de.accxia.jira.addon.IUM.model.UserHistoryDTO;
import de.accxia.jira.addon.IUM.tables.*;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.inject.Named;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@ExportAsService({PocketRepository.class})
@Named("PocketRepository")
public class PocketRepository {
    private static final Logger LOG = LoggerFactory.getLogger(PocketRepository.class);

    private final DatabaseAccessor databaseAccessor;

    public PocketRepository(final DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    //==========================================================
    // NavUserDTO
    //==========================================================


    /*For testing / analyse*/
    @Deprecated
    public List<NavUserDTO> getAllNavUserForGroup(String groupName,int offset ,int ctx) {

        List<Tuple> tupleSQLQuery = databaseAccessor.run(databaseConnection -> {
            List<Path<?>> path= QNavUser.NAVUSER.getColumns();
            path.add(QMembership.MEMBERSHIP.childName);
            path.add(QMembership.MEMBERSHIP.parentName);

            SQLQuery<Tuple> sqlQuery = databaseConnection.select(path.toArray(new Path[0]))
                    .from(QMembership.MEMBERSHIP)
                    .leftJoin(QNavUser.NAVUSER).on(QNavUser.NAVUSER.userName.eq(QMembership.MEMBERSHIP.childName))
                    .innerJoin(QUser.MEMBERSHIP).on(QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))
                    .where(QUser.MEMBERSHIP.active.eq(1)
                                .and(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase())))
                    .orderBy(QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst())
                    .offset(offset)
                    .limit(ctx);

            if(LOG.isDebugEnabled()){
                LOG.debug("getAllNavUserForGroup SQL = " +sqlQuery.toString());
                LOG.debug("getAllNavUserForGroup groupName = " +groupName);
                LOG.debug("getAllNavUserForGroup offset = " +offset);
                LOG.debug("getAllNavUserForGroup ctx = " +ctx);
            }
            List<Tuple> list = sqlQuery.fetch();
            return list;
        });

        return this.convertTuplesToNavUserDTO(tupleSQLQuery);
    }

    public List<NavUserDTO> getOldestUsers(String groupName,int offset ,int ctx) {

        List<Tuple> tupleSQLQuery = databaseAccessor.run(databaseConnection -> {
            List<Path<?>> path= QNavUser.NAVUSER.getColumns();
            path.add(QMembership.MEMBERSHIP.childName);
            path.add(QMembership.MEMBERSHIP.parentName);

            SQLQuery<Tuple> sqlQuery = databaseConnection.select(path.toArray(new Path[0]))
                .from(QMembership.MEMBERSHIP)
                .innerJoin(QUser.MEMBERSHIP).on(QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))
                .leftJoin(QNavUser.NAVUSER).on(QNavUser.NAVUSER.userName.eq(QUser.MEMBERSHIP.userName))
                .where(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase()))
                .orderBy(QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst())
                .offset(offset)
                .limit(ctx);

            if(LOG.isDebugEnabled()){
                LOG.debug("getOldestUsers SQL = " +sqlQuery.toString());
                LOG.debug("getOldestUsers groupName = " +groupName);
                LOG.debug("getOldestUsers offset = " +offset);
                LOG.debug("getOldestUsers ctx = " +ctx);
            }
            List<Tuple> list = sqlQuery.fetch();
            return list;
        });

      return this.convertTuplesToNavUserDTO(tupleSQLQuery);
    }

    public List<NavUserDTO> getOldestUsers(String groupName,String filterGroup, int offset ,int ctx) {
        String filterGroupName = StringUtils.isEmpty(filterGroup) ? null : filterGroup.toLowerCase();


        List<Tuple> tupleSQLQuery = databaseAccessor.run(databaseConnection -> {
            List<Path<?>> path= QNavUser.NAVUSER.getColumns();
            path.add(QUser.MEMBERSHIP.displayName);
            path.add(QUser.MEMBERSHIP.emailAddress);
            path.add(QMembership.MEMBERSHIP.childName);
            path.add(QMembership.MEMBERSHIP.parentName);
            //path.add(QUserHistory.MEMBERSHIP.lastViewed);

            SubQueryExpression<String> filterQuery = filterGroupName==null ? null :
                    databaseConnection.select(QMembership.MEMBERSHIP.lowerChildName)
                        .from(QMembership.MEMBERSHIP)
                        .where(QMembership.MEMBERSHIP.lowerParentName.eq(filterGroupName));

            SQLQuery<Tuple> sqlQuery = databaseConnection.select(path.toArray(new Path[0]))
                    .from(QMembership.MEMBERSHIP)
                    .innerJoin(QUser.MEMBERSHIP).on(QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))
                    .innerJoin(QGroup.MEMBERSHIP).on(QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))
                    .leftJoin(QNavUser.NAVUSER).on(QNavUser.NAVUSER.userName.eq(QUser.MEMBERSHIP.userName));
            //.innerJoin(QUser.MEMBERSHIP).on(QUser.MEMBERSHIP.lowerUserName.eq(QMembership.MEMBERSHIP.lowerChildName))
            //TODO temporary fix for ORACLE sql generate error
            if (filterGroupName != null) {
                sqlQuery.where(QUser.MEMBERSHIP.active.eq(1)
                        .and(QMembership.MEMBERSHIP.parentName.eq(groupName))
                        .and(QMembership.MEMBERSHIP.lowerChildName.notIn(filterQuery))
                );
            } else {
                sqlQuery.where(QUser.MEMBERSHIP.active.eq(1)
                        .and(QMembership.MEMBERSHIP.parentName.eq(groupName))
                );
            }

              sqlQuery.orderBy(QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst())
                .offset(offset)
                .limit(ctx);

            if(LOG.isDebugEnabled()){
                LOG.debug("getOldestUsers SQL = " +sqlQuery.toString());
                if(filterGroupName!=null){
                    LOG.debug("getOldestUsers filterGroup = " +filterGroup);
                    LOG.debug("getOldestUsers filterQuery = " +filterQuery.toString());
                }
                LOG.debug("getOldestUsers groupName = " +groupName);
                LOG.debug("getOldestUsers offset = " +offset);
                LOG.debug("getOldestUsers ctx = " +ctx);
            }
            List<Tuple> list = sqlQuery.fetch();
            return list;
        });

        return this.convertTuplesToNavUserDTO(tupleSQLQuery);
    }

    public long countOldestUsers(String groupName,String filterGroup) {
        String filterGroupName = StringUtils.isEmpty(filterGroup) ? null : filterGroup.toLowerCase();


        long tupleSQLQuery = databaseAccessor.run(databaseConnection -> {

            SubQueryExpression<String> filterQuery = filterGroupName==null ? null :
                    databaseConnection.select(QMembership.MEMBERSHIP.lowerChildName)
                            .from(QMembership.MEMBERSHIP)
                            .where(QMembership.MEMBERSHIP.lowerParentName.eq(filterGroupName));

            SQLQuery<Tuple> sqlQuery = databaseConnection.select()
                    .from(QMembership.MEMBERSHIP)
                    .innerJoin(QUser.MEMBERSHIP).on(QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))
                    .innerJoin(QGroup.MEMBERSHIP).on(QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))
                    .leftJoin(QNavUser.NAVUSER).on(QNavUser.NAVUSER.userName.eq(QUser.MEMBERSHIP.userName));
            //TODO temporary fix for ORACLE sql generate error
            if (filterGroupName == null) {
                sqlQuery.where(QUser.MEMBERSHIP.active.eq(1)
                        .and(QMembership.MEMBERSHIP.parentName.eq(groupName)));
            } else {
                sqlQuery.where(QUser.MEMBERSHIP.active.eq(1)
                        .and(QMembership.MEMBERSHIP.parentName.eq(groupName))
                        .and(QMembership.MEMBERSHIP.lowerChildName.notIn(filterQuery))
                );
            }

            if(LOG.isDebugEnabled()){
                LOG.debug("countOldestUsers SQL = " +sqlQuery.toString());
                if(filterGroupName!=null){
                    LOG.debug("countOldestUsers filterGroup = " +filterGroup);
                    LOG.debug("countOldestUsers filterQuery = " +filterQuery.toString());
                }
                LOG.debug("countOldestUsers groupName = " +groupName);
            }

            long retVal = sqlQuery.fetchCount();
            return retVal;
        });

        return tupleSQLQuery;
    }

    private List<NavUserDTO> getNavUserForGroupLtTime(String groupName, boolean onlyActive, Timestamp timestamp, int offset , int ctx) {

        List<Tuple> tupleSQLQuery = databaseAccessor.run(databaseConnection -> {
            List<Path<?>> path= QNavUser.NAVUSER.getColumns();
            path.add(QMembership.MEMBERSHIP.childName);
            path.add(QMembership.MEMBERSHIP.parentName);

            SQLQuery<Tuple> sqlQuery = databaseConnection.select(path.toArray(new Path[0]))
                    .from(QMembership.MEMBERSHIP)
                    .innerJoin(QUser.MEMBERSHIP).on(QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))
                    .innerJoin(QGroup.MEMBERSHIP).on(QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))
                    .leftJoin(QNavUser.NAVUSER).on(QNavUser.NAVUSER.userName.eq(QUser.MEMBERSHIP.userName));
            //TODO temporary fix for ORACLE sql generate error
            if (onlyActive) {
                sqlQuery.where(QUser.MEMBERSHIP.active.eq(1)
                        .and(QMembership.MEMBERSHIP.parentName.eq(groupName))
                        .and(QNavUser.NAVUSER.lastAccessTime.lt(timestamp).or(QNavUser.NAVUSER.lastAccessTime.isNull())));
            } else {
                sqlQuery.where(QMembership.MEMBERSHIP.parentName.eq(groupName)
                        .and(QNavUser.NAVUSER.lastAccessTime.lt(timestamp).or(QNavUser.NAVUSER.lastAccessTime.isNull())));
            }
            sqlQuery.orderBy(QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst())
                    .offset(offset)
                    .limit(ctx);

            if(LOG.isDebugEnabled()){
                LOG.debug("getNavUserForGroupLtTime SQL = " +sqlQuery.toString());
                LOG.debug("getNavUserForGroupLtTime groupName = " +groupName);
                LOG.debug("getNavUserForGroupLtTime timestamp = " +timestamp);
                LOG.debug("getNavUserForGroupLtTime offset = " +offset);
                LOG.debug("getNavUserForGroupLtTime ctx = " +ctx);
            }
            List<Tuple> list = sqlQuery.fetch();
            return list;
        });

        return this.convertTuplesToNavUserDTO(tupleSQLQuery);
    }

    public List<NavUserDTO> getNavUserActiveForGroupLtTime(String groupName, Timestamp timestamp, int offset , int ctx) {
        return getNavUserForGroupLtTime(groupName,true,timestamp,offset,ctx);
    }

    public List<NavUserDTO> getNavUserDisableForGroupLtTime(String groupName, Timestamp timestamp,int offset ,int ctx) {
        return getNavUserForGroupLtTime(groupName,false,timestamp,offset,ctx);
    }

    //==========================================================
    // UserHistoryDTO
    //==========================================================

    /*For testing / analyse*/
    @Deprecated
    public List<UserHistoryDTO> getAllUserHistoryForGroup(String groupName,int offset ,int ctx) {
        List<Tuple> tupleSQLQuery = databaseAccessor.run(databaseConnection -> {
            //use lastViewedDate
            //QUserHistory.MEMBERSHIP.lastViewed.max().as("lastViewedDate");

            SQLQuery<Tuple> sqlQuery = databaseConnection
                    .select(QAppUser.MEMBERSHIP.userKey,
                            QAppUser.MEMBERSHIP.lowerUserName,
                            QUserHistory.MEMBERSHIP.lastViewed.max().as("lastViewedDate"))
                    .from(QUserHistory.MEMBERSHIP)
                    .innerJoin(QAppUser.MEMBERSHIP).on(QAppUser.MEMBERSHIP.userKey.eq(QUserHistory.MEMBERSHIP.userName))
                    .innerJoin(QMembership.MEMBERSHIP).on(QMembership.MEMBERSHIP.lowerChildName.eq(QAppUser.MEMBERSHIP.lowerUserName))
                    .where(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase()))
                    .groupBy(QAppUser.MEMBERSHIP.userKey,QAppUser.MEMBERSHIP.lowerUserName)
                    .orderBy(new OrderSpecifier<>(Order.ASC, QUserHistory.MEMBERSHIP.lastViewed.max()).nullsFirst())
                    .offset(offset)
                    .limit(ctx);

            if(LOG.isDebugEnabled()){
                LOG.debug("getAllUserHistoryForGroup SQL = " +sqlQuery.toString());
                LOG.debug("getAllUserHistoryForGroup groupName = " +groupName);
                LOG.debug("getAllUserHistoryForGroup offset = " +offset);
                LOG.debug("getAllUserHistoryForGroup ctx = " +ctx);
            }
            List<Tuple> list = sqlQuery.fetch();
            return list;
        });

        return this.convertTuplesToUserHistoryDTO(tupleSQLQuery);
    }

    public List<UserHistoryDTO> getOldestUsersFromUserHistory(String groupName, int offset , int ctx) {

        List<Tuple> tupleSQLQuery = databaseAccessor.run(databaseConnection -> {
            //use lastViewedDate
            //QUserHistory.MEMBERSHIP.lastViewed.max().as("lastViewedDate");

            SQLQuery<Tuple> sqlQuery = databaseConnection
                    .select(QAppUser.MEMBERSHIP.userKey,
                            QAppUser.MEMBERSHIP.lowerUserName,
                            QUserHistory.MEMBERSHIP.lastViewed.max().as("lastViewedDate"))
                    .from(QUserHistory.MEMBERSHIP)
                    .innerJoin(QAppUser.MEMBERSHIP).on(QAppUser.MEMBERSHIP.userKey.eq(QUserHistory.MEMBERSHIP.userName))
                    .innerJoin(QMembership.MEMBERSHIP).on(QMembership.MEMBERSHIP.lowerChildName.eq(QAppUser.MEMBERSHIP.lowerUserName))
                    .where(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase()))
                    .groupBy(QAppUser.MEMBERSHIP.userKey, QAppUser.MEMBERSHIP.lowerUserName)
                    .orderBy(new OrderSpecifier<>(Order.ASC, QUserHistory.MEMBERSHIP.lastViewed.max()).nullsFirst())
                    .offset(offset)
                    .limit(ctx);

            if (LOG.isDebugEnabled()) {
                LOG.debug("getOldestUsersBasedOnUserHistory SQL = " + sqlQuery.toString());
                LOG.debug("getOldestUsersBasedOnUserHistory groupName = " + groupName);
                LOG.debug("getOldestUsersBasedOnUserHistory offset = " + offset);
                LOG.debug("getOldestUsersBasedOnUserHistory ctx = " + ctx);
            }
            List<Tuple> list = sqlQuery.fetch();
            return list;
        });

        return this.convertTuplesToUserHistoryDTO(tupleSQLQuery);
    }

    public List<UserHistoryDTO> getUserHistoryForGroupLtTime(String groupName, Timestamp timestamp,int offset ,int ctx){

        List<Tuple> tupleSQLQuery = databaseAccessor.run(databaseConnection -> {
            //use lastViewedDate
            //QUserHistory.MEMBERSHIP.lastViewed.max().as("lastViewedDate");

            SQLQuery<Tuple> sqlQuery = databaseConnection
                    .select(QAppUser.MEMBERSHIP.userKey,
                            QAppUser.MEMBERSHIP.lowerUserName,
                            QUserHistory.MEMBERSHIP.lastViewed.max().as("lastViewedDate"))
                    .from(QUserHistory.MEMBERSHIP)
                    .innerJoin(QAppUser.MEMBERSHIP).on(QAppUser.MEMBERSHIP.userKey.eq(QUserHistory.MEMBERSHIP.userName))
                    .innerJoin(QMembership.MEMBERSHIP).on(QMembership.MEMBERSHIP.lowerChildName.eq(QAppUser.MEMBERSHIP.lowerUserName))
                    .where(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase())
                            .and(QUserHistory.MEMBERSHIP.lastViewed.lt(timestamp.getTime()).or(QUserHistory.MEMBERSHIP.lastViewed.isNull())))

                    .groupBy(QAppUser.MEMBERSHIP.userKey,QAppUser.MEMBERSHIP.lowerUserName)
                    .orderBy(new OrderSpecifier<>(Order.ASC, QUserHistory.MEMBERSHIP.lastViewed.max()).nullsFirst())
                    .offset(offset)
                    .limit(ctx);

            if(LOG.isDebugEnabled()){
                LOG.debug("getUserHistoryForGroupLtTime SQL = " +sqlQuery.toString());
                LOG.debug("getUserHistoryForGroupLtTime groupName = " + groupName);
                LOG.debug("getUserHistoryForGroupLtTime timestamp = " + timestamp);
                LOG.debug("getUserHistoryForGroupLtTime offset = " + offset);
                LOG.debug("getUserHistoryForGroupLtTime ctx = " + ctx);
            }
            List<Tuple> list = sqlQuery.fetch();
            return list;
        });

        return this.convertTuplesToUserHistoryDTO(tupleSQLQuery);
    }



    //==========================================================
    // cwd_membership
    //==========================================================

    /*For testing / analyse*/
    @Deprecated
    public List<String> getMmebershipForUser(String username) {
        List<Tuple> tupleSQLQuery = databaseAccessor.run(databaseConnection -> {
            List<Path<?>> path= QMembership.MEMBERSHIP.getColumns();

            //use lastViewedDate
            //QUserHistory.MEMBERSHIP.lastViewed.max().as("lastViewedDate");

            SQLQuery<Tuple> sqlQuery = databaseConnection.select(path.toArray(new Path[0]))
                    .from(QMembership.MEMBERSHIP)
                    .where(QMembership.MEMBERSHIP.lowerChildName.eq(username.toLowerCase()));


            if(LOG.isDebugEnabled()){
                LOG.debug("getMmebershipForUser SQL = " +sqlQuery.toString());
            }
            List<Tuple> list = sqlQuery.fetch();
            return list;
        });

        return this.convertTuplesToUsertMmebership(tupleSQLQuery);
    }


    public List<String> getMmebershipForGroup(String groupname) {
        List<Tuple> tupleSQLQuery = databaseAccessor.run(databaseConnection -> {
            List<Path<?>> path= QMembership.MEMBERSHIP.getColumns();
            path.add(QUser.MEMBERSHIP.id);
            path.add(QUser.MEMBERSHIP.directoryId);
            path.add(QUser.MEMBERSHIP.userName);
            path.add(QUser.MEMBERSHIP.lowerUserName);
            path.add(QGroup.MEMBERSHIP.id);
            path.add(QGroup.MEMBERSHIP.groupName);
            path.add(QGroup.MEMBERSHIP.lowerGroupName);

            //use lastViewedDate
            //QUserHistory.MEMBERSHIP.lastViewed.max().as("lastViewedDate");

            SQLQuery<Tuple> sqlQuery = databaseConnection.select(path.toArray(new Path[0]))
                    .from(QMembership.MEMBERSHIP)
                    .innerJoin(QUser.MEMBERSHIP).on(QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))
                    .innerJoin(QGroup.MEMBERSHIP).on(QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))
                    //.innerJoin(QUser.MEMBERSHIP).on(QUser.MEMBERSHIP.lowerUserName.eq(QMembership.MEMBERSHIP.lowerChildName))
                    .where(QMembership.MEMBERSHIP.parentName.eq(groupname)
                            .and(QUser.MEMBERSHIP.active.eq(1)));


            if(LOG.isDebugEnabled()){
                LOG.debug("getMmebershipForUser SQL = " +sqlQuery.toString());
            }
            List<Tuple> list = sqlQuery.fetch();
            return list;
        });

        return this.convertTuplesToUsertMmebership(tupleSQLQuery);
    }



    //==========================================================
    // NavUserDTO - converters
    //==========================================================
    private List<NavUserDTO> convertTuplesToNavUserDTO(List<Tuple> tupleSQLQuery) {
        List<NavUserDTO> retVal = new ArrayList<>();
        for(Tuple tuple:tupleSQLQuery){
            retVal.add(convertTupleToEventModel(tuple));
        }
        return  retVal;
    }

    private NavUserDTO convertTupleToEventModel(Tuple tuple) {
        NavUserDTO navUserDTO = new NavUserDTO();
        if(tuple.get(QNavUser.NAVUSER.id)!=null){
            navUserDTO.setID(tuple.get(QNavUser.NAVUSER.id));
            navUserDTO.setRequestCount(tuple.get(QNavUser.NAVUSER.requestCount));
            navUserDTO.setASessionId(tuple.get(QNavUser.NAVUSER.asessionId));
            navUserDTO.setSessionId(tuple.get(QNavUser.NAVUSER.sessionId));
            navUserDTO.setUserName(tuple.get(QNavUser.NAVUSER.userName));

            navUserDTO.setLastAccessTime(tuple.get(QNavUser.NAVUSER.lastAccessTime));
            navUserDTO.setCreationTime(tuple.get(QNavUser.NAVUSER.creationTime));
            navUserDTO.setInvalidateSessionFlag(tuple.get(QNavUser.NAVUSER.invalidateSessionFlag));
        }

        navUserDTO.setUserNameEx(tuple.get(QMembership.MEMBERSHIP.childName));
        navUserDTO.setGroupNameEx(tuple.get(QMembership.MEMBERSHIP.parentName));

        navUserDTO.setDisplayNameEx(tuple.get(QUser.MEMBERSHIP.displayName));
        navUserDTO.setUserEmailEx(tuple.get(QUser.MEMBERSHIP.emailAddress));

        navUserDTO.setLastViewTime(tuple.get(QUserHistory.MEMBERSHIP.lastViewed) != null ? new Date(tuple.get(QUserHistory.MEMBERSHIP.lastViewed)) : null);

        return navUserDTO;
    }

    //==========================================================
    // UserHistoryDTO - converters
    //==========================================================
    private List<UserHistoryDTO> convertTuplesToUserHistoryDTO(List<Tuple> tupleSQLQuery) {
        List<UserHistoryDTO> retVal = new ArrayList<>();
        for(Tuple tuple:tupleSQLQuery){
            retVal.add(convertTupleToHistoryModel(tuple));
        }
        return  retVal;
    }

    private UserHistoryDTO convertTupleToHistoryModel(Tuple tuple) {
        UserHistoryDTO userHistoryDTO = new UserHistoryDTO();
        userHistoryDTO.setUserName(tuple.get(QAppUser.MEMBERSHIP.lowerUserName));
        userHistoryDTO.setUserKey(tuple.get(QAppUser.MEMBERSHIP.userKey));
        Long lastViewedDate= tuple.get(QUserHistory.MEMBERSHIP.lastViewed.max().as("lastViewedDate"));
        userHistoryDTO.setLastViewTime(lastViewedDate!=null ? new Date(lastViewedDate):null);
        return userHistoryDTO;

    }

    //==========================================================
    // cwd_membership - converters
    //==========================================================
    private List<String> convertTuplesToUsertMmebership(List<Tuple> tupleSQLQuery) {
        List<String> retVal = new ArrayList<>();
        for(Tuple tuple:tupleSQLQuery){
            retVal.add(convertTupleToMembershipModel(tuple));
        }
        return  retVal;
    }

    private String convertTupleToMembershipModel(Tuple tuple) {
        List<String> membership = new ArrayList<>();
        membership.add(String.valueOf(tuple.get(QMembership.MEMBERSHIP.id)));
        membership.add(tuple.get(QMembership.MEMBERSHIP.childName));
        membership.add(tuple.get(QMembership.MEMBERSHIP.lowerChildName));
        membership.add(tuple.get(QMembership.MEMBERSHIP.parentName));
        membership.add(tuple.get(QMembership.MEMBERSHIP.lowerParentName));
        membership.add(tuple.get(QMembership.MEMBERSHIP.groupType));
        membership.add(String.valueOf(tuple.get(QMembership.MEMBERSHIP.membershipType)));
        membership.add("Membership.directoryId-"+String.valueOf(tuple.get(QMembership.MEMBERSHIP.directoryId)));
        membership.add("Membership.userId="+String.valueOf(tuple.get(QMembership.MEMBERSHIP.childId)));
        membership.add("Membership.groupId="+String.valueOf(tuple.get(QMembership.MEMBERSHIP.parentId)));
        membership.add("User.id="+String.valueOf(tuple.get(QUser.MEMBERSHIP.id)));
        membership.add("User.directoryId="+String.valueOf(tuple.get(QUser.MEMBERSHIP.directoryId)));
        membership.add("User.userName="+tuple.get(QUser.MEMBERSHIP.userName));
        membership.add("User.lowerUserName="+tuple.get(QUser.MEMBERSHIP.lowerUserName));

        return membership.stream().collect(Collectors.joining(", "));
    }

}
