package de.accxia.jira.addon.IUM.servlet;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.impl.OldestUser;
import de.accxia.jira.addon.IUM.model.NavUserDTO;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import de.accxia.jira.addon.IUM.servlet.filter.XSSHttpServletRequestWrapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


@Scanned
public class IntelligentUserManagerManagementServlet extends HttpServlet {
	
	//1. https://aurelian-jira.accxia.com/plugins/servlet/ium-user?oldest=true
	//2. https://aurelian-jira.accxia.com/plugins/servlet/ium-user?sl=
	/**
	 * 
	 */
	private static final long serialVersionUID = -5623574103725530973L;
	/**
	 * 
	 */
	private static final Logger LOG = LoggerFactory.getLogger(IntelligentUserManagerManagementServlet.class);
	private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	@ComponentImport
	private final UserManager userManager;
	@ComponentImport
	private final LoginUriProvider loginUriProvider;
	@ComponentImport
	private final TemplateRenderer renderer;

	@ComponentImport
	private final WebSudoManager webSudoManager;
	@ComponentImport
	private final ApplicationProperties applicationProperties;
	private final PocketRepository pocketRepository;

	private static final GroupManager groupManager = ComponentAccessor.getGroupManager();
	private final BuildUtilsInfo buildUtilsInfo;
	
	private String fromgroup=null;
	private String togroup=null;
	private String filtergroup=null;
	private String noof=null;
	
	
	@Inject
	public IntelligentUserManagerManagementServlet(PocketRepository pocketRepository ,
							UserManager userManager,
							LoginUriProvider loginUriProvider,
							TemplateRenderer renderer,
							ApplicationProperties applicationProperties, WebSudoManager webSudoManager) {
		this.pocketRepository = pocketRepository;
		this.userManager = userManager;
		this.loginUriProvider = loginUriProvider;
		this.renderer = renderer;
		this.applicationProperties=applicationProperties;
		this.buildUtilsInfo=(BuildUtilsInfo) ComponentAccessor.getComponent(BuildUtilsInfo.class);
		this.webSudoManager=webSudoManager;
	}

	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
		try {
			//xss wrapper
			XSSHttpServletRequestWrapper xssRrequest = new XSSHttpServletRequestWrapper(request);

			//validate refer
			if(!ServletHelper.doCheckOriginAndReferrer(this.applicationProperties.getBaseUrl(),request,response)){
				forceToLogin(request, response);
				// response.sendError(HttpServletResponse.SC_BAD_REQUEST, "message goes here");
				return;
			}

			UserKey userKey = userManager.getRemoteUserKey();
			if (userKey == null || !userManager.isAdmin(userKey)) {
				redirectToLogin(xssRrequest, response);
				return;
			}

			//validation input
			if(!ServletHelper.doValidateInput(request,response)){
				redirectToLogin(request, response);
				// response.sendError(HttpServletResponse.SC_BAD_REQUEST, "message goes here");
				return;
			}

            webSudoManager.willExecuteWebSudoRequest(xssRrequest);
			String action=xssRrequest.getParameter("action");
			if (!ConditionEvaluatorImpl.isLicenseValid()) {
				renderLicenseErrorVM(response, false);
				return;
			}
			Map<String, Object> map = new HashMap<String, Object>();
			if ("list".equals(action)) {
				String fromGroup="";
				if (xssRrequest.getParameter("fromgroup")!=null) {
					fromGroup = xssRrequest.getParameter("fromgroup");
				}
				String toGroup="";
				if (xssRrequest.getParameter("togroup")!=null) {
					toGroup = xssRrequest.getParameter("togroup");
				}
				String filterGroup="";
				if (xssRrequest.getParameter("filtergroup")!=null) {
					filterGroup = xssRrequest.getParameter("filtergroup");
				}
				int noof=10;
				try {
					if (xssRrequest.getParameter("noof")!=null) {
						noof=Integer.parseInt(xssRrequest.getParameter("noof"));
					}
				} catch(Exception e) {
					noof=10;
				}
				
				this.fromgroup=setValue("fromgroup", fromGroup);
				
				this.togroup=setValue("togroup", toGroup);
				this.filtergroup=setValue("filtergroup", filterGroup);
				
				this.noof=setValue("noof", ""+noof);
				Pagination<NavUserDTO> pagination =createPagination(fromgroup,filtergroup, 1, noof );
				//List<OldestUser> users=IntelligentUserManagerHelper.getSortedUserListFromGroup(fromgroup, 0,noof, filtergroup);
				
				map.put("fromgroup", fromGroup);
				map.put("togroup", toGroup);
				map.put("filtergroup", filterGroup);
				map.put("noof", getValue("noof", ""+noof));
				map.put("pagination", pagination);
				renderUserVM(response, map);
				return;
			} else if ((("move".equals(action))||("copy".equals(action)))) {
				//TBD	
				String[] selectedUsers=null;
				String fromGroup="";
				if (xssRrequest.getParameter("fromgroup")!=null) {
					fromGroup = xssRrequest.getParameter("fromgroup");
				}
				String toGroup="";
				if (xssRrequest.getParameter("togroup")!=null) {
					toGroup = xssRrequest.getParameter("togroup");
				}
				this.fromgroup=setValue("fromgroup", fromGroup);
				this.togroup=setValue("togroup", toGroup);
				String res="";
				if (xssRrequest.getParameter("selUser")!=null) {
					selectedUsers = xssRrequest.getParameterValues("selUser");
					res=IntelligentUserManagerHelper.moveUsersInListFromGroupToGroup(selectedUsers, fromGroup, toGroup, "move".equals(action));
				}
				map.put("fromgroup", getValue("fromgroup", fromGroup));
				map.put("togroup", getValue("togroup", toGroup));
				map.put("noof", getValue("noof", noof));
				map.put("successMessage", res);
				
				renderUserVM(response, map);
				return;
			}
			renderUserVM(response, map);
    			
		} catch (WebSudoSessionException wes) { // Send an error or redirect the user to the initial form.
			response.sendError(HttpServletResponse.SC_FORBIDDEN);
		}
	}

	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		try {
			//xss wrapper
			XSSHttpServletRequestWrapper xssRrequest = new XSSHttpServletRequestWrapper(request);

			UserKey userKey = userManager.getRemoteUserKey();
			if (userKey == null || !userManager.isAdmin(userKey)) {
				redirectToLogin(xssRrequest, response);
				return;
			}
			webSudoManager.willExecuteWebSudoRequest(xssRrequest);
		
            boolean showSideLicense = (xssRrequest.getParameter("sl") != null);
    		if (showSideLicense) {	
    			renderSideLicenseVM(response);
				return;
    		}

			showSideLicense = (!("".equals(DAO.getSideLicense())));
			if (!ConditionEvaluatorImpl.isLicenseValid()) {
				renderLicenseErrorVM(response, showSideLicense);
				return;
			}

			if (xssRrequest.getParameter("oldest")!=null) {

					String group = DAO.getIUMGroups();
					String[] enableGroupNames = group != null ? group.split(",") : null;
					StringBuffer sb = new StringBuffer();
					boolean found = false;


					for (int i=0; i<enableGroupNames.length;i++) {
						if(enableGroupNames[i]==null || enableGroupNames[i].length()<1) continue;

						Group testGroup=groupManager.getGroup(enableGroupNames[i]);
						List<OldestUser> oldestUserList=IntelligentUserManagerHelper.getOldestUser(testGroup,null,10);

						String separator ="\n";
						sb.append(separator)
								.append("Analyse Group " +enableGroupNames[i]).append("  for duration ").append(DAO.getDuration())
								.append(separator)
								.append(" Found at least  " + oldestUserList.size())
								.append(separator);
						if(oldestUserList.size()>0){
							found=true;
							sb.append(oldestUserList.stream().map(oUser -> {
								return oUser.getUser().getUsername() + " - " +SDF.format(oUser.getTimeStamp()) ;
							}).collect(Collectors.joining(separator)));
						}
						sb.append(separator);
					}

    				response.setContentType("text/plain");
    				if (found) {
    					response.getWriter().write(sb.toString());
    				} else {
    					response.getWriter().write("No Oldest User found for Group(s) "+group);
    				}
    				
    				return;
    			}

			Map<String, Object> map = new HashMap<String, Object>();
			map.put("fromgroup", getValue("fromgroup", fromgroup));
			map.put("togroup", getValue("togroup", togroup));
			map.put("filtergroup", getValue("filtergroup", filtergroup));
			map.put("noof", getValue("noof", noof));

			if (xssRrequest.getParameter("list")!=null) {
				Pagination<NavUserDTO> pagination = createPagination(xssRrequest);
				map.put("pagination", pagination);
			}else{
				fromgroup =getValue("fromgroup", fromgroup);
				filtergroup =getValue("filtergroup", filtergroup);
				if(!StringUtils.isEmpty(fromgroup)){
					Pagination<NavUserDTO> pagination = createPagination(fromgroup,filtergroup,1,10);
					map.put("pagination", pagination);
				}
			}

			renderUserVM(response,map);

		} catch (WebSudoSessionException wes) {
			LOG.error("WebSudoSessionException " + wes.getMessage(),wes);
			// Send an error or redirect the user to the initial form.
			//response.sendError(HttpServletResponse.SC_FORBIDDEN);
			webSudoManager.enforceWebSudoProtection(request, response);

		}	
	}

	private Pagination<NavUserDTO> createPagination(ServletRequestWrapper xssRrequest) {
		String fromGroup=getValue("fromgroup", fromgroup);
		String filterGroup=getValue("filtergroup", filtergroup);
		int page=1;
		int pageSize=10;
		try {
			if (xssRrequest.getParameter("page")!=null) {
				page=Integer.parseInt(xssRrequest.getParameter("page"));
			}
		} catch(Exception e) {
			page=1;
		}
		try {
			if (xssRrequest.getParameter("noof")!=null) {
				pageSize=Integer.parseInt(xssRrequest.getParameter("noof"));
			}
		} catch(Exception e) {
			pageSize=10;
		}


		return  createPagination(fromGroup,filterGroup,page ,pageSize);
	}

	private Pagination<NavUserDTO> createPagination(String fromGroup,String filterGroup, int page ,int pageSize) {
		List<NavUserDTO> navUsers=pocketRepository.getOldestUsers(fromGroup,filterGroup,(page-1)*pageSize,pageSize);
		long countUsers = pocketRepository.countOldestUsers(fromGroup,filterGroup);
		int pageCount = (int) (countUsers / pageSize + (countUsers % pageSize != 0 ? 1 : 0));

		Pagination<NavUserDTO> pagination = new Pagination<>(navUsers,page,pageSize,pageCount);

		return pagination;
	}
	private void renderLicenseErrorVM(HttpServletResponse response, boolean showSideLicense) throws IOException {
		Map<String, Object> context = new HashMap<String, Object>();
		response.setContentType("text/html;charset=utf-8");
		context.put("showSideLicense", showSideLicense);
		context.put("baseurl", this.applicationProperties.getBaseUrl());
		renderer.render("templates/checklicense_IUM.vm", context, response.getWriter());
	}

	private void renderUserVM(HttpServletResponse response, Map<String, Object> context) throws IOException {
		context.put("isJira8", isJira8x());

		response.setContentType("text/html;charset=utf-8");
		renderer.render("templates/user_IUM.vm", context, response.getWriter());
	}

	private void forceToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
		URI origin = getUri(request);
		request.getSession().invalidate();
		response.sendRedirect(loginUriProvider.getLoginUri(origin).toASCIIString());
	}

	private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.sendRedirect(loginUriProvider.getLoginUri(getUri(request)).toASCIIString());
	}

	private URI getUri(HttpServletRequest request) {
		StringBuffer builder = request.getRequestURL();
		if (request.getQueryString() != null) {
			builder.append("?");
			builder.append(request.getQueryString());
		}
		return URI.create(builder.toString());
	}

	private void renderSideLicenseVM(HttpServletResponse response) throws IOException {
		Map<String, Object> context = new HashMap<String, Object>();
		context.put("sideLicense", DAO.getSideLicense());

		response.setContentType("text/html;charset=utf-8");
		renderer.render("templates/sidelicense_IUM.vm", context, response.getWriter());
	}
	
	public String getValue(String key, String currentVal)
	{
		return((currentVal==null)? DAO.getValue(key):currentVal);
	}

	public String setValue(String key, String value) {
		if (value == null) value = "";
		DAO.setValue(key, value);
		return (value);
	}
	
	private boolean isEmpty(String contextPath) {
		return contextPath == null || contextPath.isEmpty();
	}
	private boolean isJira8x(){
		// [8, 22, 3]
		int[] versions= this.buildUtilsInfo.getVersionNumbers();
		if(versions !=null && versions.length>0 && versions[0]>7){
			return true;
		}

		return false;
	}

}
