package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import de.accxia.jira.addon.IUM.servlet.session.AccxiaUserSessionTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Scanned
public class AccessLogFilter implements Filter {

    private static final Logger LOG = LoggerFactory.getLogger(AccessLogFilter.class);

    /**
     * Does nothing but prints INFO log message
     *
     * @param filterConfig not used
     * @throws ServletException not thrown
     */
    public void init(final FilterConfig filterConfig) throws ServletException    {
        LOG.info("AccessLogFilter initialized.");
    }

    /**
     *
     * @param servletRequest request
     * @param servletResponse response
     * @param filterChain filter chain
     * @throws IOException if another filter in the filter chain throws it
     * @throws ServletException if another filter in the filter chain throws it
     */
    public void doFilter(final ServletRequest servletRequest, final ServletResponse servletResponse, final FilterChain filterChain)
            throws IOException, ServletException{

        // now look into the request and log it
        final HttpServletRequest httpServletRequest = (HttpServletRequest) servletRequest;
        final HttpServletResponse httpServletResponse = (HttpServletResponse) servletResponse;

        try
        {
            filterChain.doFilter(httpServletRequest, httpServletResponse);
        }finally{
            try{
                AccxiaUserSessionTracker.recordInteraction(httpServletRequest);
            }catch (Exception e){
                LOG.error("Exception: "+e.getMessage(),e);
            }
        }
    }

    @Override
    public void destroy() {

    }

}
