package de.accxia.jira.addon.IUM.servlet.filter;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

/**
 * Response wrapper used to capture underlying stream and modify final response.
 *
 * @since 7.1
 */
public class AccxiaResponseWrapper extends HttpServletResponseWrapper {
	private final ByteArrayOutputStream capture;
	private ServletOutputStream output;
	private PrintWriter writer;
	private String redirLocation="";

	public AccxiaResponseWrapper(HttpServletResponse response) {
		super(response);
		capture = new ByteArrayOutputStream(response.getBufferSize());
	}

	@Override
	public ServletOutputStream getOutputStream() {
		if (writer != null) {
			throw new IllegalStateException(
					"getWriter() has already been called on this response.");
		}

		if (output == null) {
			output = new BaseServletOutputStream() {
				//Preparation for migrate to servlet 3.x
				/*
				@Override
				public boolean isReady() {
					return false;
				}

				@Override
				public void setWriteListener(javax.servlet.WriteListener writeListener) {

				}
				*/

				@Override
				public void write(int b) throws IOException {
					capture.write(b);
				}

				@Override
				public void flush() throws IOException {
					capture.flush();
				}

				@Override
				public void close() throws IOException {
					capture.close();
				}
			};
		}

		return output;
	}

	@Override
	public PrintWriter getWriter() throws IOException {
		if (output != null) {
			throw new IllegalStateException(
					"getOutputStream() has already been called on this response.");
		}

		if (writer == null) {
			writer = new PrintWriter(new OutputStreamWriter(capture, getCharacterEncoding()));
		}

		return writer;
	}

	@Override
	public void flushBuffer() throws IOException {
		super.flushBuffer();

		if (writer != null) {
			writer.flush();
		} else if (output != null) {
			output.flush();
		}
	}

	public byte[] getCaptureAsBytes() throws IOException {
		if (writer != null) {
			writer.close();
		} else if (output != null) {
			output.close();
		}

		return capture.toByteArray();
	}

	public String getCaptureAsString() throws IOException {
		return new String(getCaptureAsBytes(), getCharacterEncoding());
	}
	
	// there is an issue with redirects in request wrapper, as sson as a redirect 
	// is set it would be executed this is why we override it and create a Getter.
	
	@Override
	 public void sendRedirect(String location) throws IOException{
		this.redirLocation=location;
		//ignore all redirects here
	}
	
	public String getRedirectLocation() throws IOException{
		return(redirLocation);

	}

}