package de.accxia.jira.addon.IUM.servlet.filter;



import org.codehaus.jackson.annotate.JsonAutoDetect;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.List;

@XmlRootElement(name ="users" )
@XmlAccessorType(XmlAccessType.PROPERTY)
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class UserPickerResultsBean {

    @XmlElement
    private List<UserPickerUser> users;
    @XmlElement
    private Integer total;
    @XmlElement
    private String header;
    @XmlElement
    private String ium;
    private UserPickerResultsBean() {
    }

    public UserPickerResultsBean(List<UserPickerUser> users, String header, Integer total) {
        this.users = users;
        this.header = header;
        this.total = total;
        this.ium = "IUM for Jira";
    }

    //================================================================
    //
    //================================================================

    public List<UserPickerUser> getUsers() {
        return users;
    }

    public void setUsers(List<UserPickerUser> users) {
        this.users = users;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public String getHeader() {
        return header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getIum() {
        return ium;
    }

    public void setIum(String ium) {
        this.ium = ium;
    }
}
