package de.accxia.jira.addon.IUM.servlet.filter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import java.util.HashMap;
import java.util.Map;

public class XSSHttpServletRequestWrapper extends HttpServletRequestWrapper {
    private Map<String, String[]> sanitized;

    /**
     * Constructor that will parse and sanitize all input parameters.
     *
     * @param request the HttpServletRequest to wrap
     */
    public XSSHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        sanitized = sanitizeParamMap(request.getParameterMap());
    }

    @Override
    public String getParameter(String name) {
        String[] vals = getParameterValues(name);
        if (vals != null && vals.length > 0)
            return vals[0];
        else
            return null;
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return sanitized;

    }

    @Override
    public String[] getParameterValues(String name) {
        return sanitized.get(name);
    }

    private Map<String, String[]> sanitizeParamMap(Map<String, String[]> raw) {
        Map<String, String[]> res = new HashMap<>();

        if (raw != null) {
            for (String key : raw.keySet()) {
                String[] rawVals = raw.get(key);
                if (rawVals != null && rawVals.length > 0) {
                    String[] snzVals = new String[rawVals.length];
                    for (int i = 0; i < rawVals.length; i++) {
                        snzVals[i] = sanitize(rawVals[i]);
                    }
                    res.put(key, snzVals);
                } else {
                    res.put(key, rawVals);
                }

            }
        }

        return res;
    }

    /**
     * Remove all tags from the content
     */
    private String sanitize(String s) {
        if (s == null || "".equals(s.trim())) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 16);
        for (int i = 0; i < s.length(); i++) {
            char c = s.charAt(i);
            switch (c) {
                case '>':
                    sb.append('＞');
                    break;
                case '<':
                    sb.append('＜');
                    break;
                case '\'':
                    sb.append('‘');
                    break;
                case '\"':
                    sb.append('“');
                    break;
                case '&':
                    sb.append('＆');
                    break;
                case '\\':
                    sb.append('＼');
                    break;
                case '#':
                    sb.append('＃');
                    break;
                default:
                    sb.append(c);
                    break;
            }
        }
        return sb.toString();
    }
}
