package de.accxia.jira.addon.IUM.servlet.session;


import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

class AccxiaUserSessionTrackerDeletionStrategy {
    private final AtomicBoolean deleteStaleSessionsPermit = new AtomicBoolean(false);
    private long nextCheckTime = System.currentTimeMillis();
    private static final long MAX_SESSION_AGE = 14400000L;
    private static final long MIN_TIME_BETWEEN_CHECKS = 30000L;

    AccxiaUserSessionTrackerDeletionStrategy() {
    }

    void deleteStaleSessions(ConcurrentMap<String, AccxiaMutableJiraUserSession> liveSessionMap) {
        long now = System.currentTimeMillis();
        if (now >= this.nextCheckTime && this.deleteStaleSessionsPermit.compareAndSet(false, true)) {
            try {
                this.cleanupStaleSessions(liveSessionMap);
            } finally {
                this.nextCheckTime = now + MIN_TIME_BETWEEN_CHECKS;
                this.deleteStaleSessionsPermit.set(false);
            }
        }

    }

    private void cleanupStaleSessions(ConcurrentMap<String, AccxiaMutableJiraUserSession> liveSessionMap) {
        Iterator<Map.Entry<String, AccxiaMutableJiraUserSession>> it = liveSessionMap.entrySet().iterator();

        while(it.hasNext()) {
            Map.Entry<String, AccxiaMutableJiraUserSession> next = (Map.Entry)it.next();
            AccxiaMutableJiraUserSession accxiaMutableJiraUserSession = next.getValue();
            if(this.sessionHasExpired(accxiaMutableJiraUserSession)){
                accxiaMutableJiraUserSession.removeDB();
                it.remove();
            }

        }

    }

    private boolean sessionHasExpired(AccxiaMutableJiraUserSession userSession) {
        if (userSession == null) {
            return false;
        } else {
            Date lastAccessTime = userSession.getLastAccessTime();
            long sessionAgeMillis = System.currentTimeMillis() - lastAccessTime.getTime();
            return sessionAgeMillis > MAX_SESSION_AGE;
        }
    }
}

