var IUMLogout = new function() {
	var self=this;
	var theTimer;
	const INTERVAL=15000;
	const DELTA=300;
	const DEBUG=false;
	const IUM_CHECK_ACCESS_PING='jira_ium_check_access_ping'
	const IUM_CHECK_ACCESS_LOGOUT='jira_ium_check_access_logout'

	var doDisabled=function(force){
		if(!force && self.theLastUserName){
			document.location.href=AJS.contextPath() + "/secure/disable?username="+self.theLastUserName;
		}else {
			document.location.href = AJS.contextPath() +"/login.action?os_destination=" +document.location.href +"&permissionViolation=true";
			// document.location.href=AJS.$("#log_out").attr("href");
		}
	}
	
	var checkApplicationAccess=function(){
		//1. header
		var userName=AJS.$("#header-details-user-fullname").attr("data-username");
		//2.meta
		if(!userName) {userName=AJS.$("meta[name='loggedInUser']").attr('content');}
		if(!userName) {userName=AJS.$("meta[name='ajs-remote-user']").attr('content');}

		if (typeof (userName)=="undefined"){
			clearInterval(theTimer);
		} else {
			self.theLastUserName=userName;
			var dateNow = Date.now();
			var dateStr = window.localStorage.getItem(IUM_CHECK_ACCESS_PING);
			var dateRef =null;
			if(dateStr){
				try {
					dateRef = JSON.parse(dateStr);
					var dateDiff = dateNow - dateRef.timestamp;
					if(DEBUG){
						console.log("CHK:" + (new Date(dateNow).toISOString().slice(-13, -5)) + " / " + (new Date(dateRef.timestamp).toISOString().slice(-13, -5)) + " Access diff " + (dateNow - dateRef.timestamp));
					}

					if (((Math.abs(dateDiff - INTERVAL) > DELTA) && (dateDiff < INTERVAL + 2 * DELTA)) && (dateRef.username === userName)) {
						if(DEBUG){
							console.log("BKP:" + (new Date(dateNow).toISOString().slice(-13, -5)) + " / " + (new Date(dateRef.timestamp).toISOString().slice(-13, -5)) + " Access diff " + (dateNow - dateRef.timestamp));
						}
						doProcessData(dateRef, false);
						return;
					}
				} catch (error) {
					console.error(error);
					dateRef =null;
				}
			}


			if(DEBUG){
				if(dateRef && dateRef.timestamp){
					console.log("NET:" +( new Date().toISOString().slice(-13, -5)) + " / " + ( new Date(dateRef.timestamp).toISOString().slice(-13, -5))  +  " Access diff " +(dateNow - dateRef.timestamp) );
				}else{
					console.log("NET:" +( new Date().toISOString().slice(-13, -5)));
				}
			}
			var contextPath = AJS.contextPath() || "";
			self.ajaxGetCall(contextPath + "/rest/IUM/latest/apps?username="+userName);
		}	
	}
	
	this.startLogoutWatcher=function(){
		setTimeout( checkApplicationAccess(),1000);
		theTimer=setInterval(checkApplicationAccess, INTERVAL);

		window.addEventListener('storage', function(event) {
			// Check the changed key and react accordingly
			if (event.key === IUM_CHECK_ACCESS_LOGOUT) {
				var datRef =JSON.parse(event.newValue);
				if(self.theLastUserName === datRef.username){
					doDisabled();
				}
			}
		});
	}

	var callDisabledOrLogout=function(force){
		clearInterval(theTimer);
		var dateRef={username:self.theLastUserName, timestamp:Date.now()};
		window.localStorage.setItem(IUM_CHECK_ACCESS_LOGOUT,JSON.stringify(dateRef));
		doDisabled(force);
		console.log("ACCXIA IUM: User has been logged out");
	}

	var doProcessData=function(data,withSaving){
		// console.warn("data="+ JSON.stringify(data));
		if (Object.keys(data).length==0){
			callDisabledOrLogout();
			return;
		}
		try {
			//1. service desk | software
			if(!data["jira-servicedesk"] && !data["jira-software"] && !data["jira-core"] ){
				callDisabledOrLogout();
				return;
			}

			var msg = "";
			if(data["could-has-software"] &&  !data["jira-software"] ){
				msg = AJS.I18n.getText('de.accxia.apps.jira.IUM.lost.access.warning',  "jira-software ");
			}

			if(data["could-has-service"] &&  !data["jira-servicedesk"] ){
				msg = AJS.I18n.getText('de.accxia.apps.jira.IUM.lost.access.warning',  "jira-servicedesk ");
			}

			if(data["could-has-core"] &&  !data["jira-core"] ){
				msg = AJS.I18n.getText('de.accxia.apps.jira.IUM.lost.access.warning',  "jira-core ");
			}

			if(msg) {
				doPopupPartialPermission(msg);
			}else{
				IUMLogin && IUMLogin.doClosePopupFlag();
				IUMLogin && IUMLogin.doCleanRemindFlag();
				olderMessage=null;
			}

		}finally {
			if(withSaving){
				data.timestamp = Date.now();
				window.localStorage.setItem(IUM_CHECK_ACCESS_PING,JSON.stringify(data));
				if(DEBUG){
					console.log("SAVE:" + ( new Date(data.timestamp).toISOString().slice(-13, -5))  +  " data=" +JSON.stringify(data) );
				}
			}
		}
	}

	this.ajaxGetCall = function(url) {
		jQuery.ajax({
			url : url,
			dataType : 'json',
			contentType: "application/json; charset=utf-8",
			async : true,
			success : function(data) {
				doProcessData(data,true)
			},
			error :function (xhr, textStatus, errorThrown ) {
				if (xhr.status >= 400 || errorThrown ) {
					// {"message":"Client must be authenticated to access this resource.","status-code":401}   Unauthorized
					if(xhr.status==401){
						callDisabledOrLogout(true);
						return;
					}

					callDisabledOrLogout();
				}
			}
		});
	};

	var olderMessage;
	var doPopupPartialPermission=function(message){
		if(!IUMLogin.login_flag_hide || (message && message != olderMessage)){
			olderMessage=message;
			IUMLogin.doClosePopupFlag();

			IUMLogin.login_flag = AJS.flag({
				type: 'warning',
				title:'Intelligent User Manager (IUM)',
				body:message +
					'<ul class="aui-nav-actions-list">' +
					'<li><a class="aui-button aui-button-link" onclick="IUMLogout.doCloseAndRetryFlag()" href="#">Retry</a></li>' +
					'</ul>'
			});
			IUMLogin.login_flag_hide=false;
		}

	};


};

IUMLogout.doCloseAndRetryFlag=function(){

	jQuery.ajax({
		url : AJS.contextPath() + "/rest/IUM/latest/retry",
		dataType : 'json',
		contentType: "application/json; charset=utf-8",
		success : function(data) {
			if(data && data.warningMessage){
				IUMLogin.doUpdateCookie(data.warningMessage);
				IUMLogin.startIUMLoginWatcher();
			}else{

				IUMLogin.doCleanRemindFlag();
				IUMLogin.doPopupFullPermission()
			}
		},
		error :function (xhr, textStatus, errorThrown ) {
			if ((xhr && xhr.status >= 400) || errorThrown ) {
				console.error(xhr);
			}
		}
	});

	return false;
}

AJS.$( document ).ready(function() {
	IUMLogout.startLogoutWatcher();

	document.addEventListener('aui-flag-close', function(e) {
		if(IUMLogin.login_flag /*&& IUMLogin.login_flag == IUMLogin.login_flag*/ ){
			IUMLogin.login_flag_hide=true;
		}
	});

});
