/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.job;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Sets;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.job.IJob;
import de.accxia.jira.addon.IUM.job.ProcessResult;
import de.accxia.jira.addon.IUM.repository.JobResultRepository;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import de.accxia.jira.addon.IUM.servlet.HelperTrialProcessing;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMDailyJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMDailyJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMDailyJob instance;
    private HelperTrialProcessing helperTrialProcessing;
    private PocketRepository pocketRepository;
    private JobResultRepository jobResultRepository;
    private ApplicationRoleManager applicationRoleManager;
    private static UserUtil userUtil;
    int syncUsers = 0;

    private IUMDailyJob() {
    }

    public static IUMDailyJob getInstance() {
        if (instance == null) {
            instance = new IUMDailyJob();
        }
        return instance;
    }

    @Override
    public void injectService(HelperTrialProcessing helperTrialProcessing, PocketRepository pocketRepository, JobResultRepository jobResultRepository) {
        IUMDailyJob.instance.helperTrialProcessing = helperTrialProcessing;
        IUMDailyJob.instance.pocketRepository = pocketRepository;
        IUMDailyJob.instance.jobResultRepository = jobResultRepository;
    }

    @Override
    public void injectService(ApplicationRoleManager applicationRoleManager) {
        IUMDailyJob.instance.applicationRoleManager = applicationRoleManager;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) throws RemoveException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMDailyJob Process #[" + SDF.format(new Date()) + "] ");
        }
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        String sourceGroups = DAO.getIUMGroups();
        String targetGroup = DAO.getIUMGroupsDisabled();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMDailyJob Sync groups = {} -> {}  at [ {} ] ", new Object[]{sourceGroups, targetGroup, SDF.format(new Date())});
        }
        if (this.jobResultRepository != null && !StringUtils.isEmpty((CharSequence)sourceGroups) && !StringUtils.isEmpty((CharSequence)targetGroup)) {
            ProcessResult processResult;
            String[] iumGroups = sourceGroups.split(",");
            String[] iumGroupDISs = targetGroup.split(",");
            GroupManager groupManager = ComponentAccessor.getGroupManager();
            UserManager userManager = ComponentAccessor.getUserManager();
            UserUtil userUtil = ComponentAccessor.getUserUtil();
            if (iumGroups.length > 0 && iumGroupDISs.length > 0) {
                SortedSet<ApplicationUser> userJiraAccess = this.getUsersWithJiraAccessExceptGroup(iumGroups[0]);
                processResult = this.processPair(groupManager, userUtil, iumGroups[0], iumGroupDISs[0], userJiraAccess);
                processResultList.add(processResult);
            }
            if (iumGroups.length > 1 && iumGroupDISs.length > 1) {
                SortedSet<ApplicationUser> userSDeskAccess = this.getUsersWithSDeskAccessExceptGroup(iumGroups[1]);
                processResult = this.processPair(groupManager, userUtil, iumGroups[1], iumGroupDISs[1], userSDeskAccess);
                processResultList.add(processResult);
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("IUMDailyJob copied #" + this.syncUsers + " to group " + targetGroup);
            }
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMDailyJob Processed #[" + SDF.format(new Date()) + "] ");
        }
        return processResultList;
    }

    private ProcessResult processPair(GroupManager groupManager, UserUtil userUtil, String sourceGroups, String targetGroup, Set<ApplicationUser> applicationUserAccess) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMDailyJob Sync groups = {} -> {}  at [ {} ] ", new Object[]{sourceGroups, targetGroup, SDF.format(new Date())});
        }
        ProcessResult processResult = new ProcessResult("DailyJob", sourceGroups, targetGroup);
        if (sourceGroups != null && targetGroup != null) {
            Group jiraSourceGroup = groupManager.getGroup(sourceGroups);
            Group jiraTargetGroup = groupManager.getGroup(targetGroup);
            if (jiraSourceGroup != null && jiraTargetGroup != null) {
                Set sourceUsers = groupManager.getUsersInGroup(sourceGroups).stream().collect(Collectors.toSet());
                Set targetUsers = groupManager.getUsersInGroup(targetGroup).stream().collect(Collectors.toSet());
                Sets.SetView set1RemoveView = Sets.intersection(sourceUsers, applicationUserAccess);
                Sets.SetView set2RemoveView = Sets.intersection(targetUsers, applicationUserAccess);
                processResult.setUserRemoved(0L);
                set2RemoveView.stream().forEach(user -> {
                    try {
                        userUtil.removeUserFromGroup(jiraTargetGroup, user);
                        processResult.setUserRemoved(processResult.getUserRemoved() + 1L);
                        if (this.LOG.isInfoEnabled()) {
                            this.LOG.info("IUMDailyJob removed user {} to group   {} ", new Object[]{user.getUsername(), targetGroup});
                        }
                    }
                    catch (Exception e) {
                        this.LOG.error("Exception " + e.getMessage(), (Throwable)e);
                    }
                });
                targetUsers.stream().filter(user -> !user.isActive()).forEach(user -> {
                    try {
                        userUtil.removeUserFromGroup(jiraTargetGroup, user);
                        processResult.setUserRemoved(processResult.getUserRemoved() + 1L);
                        if (this.LOG.isInfoEnabled()) {
                            this.LOG.info("IUMDailyJob removed user {} to group   {} ", new Object[]{user.getUsername(), targetGroup});
                        }
                    }
                    catch (Exception e) {
                        this.LOG.error("Exception " + e.getMessage(), (Throwable)e);
                    }
                });
                processResult.setUserCopied(0L);
                set1RemoveView.stream().forEach(user -> {
                    try {
                        userUtil.removeUserFromGroup(jiraSourceGroup, user);
                        processResult.setUserCopied(processResult.getUserCopied() + 1L);
                        if (this.LOG.isInfoEnabled()) {
                            this.LOG.info("IUMDailyJob removed user {} to group   {} ", new Object[]{user.getUsername(), jiraSourceGroup});
                        }
                    }
                    catch (Exception e) {
                        this.LOG.error("Exception " + e.getMessage(), (Throwable)e);
                    }
                });
                sourceUsers.stream().filter(user -> !user.isActive()).forEach(user -> {
                    try {
                        userUtil.removeUserFromGroup(jiraSourceGroup, user);
                        processResult.setUserRemoved(processResult.getUserRemoved() + 1L);
                        if (this.LOG.isInfoEnabled()) {
                            this.LOG.info("IUMDailyJob removed user {} to group   {} ", new Object[]{user.getUsername(), jiraSourceGroup});
                        }
                    }
                    catch (Exception e) {
                        this.LOG.error("Exception " + e.getMessage(), (Throwable)e);
                    }
                });
            }
        } else {
            this.LOG.warn("IUMDailyJob skipped Empty Source/Target config");
        }
        return processResult;
    }

    @WebSudoRequired
    public SortedSet<ApplicationUser> getUsersWithJiraAccessExceptGroup(String filterGroup) {
        ApplicationRole applicationRole = IUMDailyJob.getApplicationRole(this.applicationRoleManager, ApplicationKeys.SOFTWARE);
        if (applicationRole != null) {
            List groups = applicationRole.getGroups().stream().map(Group::getName).filter(name -> !name.equalsIgnoreCase(filterGroup)).collect(Collectors.toList());
            SortedSet users = userUtil.getAllUsersInGroupNames(groups);
            return users;
        }
        return new TreeSet<ApplicationUser>();
    }

    @WebSudoRequired
    public SortedSet<ApplicationUser> getUsersWithSDeskAccessExceptGroup(String filterGroup) {
        ApplicationRole applicationRole = IUMDailyJob.getApplicationRole(this.applicationRoleManager, ApplicationKeys.SERVICE_DESK);
        if (applicationRole != null) {
            List groups = applicationRole.getGroups().stream().map(Group::getName).filter(name -> !name.equalsIgnoreCase(filterGroup)).collect(Collectors.toList());
            SortedSet users = userUtil.getAllUsersInGroupNames(groups);
            return users;
        }
        return new TreeSet<ApplicationUser>();
    }

    private static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    private static ApplicationRole getApplicationRole(ApplicationRoleManager applicationRoleManager, ApplicationKey applicationKey) {
        if (applicationRoleManager == null || applicationKey == null) {
            return null;
        }
        List applicationRoleList = applicationRoleManager.getRoles().stream().filter(applicationRole -> applicationRole.getKey().equals((Object)applicationKey)).collect(Collectors.toList());
        return applicationRoleList.size() > 0 ? (ApplicationRole)applicationRoleList.get(0) : null;
    }

    static {
        userUtil = ComponentAccessor.getUserUtil();
    }
}

