/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.job;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.status.JobDetails;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.job.IUMDailyEventJob;
import de.accxia.jira.addon.IUM.job.JobDataUtils;
import de.accxia.jira.addon.IUM.job.MonitorJobRunner;
import de.accxia.jira.addon.IUM.job.ProcessResult;
import de.accxia.jira.addon.IUM.model.JobResultDTO;
import de.accxia.jira.addon.IUM.repository.IUMAlertRepository;
import de.accxia.jira.addon.IUM.repository.JobResultRepository;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import de.accxia.jira.addon.IUM.servlet.HelperTrialProcessing;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/dejob")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Named
public class JobDailyEventRestController {
    private static final Logger LOG = LoggerFactory.getLogger(JobDailyEventRestController.class);
    @ComponentImport
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final MonitorJobRunner monitorJobRunner;
    private final JobResultRepository jobResultRepository;
    private final PocketRepository pocketRepository;
    private final HelperTrialProcessing helperTrialProcessing;
    private final IUMAlertRepository iumAlertRepository;
    private static LocalThread localThread = null;

    public JobDailyEventRestController(JiraAuthenticationContext jiraAuthenticationContext, MonitorJobRunner monitorJobRunner, JobResultRepository jobResultRepository, PocketRepository pocketRepository, HelperTrialProcessing helperTrialProcessing, IUMAlertRepository iumAlertRepository) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.monitorJobRunner = monitorJobRunner;
        this.jobResultRepository = jobResultRepository;
        this.pocketRepository = pocketRepository;
        this.helperTrialProcessing = helperTrialProcessing;
        this.iumAlertRepository = iumAlertRepository;
    }

    @Path(value="/config")
    @GET
    @Produces(value={"application/json"})
    public Response getCurrentConfig() {
        List<JobDetails> details;
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put("daily_repeat_interval", DAO.getDailyRepeatInterval());
        map.put("daily_starting_from", DAO.getDailyStartingFrom());
        map.put("working", String.valueOf(this.monitorJobRunner.isWorking(IUMDailyEventJob.class)));
        if (this.monitorJobRunner.getJobDetails(IUMDailyEventJob.class) != null) {
            map.put("jobDetails", this.monitorJobRunner.getJobDetails(IUMDailyEventJob.class).toString());
        }
        if ((details = this.monitorJobRunner.getJobsByJobRunnerKey(IUMDailyEventJob.class)) != null) {
            for (int i = 0; i < details.size(); ++i) {
                map.put("jobDetails " + i, details.get(i).toString());
            }
        }
        if (this.monitorJobRunner.isWorking(IUMDailyEventJob.class)) {
            if (this.monitorJobRunner.getLastRunForJob(IUMDailyEventJob.class) != null) {
                map.put("lastRunForJob", this.monitorJobRunner.getLastRunForJob(IUMDailyEventJob.class).toString());
            }
            if (this.monitorJobRunner.getLastSuccessfulRunForJob(IUMDailyEventJob.class) != null) {
                map.put("lastSuccessfulRunForJob", this.monitorJobRunner.getLastSuccessfulRunForJob(IUMDailyEventJob.class).toString());
            }
            if (this.monitorJobRunner.getNextRunDate(IUMDailyEventJob.class) != null) {
                map.put("nextRunDate", this.monitorJobRunner.getNextRunDate(IUMDailyEventJob.class).toString());
            }
        }
        return Response.ok(map).build();
    }

    @Path(value="/config")
    @POST
    @Produces(value={"application/json"})
    public Response setCurrentConfig(@QueryParam(value="repeat_interval") String repeatinterval, @QueryParam(value="starting_from") String startingFrom) {
        DAO.updateDailyRepeatInterval(repeatinterval);
        DAO.updateDailyStartingFrom(startingFrom);
        return this.getCurrentConfig();
    }

    @Path(value="/start")
    @GET
    @Produces(value={"application/json"})
    public Response startDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMDailyEventJob.class);
            IUMDailyEventJob.getInstance().injectService(this.helperTrialProcessing, this.pocketRepository, this.jobResultRepository);
            IUMDailyEventJob.getInstance().injectService(this.iumAlertRepository);
            String jobKey = this.monitorJobRunner.doSchedule(JobDataUtils.createFakeIUMDailyEventJobData(), IUMDailyEventJob.getInstance());
            if (LOG.isDebugEnabled()) {
                LOG.debug("jobKey= " + jobKey);
            }
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/stop")
    @GET
    @Produces(value={"application/json"})
    public Response stopDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMDailyEventJob.class);
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/runnow")
    @GET
    @Produces(value={"application/json"})
    public Response runNowsJob() {
        if (localThread != null && JobDailyEventRestController.localThread.isWorking) {
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        try {
            HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
            parameters.put("daily_repeat_interval", (Serializable)((Object)DAO.getDailyRepeatInterval()));
            parameters.put("daily_starting_from", (Serializable)((Object)DAO.getDailyStartingFrom()));
            parameters.put("daily_event_from", (Serializable)((Object)"10"));
            String currentUser = this.jiraAuthenticationContext.getLoggedInUser() != null ? this.jiraAuthenticationContext.getLoggedInUser().getUsername() : "IUMPlugin";
            parameters.put("current_user", (Serializable)((Object)currentUser));
            IUMDailyEventJob.getInstance().injectService(this.helperTrialProcessing, this.pocketRepository, this.jobResultRepository);
            IUMDailyEventJob.getInstance().injectService(this.iumAlertRepository);
            localThread = new LocalThread(currentUser, parameters);
            localThread.start();
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }

    @Path(value="/jobcheck")
    @GET
    @Produces(value={"application/json"})
    public Response runNowCheckJob() {
        if (localThread == null) {
            String response = "{\"message\":\"not stating\"}";
            return Response.ok((Object)response).build();
        }
        if (JobDailyEventRestController.localThread.isWorking) {
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        try {
            if (JobDailyEventRestController.localThread.errorMessage != null) {
                String response = "{\"message\":\"" + JobDailyEventRestController.localThread.errorMessage + "\"}";
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
            }
            return Response.ok(JobDailyEventRestController.localThread.processResultList).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }

    @Path(value="/jobresults")
    @GET
    @Produces(value={"application/json"})
    public Response getLatestJobResults() {
        if (this.jobResultRepository == null) {
            String response = "{\"message\":\"not stating\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
        List jobResultDTOList = Arrays.stream(this.jobResultRepository.findAll(0, 10)).map(jobResult -> JobResultDTO.fromAO(jobResult)).collect(Collectors.toList());
        return Response.ok(jobResultDTOList).build();
    }

    @Path(value="/clean")
    @GET
    @Produces(value={"application/json"})
    public Response doClean() {
        String retVal = "ok";
        if (localThread != null) {
            retVal = JobDailyEventRestController.localThread.errorMessage;
            LOG.info(JobDailyEventRestController.localThread.errorMessage);
            localThread.interrupt();
            localThread.stop();
            JobDailyEventRestController.localThread.isWorking = false;
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)retVal).build();
    }

    private void doSaveProcessResultList(List<ProcessResult> processResultList, Map<String, Serializable> parameters, long elapsedTime) {
        String currentUser = (String)((Object)parameters.get("current_user"));
        for (ProcessResult processResult : processResultList) {
            this.jobResultRepository.save(JobResultDTO.createJobResult(processResult, currentUser, elapsedTime));
        }
    }

    class LocalThread
    extends Thread {
        Map<String, Serializable> parameters;
        String currentUser;
        List<ProcessResult> processResultList = null;
        String errorMessage;
        boolean isWorking;

        public LocalThread(String currentUser, Map<String, Serializable> parameters) {
            this.parameters = parameters;
            this.currentUser = currentUser;
            this.isWorking = false;
            this.errorMessage = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                JobDailyEventRestController.localThread.isWorking = true;
                IUMDailyEventJob.getInstance().injectService(JobDailyEventRestController.this.helperTrialProcessing, JobDailyEventRestController.this.pocketRepository, JobDailyEventRestController.this.jobResultRepository);
                IUMDailyEventJob.getInstance().injectService(JobDailyEventRestController.this.iumAlertRepository);
                List<ProcessResult> processResultList = IUMDailyEventJob.getInstance().doProcessingJob(this.parameters);
                long stopTime = System.currentTimeMillis();
                long elapsedTime = stopTime - startTime;
                JobDailyEventRestController.localThread.processResultList = processResultList;
                JobDailyEventRestController.this.doSaveProcessResultList(processResultList, this.parameters, elapsedTime);
            }
            catch (Exception e) {
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                try {
                    JobDailyEventRestController.localThread.errorMessage = e.getMessage();
                }
                catch (Exception ex) {
                    LOG.error("Exception: " + ex.getMessage(), (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            finally {
                JobDailyEventRestController.localThread.isWorking = false;
            }
        }
    }
}

