/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.listener;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.groups.GroupManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupManagerProxy {
    private static final Logger log = LoggerFactory.getLogger(GroupManagerProxy.class);

    public static GroupManager createProxy() {
        final GroupManager originalGroupManager = ComponentAccessor.getGroupManager();
        return (GroupManager)Proxy.newProxyInstance(GroupManager.class.getClassLoader(), new Class[]{GroupManager.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("addUserToGroup".equals(method.getName()) && args.length == 2) {
                    log.info("User {} is being added to group {}", args[0], args[1]);
                } else if ("removeUserFromGroup".equals(method.getName()) && args.length == 2) {
                    log.info("User {} is being removed from group {}", args[0], args[1]);
                }
                return method.invoke((Object)originalGroupManager, args);
            }
        });
    }
}

