/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.annotations.security.UnlicensedSiteAccess;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.component.ComponentLocator;
import de.accxia.jira.addon.IUM.agents.AgentResultsResponse;
import de.accxia.jira.addon.IUM.agents.AgentWorkload;
import de.accxia.jira.addon.IUM.agents.AgentWorkloadImpl;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.util.ContentCachingResponseWrapper;

@Component
@UnlicensedSiteAccess
public class IUMRestSDFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(IUMRestSDFilter.class);
    private AgentWorkload agentWorkload;
    public static final String AGENTS = "/rest/servicedesk/([\\d\\w]+)/pages/people/agents/([\\d\\w]+)/search";
    public static final Pattern PATTERN_AGENTS = Pattern.compile("/rest/servicedesk/([\\d\\w]+)/pages/people/agents/([\\d\\w]+)/search");

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.info("IUMRestSDFilter initialized.");
    }

    @Inject
    public IUMRestSDFilter(ApplicationProperties applicationProperties, ProjectManager projectManager, IssueManager issueManager) {
        try {
            this.agentWorkload = (AgentWorkload)ComponentLocator.getComponent(AgentWorkload.class);
            if (this.agentWorkload == null) {
                ComponentManager.getInstance().registerComponent(AgentWorkload.class, AgentWorkloadImpl.class);
                this.agentWorkload = (AgentWorkload)ComponentLocator.getComponent(AgentWorkload.class);
            }
        }
        catch (Throwable e) {
            LOG.error("Throwable " + e.getMessage(), e);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        try {
            if (StringUtils.isEmpty((CharSequence)httpServletRequest.getRequestURI())) {
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return;
            }
            Matcher matcherAgents = PATTERN_AGENTS.matcher(httpServletRequest.getRequestURI());
            if (matcherAgents.matches()) {
                String projectKey = matcherAgents.groupCount() >= 2 ? matcherAgents.group(2) : "";
                String query = httpServletRequest.getParameter("query");
                ContentCachingResponseWrapper responseWrapper = new ContentCachingResponseWrapper((HttpServletResponse)servletResponse);
                filterChain.doFilter(servletRequest, (ServletResponse)responseWrapper);
                this.doAddAgents(projectKey, query, responseWrapper, servletResponse);
                return;
            }
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
        }
    }

    private void doAddAgents(String projectKey, String query, ContentCachingResponseWrapper responseWrapper, ServletResponse servletResponse) throws IOException {
        byte[] originalData = responseWrapper.getContentAsByteArray();
        String newData = new String(originalData);
        AgentResultsResponse disableAgents = this.agentWorkload.searchAgentWorkloadForProject(query, projectKey);
        AgentResultsResponse enabledAgents = this.agentWorkload.fromString(newData);
        this.agentWorkload.mergeAgentResultsResponse(enabledAgents, disableAgents);
        newData = this.agentWorkload.toString(enabledAgents);
        servletResponse.setContentLength(newData.length());
        servletResponse.getOutputStream().write(newData.getBytes());
        servletResponse.getOutputStream().flush();
    }

    public void destroy() {
    }
}

