/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.conditions;

import com.atlassian.jira.plugin.webfragment.conditions.UrlReadingBooleanSystemPropertyCondition;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsUserInGroupsCondition
extends UrlReadingBooleanSystemPropertyCondition {
    private static final Logger LOG = LoggerFactory.getLogger(IsUserInGroupsCondition.class);
    private final JiraAuthenticationContext authenticationContext;

    @Inject
    public IsUserInGroupsCondition(JiraAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    protected String queryKey() {
        return "IUM-UserInGroupsCondition";
    }

    protected boolean isConditionTrue() {
        ApplicationUser applicationUser = this.authenticationContext.getLoggedInUser();
        if (applicationUser == null) {
            return false;
        }
        return IntelligentUserManagerHelper.isUserInGroups(applicationUser, DAO.getIUMGroupsDisabled());
    }
}

