/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;

@Component
public class TestUserServlet
extends HttpServlet {
    private static final long serialVersionUID = 3133173070139987213L;
    private JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final LoginUriProvider loginUriProvider;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private final PluginController pluginController;

    @Inject
    public TestUserServlet(PluginController pluginController, UserManager userManager, LoginUriProvider loginUriProvider, TemplateRenderer renderer, PluginLicenseManager pluginLicenseManager) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.pluginLicenseManager = pluginLicenseManager;
        this.pluginController = pluginController;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain;charset=utf-8");
        response.getWriter().write("Results:" + IntelligentUserManagerHelper.listUsers());
    }

    protected void doGetOld(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=utf-8");
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        long res = IntelligentUserManagerHelper.getlastViewByUser(user);
        response.getWriter().write("User last login/View=" + res);
    }
}

