/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.job;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.job.IJob;
import de.accxia.jira.addon.IUM.job.JobData;
import de.accxia.jira.addon.IUM.job.JobSyncService;
import de.accxia.jira.addon.IUM.job.ProcessResult;
import de.accxia.jira.addon.IUM.repository.JobResultRepository;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import de.accxia.jira.addon.IUM.servlet.HelperTrialProcessing;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class IUMClusterJob2
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMClusterJob2.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMClusterJob2 instance;
    private HelperTrialProcessing helperTrialProcessing;
    private PocketRepository pocketRepository;
    private JobResultRepository jobResultRepository;
    private JobSyncService jobSyncService;

    private IUMClusterJob2() {
    }

    public static IUMClusterJob2 getInstance() {
        if (instance == null) {
            instance = new IUMClusterJob2();
        }
        return instance;
    }

    @Override
    public void injectService(HelperTrialProcessing helperTrialProcessing, PocketRepository pocketRepository, JobResultRepository jobResultRepository) {
        IUMClusterJob2.instance.helperTrialProcessing = helperTrialProcessing;
        IUMClusterJob2.instance.pocketRepository = pocketRepository;
        IUMClusterJob2.instance.jobResultRepository = jobResultRepository;
        IUMClusterJob2.instance.jobSyncService = this.jobSyncService;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) throws RemoveException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMSyncJob Process #[" + SDF.format(new Date()) + "] ");
        }
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        long inactivityInterval = (Long)parameters.get("inactivity_interval");
        if (inactivityInterval <= 0L) {
            inactivityInterval = JobData.DEFAULT_USER_INACTIVITY_INTERVAL;
        }
        String enableGroups = (String)((Object)parameters.get("enable_groups"));
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMClusterJob2 Process with groups={} interval={} at [ {} ] ", new Object[]{enableGroups, inactivityInterval, SDF.format(new Date())});
        }
        ProcessResult processResult = new ProcessResult("CleanJob", (String)((Object)parameters.get("enable_groups")), (String)((Object)parameters.get("disable_groups")));
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMClusterJob2 Process with groups={} interval={} at [ {} ] ", new Object[]{enableGroups, inactivityInterval, SDF.format(new Date())});
        }
        GroupManager groupManager = ComponentAccessor.getGroupManager();
        UserManager userManager = ComponentAccessor.getUserManager();
        UserUtil userUtil = ComponentAccessor.getUserUtil();
        HashMap usersEnabled = new HashMap();
        HashMap usersSession = new HashMap();
        if (!IUMClusterJob2.isEmpty(enableGroups)) {
            Arrays.stream(enableGroups.split(",")).forEach(group -> groupManager.getUserNamesInGroup(group).stream().forEach(username -> this.doAddUserActive((String)username, (String)group, usersEnabled)));
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Verify enabled users count #" + usersEnabled.size());
                if (usersEnabled.size() > 0) {
                    this.LOG.debug("Verify " + usersEnabled.keySet().stream().collect(Collectors.joining(",")));
                }
            }
            processResult.setUserRemoved(0L);
            if (usersEnabled.size() > 0) {
                long now = new Date().getTime();
                for (String ukey : usersEnabled.keySet()) {
                    ApplicationUser user = userManager.getUserByName(ukey);
                    long lastViewByUser = IntelligentUserManagerHelper.getlastViewByUserPld(user);
                    if (lastViewByUser > 0L && now - lastViewByUser < inactivityInterval) {
                        usersEnabled.put(ukey, null);
                        continue;
                    }
                    List userActiveList = (List)usersEnabled.get(ukey);
                    if (userActiveList == null || userActiveList.size() <= 0) continue;
                    for (UserActive userActive : userActiveList) {
                        try {
                            userUtil.removeUserFromGroup(groupManager.getGroup(userActive.group), userManager.getUserByName(ukey));
                            processResult.setUserRemoved(processResult.getUserRemoved() + 1L);
                            if (!this.LOG.isInfoEnabled()) continue;
                            this.LOG.info("IUMClusterJob2 removed user {} from group {} ", new Object[]{ukey, userActive.group});
                        }
                        catch (Exception e) {
                            this.LOG.error("Exception[removeUserFromGroup]: " + e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("IUMClusterJob2 Processed #[" + SDF.format(new Date()) + "] ");
            }
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMClusterJob Processed #[" + SDF.format(new Date()) + "] ");
        }
        processResultList.add(processResult);
        return processResultList;
    }

    private void doAddUserActive(String username, String group, Map<String, List<UserActive>> usersEnabled) {
        if (!usersEnabled.containsKey(username)) {
            usersEnabled.put(username, new ArrayList());
        }
        List<UserActive> userActiveList = usersEnabled.get(username);
        userActiveList.add(new UserActive(group));
    }

    private static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    class UserActive {
        String group;
        Boolean active = false;
        List<String> sessions = new ArrayList<String>();

        public UserActive(String group) {
            this.group = group;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserActive that = (UserActive)o;
            if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
                return false;
            }
            return this.active != null ? this.active.equals(that.active) : that.active == null;
        }

        public int hashCode() {
            int result = this.group != null ? this.group.hashCode() : 0;
            result = 31 * result + (this.active != null ? this.active.hashCode() : 0);
            return result;
        }
    }
}

