/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.job;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.job.JobData;
import de.accxia.jira.addon.IUM.utils.Constants;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobDataUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JobDataUtils.class);

    public static JobData createJobData(String startingFrom, String repeatInterval, String userInactiveInterval, String enableGroups, String disableGroups) {
        JobData jobData = new JobData();
        try {
            jobData.setStartingFrom(Integer.parseInt(startingFrom));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setStartingFrom(1);
        }
        try {
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(Long.parseLong(repeatInterval)));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(60L));
        }
        try {
            jobData.setUserInactivityInterval(TimeUnit.MINUTES.toMillis(Long.parseLong(userInactiveInterval)));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setUserInactivityInterval(JobData.DEFAULT_USER_INACTIVITY_INTERVAL);
        }
        jobData.getParameters().put("repeat_interval", Long.valueOf(jobData.getRepeatInterval()));
        jobData.getParameters().put("starting_from", Integer.valueOf(jobData.getStartingFrom()));
        jobData.getParameters().put("inactivity_interval", Long.valueOf(jobData.getUserInactivityInterval()));
        jobData.getParameters().put("enable_groups", (Serializable)((Object)enableGroups));
        jobData.getParameters().put("disable_groups", (Serializable)((Object)disableGroups));
        return jobData;
    }

    public static JobData createSyncJobData(String startingFrom, String repeatInterval, String enableGroups, String disableGroups, String enableGroups2, String disableGroups2) {
        JobData jobData = new JobData();
        try {
            jobData.setStartingFrom(Integer.parseInt(startingFrom));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setStartingFrom(1);
        }
        try {
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(Long.parseLong(repeatInterval)));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(60L));
        }
        jobData.getParameters().put("sync_repeat_interval", Long.valueOf(jobData.getRepeatInterval()));
        jobData.getParameters().put("sync_starting_from", Integer.valueOf(jobData.getStartingFrom()));
        jobData.getParameters().put("source_software_groups", (Serializable)((Object)enableGroups));
        jobData.getParameters().put("target_software_group", (Serializable)((Object)disableGroups));
        jobData.getParameters().put("source_sdesk_groups", (Serializable)((Object)enableGroups2));
        jobData.getParameters().put("target_sdesk_group", (Serializable)((Object)disableGroups2));
        JiraAuthenticationContext jiraAuthenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
        jobData.getParameters().put("current_user", (Serializable)((Object)(jiraAuthenticationContext.getLoggedInUser() != null ? jiraAuthenticationContext.getLoggedInUser().getUsername() : "IUMPlugin")));
        return jobData;
    }

    public static JobData createDailyJobData() {
        JobData jobData = new JobData();
        int startingFrom = 2;
        long repeatInterval = 1440L;
        if (Constants.TESTING.booleanValue()) {
            Date date = new Date();
            startingFrom = date.getHours();
            repeatInterval = 10L;
        }
        try {
            jobData.setStartingFrom(startingFrom);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setStartingFrom(1);
        }
        try {
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(repeatInterval));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(60L));
        }
        JiraAuthenticationContext jiraAuthenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
        jobData.getParameters().put("current_user", (Serializable)((Object)(jiraAuthenticationContext.getLoggedInUser() != null ? jiraAuthenticationContext.getLoggedInUser().getUsername() : "IUMPlugin")));
        return jobData;
    }

    public static JobData createDailyEventJobData() {
        JobData jobData = new JobData();
        int startingFrom = 2;
        long repeatInterval = 1440L;
        if (Constants.TESTING.booleanValue()) {
            Date date = new Date();
            startingFrom = date.getHours() + 1;
            repeatInterval = 60L;
        }
        try {
            jobData.setStartingFrom(startingFrom);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setStartingFrom(1);
        }
        try {
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(repeatInterval));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(60L));
        }
        JiraAuthenticationContext jiraAuthenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
        jobData.getParameters().put("current_user", (Serializable)((Object)(jiraAuthenticationContext.getLoggedInUser() != null ? jiraAuthenticationContext.getLoggedInUser().getName() : "IUMPlugin")));
        jobData.getParameters().put("daily_event_from", (Serializable)((Object)"-1"));
        return jobData;
    }

    public static JobData createLicenseJobData() {
        JobData jobData = new JobData();
        Date date = new Date();
        int startingFrom = date.getHours();
        long repeatInterval = 60L;
        if (Constants.TESTING.booleanValue()) {
            date = new Date();
            startingFrom = date.getHours();
            repeatInterval = 5L;
        }
        try {
            jobData.setStartingFrom(startingFrom);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setStartingFrom(1);
        }
        try {
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(repeatInterval));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(60L));
        }
        JiraAuthenticationContext jiraAuthenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
        jobData.getParameters().put("current_user", (Serializable)((Object)(jiraAuthenticationContext.getLoggedInUser() != null ? jiraAuthenticationContext.getLoggedInUser().getName() : "IUMPlugin")));
        jobData.getParameters().put("start_immediate", Long.valueOf(jobData.getUserInactivityInterval()));
        return jobData;
    }

    public static JobData createIUMJobData() {
        return JobDataUtils.createJobData(DAO.getStartingFrom(), DAO.getRepeatInterval(), DAO.getInactivityDuration(), DAO.getIUMGroups(), DAO.getIUMGroupsDisabled());
    }

    public static JobData createIUMSyncJobData() {
        return JobDataUtils.createSyncJobData(DAO.getSyncStartingFrom(), DAO.getSyncRepeatInterval(), DAO.getSyncSoftwareSrcGoups(), DAO.getSyncSoftwareTargetGoups(), DAO.getSyncSDeskSrcGoups(), DAO.getSyncSDeskTargetGoups());
    }

    public static JobData createIUMDailyJobData() {
        return JobDataUtils.createDailyJobData();
    }

    public static JobData createIUMDailyEventJobData() {
        return JobDataUtils.createDailyEventJobData();
    }

    public static JobData createIUMLicenseJobData() {
        return JobDataUtils.createLicenseJobData();
    }

    public static JobData createFakeIUMJobData() {
        JobData jobData = new JobData();
        Date date = new Date();
        jobData.setStartingFrom(date.getHours());
        jobData.setRepeatInterval(10000L);
        jobData.setUserInactivityInterval(30000L);
        jobData.getParameters().put("repeat_interval", Long.valueOf(jobData.getRepeatInterval()));
        jobData.getParameters().put("starting_from", Integer.valueOf(jobData.getStartingFrom()));
        jobData.getParameters().put("inactivity_interval", Long.valueOf(jobData.getUserInactivityInterval()));
        jobData.getParameters().put("enable_groups", (Serializable)((Object)DAO.getIUMGroups()));
        jobData.getParameters().put("disable_groups", (Serializable)((Object)DAO.getIUMGroupsDisabled()));
        return jobData;
    }

    public static JobData createIUMAccessJobData() {
        return JobDataUtils.createAccessJobData();
    }

    public static JobData createAccessJobData() {
        JobData jobData = new JobData();
        Date date = new Date();
        int startingFrom = date.getHours();
        long repeatInterval = 5L;
        try {
            jobData.setStartingFrom(startingFrom);
            jobData.setRepeatInterval(TimeUnit.SECONDS.toMillis(repeatInterval));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setStartingFrom(1);
        }
        JiraAuthenticationContext jiraAuthenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
        jobData.getParameters().put("current_user", (Serializable)((Object)(jiraAuthenticationContext.getLoggedInUser() != null ? jiraAuthenticationContext.getLoggedInUser().getName() : "IUMPlugin")));
        return jobData;
    }

    public static JobData createFakeIUMAccessJobData() {
        JobData jobData = new JobData();
        Date date = new Date();
        int startingFrom = date.getHours();
        long repeatInterval = 10L;
        try {
            jobData.setStartingFrom(startingFrom);
            jobData.setRepeatInterval(TimeUnit.SECONDS.toMillis(repeatInterval));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setStartingFrom(1);
        }
        JiraAuthenticationContext jiraAuthenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
        jobData.getParameters().put("current_user", (Serializable)((Object)(jiraAuthenticationContext.getLoggedInUser() != null ? jiraAuthenticationContext.getLoggedInUser().getName() : "IUMPlugin")));
        return jobData;
    }

    public static JobData createFakeIUMSyncJobData() {
        JobData jobData = new JobData();
        Date date = new Date();
        jobData.setStartingFrom(date.getHours());
        jobData.setRepeatInterval(10000L);
        jobData.setUserInactivityInterval(30000L);
        jobData.getParameters().put("sync_repeat_interval", Long.valueOf(jobData.getRepeatInterval()));
        jobData.getParameters().put("sync_starting_from", Integer.valueOf(jobData.getStartingFrom()));
        jobData.getParameters().put("source_software_groups", (Serializable)((Object)"SrcGroup"));
        jobData.getParameters().put("target_software_group", (Serializable)((Object)"DestGroup"));
        jobData.getParameters().put("source_sdesk_groups", (Serializable)((Object)"SrcGroup2"));
        jobData.getParameters().put("target_sdesk_group", (Serializable)((Object)"DestGroup2"));
        JiraAuthenticationContext jiraAuthenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
        jobData.getParameters().put("current_user", (Serializable)((Object)(jiraAuthenticationContext.getLoggedInUser() != null ? jiraAuthenticationContext.getLoggedInUser().getUsername() : "IUMPlugin")));
        return jobData;
    }

    public static JobData createFakeIUMDailyJobData() {
        JobData jobData = new JobData();
        Date date = new Date();
        int startingFrom = date.getHours();
        long repeatInterval = 1L;
        try {
            jobData.setStartingFrom(startingFrom);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setStartingFrom(1);
        }
        try {
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(repeatInterval));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(60L));
        }
        JiraAuthenticationContext jiraAuthenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
        jobData.getParameters().put("current_user", (Serializable)((Object)(jiraAuthenticationContext.getLoggedInUser() != null ? jiraAuthenticationContext.getLoggedInUser().getUsername() : "IUMPlugin")));
        return jobData;
    }

    public static JobData createFakeIUMDailyEventJobData() {
        JobData jobData = new JobData();
        Date date = new Date();
        int startingFrom = date.getHours();
        long repeatInterval = 1L;
        try {
            jobData.setStartingFrom(startingFrom);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setStartingFrom(1);
        }
        try {
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(repeatInterval));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(60L));
        }
        JiraAuthenticationContext jiraAuthenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
        jobData.getParameters().put("current_user", (Serializable)((Object)(jiraAuthenticationContext.getLoggedInUser() != null ? jiraAuthenticationContext.getLoggedInUser().getUsername() : "IUMPlugin")));
        return jobData;
    }

    public static JobData createFakeIUMLicenseJobData() {
        JobData jobData = new JobData();
        Date date = new Date();
        int startingFrom = date.getHours();
        long repeatInterval = 1L;
        try {
            jobData.setStartingFrom(startingFrom);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setStartingFrom(1);
        }
        try {
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(repeatInterval));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(60L));
        }
        JiraAuthenticationContext jiraAuthenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
        jobData.getParameters().put("current_user", (Serializable)((Object)(jiraAuthenticationContext.getLoggedInUser() != null ? jiraAuthenticationContext.getLoggedInUser().getUsername() : "IUMPlugin")));
        return jobData;
    }

    public static JobData createMembershipJobData() {
        JobData jobData = new JobData();
        Date date = new Date();
        int startingFrom = date.getHours();
        long repeatInterval = 5L;
        try {
            jobData.setStartingFrom(startingFrom);
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(repeatInterval));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setStartingFrom(1);
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(repeatInterval));
        }
        JiraAuthenticationContext jiraAuthenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
        jobData.getParameters().put("current_user", (Serializable)((Object)(jiraAuthenticationContext.getLoggedInUser() != null ? jiraAuthenticationContext.getLoggedInUser().getUsername() : "IUMPlugin")));
        return jobData;
    }

    public static JobData createIUMMembershipJobData() {
        return JobDataUtils.createMembershipJobData();
    }

    public static JobData createFakeIUMMembershipJobData() {
        JobData jobData = new JobData();
        Date date = new Date();
        int startingFrom = date.getHours();
        long repeatInterval = 5L;
        try {
            jobData.setStartingFrom(startingFrom);
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(repeatInterval));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            jobData.setStartingFrom(1);
            jobData.setRepeatInterval(TimeUnit.MINUTES.toMillis(repeatInterval));
        }
        JiraAuthenticationContext jiraAuthenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
        jobData.getParameters().put("current_user", (Serializable)((Object)(jiraAuthenticationContext.getLoggedInUser() != null ? jiraAuthenticationContext.getLoggedInUser().getUsername() : "IUMPlugin")));
        return jobData;
    }

    public static long hours2millis(long hours) {
        try {
            return TimeUnit.HOURS.toMillis(hours);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public static long hours2millis(String hours) {
        try {
            return TimeUnit.HOURS.toMillis(Long.parseLong(hours));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public static long toHours(String mills) {
        if (mills != null) {
            try {
                return TimeUnit.MILLISECONDS.toHours(Long.parseLong(mills));
            }
            catch (Exception e) {
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            }
        }
        return 0L;
    }

    public static long minutes2millis(long minutes) {
        try {
            return TimeUnit.MINUTES.toMillis(minutes);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public static long minutes2millis(String minutes) {
        try {
            return TimeUnit.MINUTES.toMillis(Long.parseLong(minutes));
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public static long toMinutes(String mills) {
        if (mills != null) {
            try {
                return TimeUnit.MILLISECONDS.toMinutes(Long.parseLong(mills));
            }
            catch (Exception e) {
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            }
        }
        return 0L;
    }

    public static long toLong(String numbr) {
        if (numbr != null) {
            try {
                return Long.parseLong(numbr);
            }
            catch (Exception e) {
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            }
        }
        return 0L;
    }
}

