/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet;

import com.atlassian.annotations.security.UnlicensedSiteAccess;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.servlet.ImageServletUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@UnlicensedSiteAccess
public class ImageServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ImageServlet.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final long MAX_FILE_SIZE = 0x300000L;
    @ComponentImport
    private final JiraHome jiraHome;
    private final ImageServletUtil imageServletUtil;

    public ImageServlet(JiraHome jiraHome, ImageServletUtil imageServletUtil) {
        this.jiraHome = jiraHome;
        this.imageServletUtil = imageServletUtil;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOG.debug("ImageServlet=" + request.getRequestURI());
        this.imageServletUtil.processGet(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println(request.toString());
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (isMultipart) {
            try {
                String fileName = this.doUploadPicture(request, response);
                if (fileName != null) {
                    response.setContentType("text/plain");
                    PrintWriter out = response.getWriter();
                    out.write(fileName);
                    out.close();
                    return;
                }
            }
            catch (Exception e) {
                response.setContentType("text/html");
                response.sendError(404, e.getMessage());
            }
        }
        response.setContentType("text/html");
        response.sendError(404, "Image file not uploaded");
    }

    private String doUploadPicture(HttpServletRequest request, HttpServletResponse response) {
        File uploadPath = this.imageServletUtil.getUploadsDirectory();
        String fileName = null;
        try {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            File repository = this.getTemporaryAttachmentDirectory();
            factory.setRepository(repository);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setFileSizeMax(0x300000L);
            List items = upload.parseRequest(request);
            for (FileItem item : items) {
                if (item.isFormField()) continue;
                if (item.getSize() > 0x300000L) {
                    throw new RuntimeException("File size exceeds the limit");
                }
                fileName = new File(item.getName()).getName();
                String filePath = uploadPath + File.separator + fileName;
                File storeFile = new File(filePath);
                item.write(storeFile);
                request.setAttribute("message", (Object)"File upload success!");
                DAO.updateUrlLogo(fileName);
            }
        }
        catch (Exception ex) {
            request.setAttribute("message", (Object)("File upload failed due to " + ex));
        }
        return fileName;
    }

    public File getTemporaryAttachmentDirectory() {
        File homeDirectory = this.jiraHome.getLocalHome();
        File tempDirectory = new File(homeDirectory, "tmp_ium");
        if (!tempDirectory.exists()) {
            tempDirectory.mkdirs();
        }
        return tempDirectory;
    }
}

