/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.annotations.security.UnlicensedSiteAccess;
import de.accxia.jira.addon.IUM.servlet.ImageServletUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@UnlicensedSiteAccess
public class IUMImageServletFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(IUMImageServletFilter.class);
    public static final String URI_IMAGE = "/plugins/servlet/ium-image";
    private final ImageServletUtil imageServletUtil;

    public IUMImageServletFilter(ImageServletUtil imageServletUtil) {
        this.imageServletUtil = imageServletUtil;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        log.debug("IUMImageServletFilter=" + httpServletRequest.getRequestURI());
        if (httpServletRequest.getRequestURI() != null && "GET".equalsIgnoreCase(httpServletRequest.getMethod()) && httpServletRequest.getRequestURI().contains(URI_IMAGE)) {
            log.info(" URI_IMAGE " + httpServletRequest.getRequestURI());
            this.imageServletUtil.processGet(httpServletRequest, (HttpServletResponse)response);
            return;
        }
        log.debug(" URL " + httpServletRequest.getRequestURI());
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

