/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.side;

import com.atlassian.annotations.security.UnlicensedSiteAccess;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.CurrentUser;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.impl.Quota;
import de.accxia.jira.addon.IUM.model.NavUserDTO;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import de.accxia.jira.addon.IUM.side.LicenseData;
import de.accxia.jira.addon.IUM.side.VerifyMessage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/")
@Consumes(value={"text/html"})
@Produces(value={"text/plain"})
@Component
@UnlicensedSiteAccess
public class IUMRest {
    private static final Logger LOG = LoggerFactory.getLogger(IUMRest.class);
    @ComponentImport
    private final com.atlassian.sal.api.user.UserManager userManager;
    private UserManager userManagerJira;
    @ComponentImport
    private final ApplicationRoleManager applicationRoleManager;
    @ComponentImport
    private final ApplicationAuthorizationService applicationAuthorizationService;
    @ComponentImport
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final GroupManager groupManager = ComponentAccessor.getGroupManager();

    @Inject
    public IUMRest(com.atlassian.sal.api.user.UserManager userManager, ApplicationRoleManager applicationRoleManager, ApplicationAuthorizationService applicationAuthorizationService, JiraAuthenticationContext jiraAuthenticationContext) {
        this.userManager = userManager;
        this.userManagerJira = ComponentAccessor.getUserManager();
        this.applicationRoleManager = applicationRoleManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.applicationAuthorizationService = applicationAuthorizationService;
    }

    @Path(value="/sidelicense")
    @GET
    @Produces(value={"application/json"})
    public Response getSideLicenseDetails(@Context HttpServletRequest request) {
        UserKey userkey = this.userManager.getRemoteUserKey();
        LicenseData ourSideLicense = ConditionEvaluatorImpl.getSideLicense();
        VerifyMessage.License_Result licenseStatus = VerifyMessage.getLicenseStatus(ourSideLicense);
        LicenseDetails licenseDetails = null;
        licenseDetails = userkey == null || !this.userManager.isAdmin(userkey) ? new LicenseDetails(licenseStatus, null, 0, "", "", "") : (ourSideLicense != null ? new LicenseDetails(licenseStatus, ourSideLicense.getDueDate().toString(), ourSideLicense.getUsers(), ourSideLicense.getSSN(), ourSideLicense.getCustomer(), DAO.getSideLicense()) : new LicenseDetails(licenseStatus, null, 0, "", "", ""));
        return Response.ok((Object)licenseDetails).build();
    }

    @Path(value="/retry")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response attemptToEnableUser(@Context HttpServletRequest request) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        CurrentUser currentUser = IntelligentUserManagerHelper.enableUserFromGroup(user, request);
        String warningMessage = currentUser != null ? currentUser.warningMessage : "";
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("warningMessage", warningMessage);
        if (user != null && (warningMessage == null || warningMessage.length() < 1)) {
            boolean canUseSoftwareAccess = this.applicationAuthorizationService.canUseApplication(user, ApplicationKeys.SOFTWARE);
            boolean canUseServiceDeskAccess = this.applicationAuthorizationService.canUseApplication(user, ApplicationKeys.SERVICE_DESK);
            boolean canUseCoreAccess = this.applicationAuthorizationService.canUseApplication(user, ApplicationKeys.CORE);
            retVal.put(ApplicationKeys.SOFTWARE.value(), canUseSoftwareAccess);
            retVal.put(ApplicationKeys.SERVICE_DESK.value(), canUseServiceDeskAccess);
            retVal.put(ApplicationKeys.CORE.value(), canUseCoreAccess);
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/apps")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response computeApplicationRole(@Context HttpServletRequest request) {
        ApplicationUser user = null;
        String username = request.getParameter("username");
        if (username != null) {
            user = this.userManagerJira.getUserByName(username);
        }
        HashMap<String, String> retVal = new HashMap<String, String>();
        if (user != null) {
            this.addApplicationAccess(user, retVal);
            retVal.put("username", username);
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/view")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getUserAction4Group(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        ArrayList<String> retVal = new ArrayList<String>();
        PocketRepository pocketRepository = (PocketRepository)ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);
        if (pocketRepository != null) {
            List<NavUserDTO> navUsers = pocketRepository.getOldestUsers(group, 0, 10);
            for (NavUserDTO navUser : navUsers) {
                retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/check")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response checkCanGetFreeSlots(@QueryParam(value="username") String username) {
        Quota retVal = IntelligentUserManagerHelper.checkCanGetFreeSlots(username);
        return Response.ok((Object)retVal).build();
    }

    private void addApplicationAccess(ApplicationUser user, Map retVal) {
        if (user != null) {
            boolean canUseSoftwareAccess = this.applicationAuthorizationService.canUseApplication(user, ApplicationKeys.SOFTWARE);
            boolean canUseServiceDeskAccess = this.applicationAuthorizationService.canUseApplication(user, ApplicationKeys.SERVICE_DESK);
            boolean canUseCoreAccess = this.applicationAuthorizationService.canUseApplication(user, ApplicationKeys.CORE);
            retVal.put(ApplicationKeys.SOFTWARE.value(), canUseSoftwareAccess);
            retVal.put(ApplicationKeys.SERVICE_DESK.value(), canUseServiceDeskAccess);
            retVal.put(ApplicationKeys.CORE.value(), canUseCoreAccess);
            String IUMGroup2 = DAO.getIUMGroupsDisabled();
            if (IUMGroup2 != null && IUMGroup2.length() > 0) {
                String[] IUMGroups = IUMGroup2.split(",");
                retVal.put("could-has-software", canUseSoftwareAccess || IUMGroups.length > 0 && this.userManager.isUserInGroup(user.getUsername(), IUMGroups[0]));
                retVal.put("could-has-service", canUseServiceDeskAccess || IUMGroups.length > 1 && this.userManager.isUserInGroup(user.getUsername(), IUMGroups[1]));
                retVal.put("could-has-core", canUseCoreAccess || IUMGroups.length > 2 && this.userManager.isUserInGroup(user.getUsername(), IUMGroups[2]));
            }
        }
    }

    public class LicenseDetails {
        public VerifyMessage.License_Result licenseStatus;
        public String expires;
        public int users;
        public String SSN;
        public String customer;
        public String licenseKey;

        public LicenseDetails(VerifyMessage.License_Result licenseStatus, String expires, int users, String SSN, String customer, String licenseKey) {
            this.licenseStatus = licenseStatus;
            this.expires = expires;
            this.users = users;
            this.SSN = SSN;
            this.customer = customer;
            this.licenseKey = licenseKey;
        }
    }
}

