/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.conditions;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluator;
import de.accxia.jira.addon.IUM.conditions.ConditionType;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.listener.IUMListener;
import de.accxia.jira.addon.IUM.side.LicenseData;
import de.accxia.jira.addon.IUM.side.VerifyMessage;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@ExportAsService(value={ConditionEvaluator.class})
@Component(value="IUMConditionEvaluator")
public class ConditionEvaluatorImpl
implements ConditionEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ConditionEvaluatorImpl.class);
    @ComponentImport
    private static PluginLicenseManager licenseManager;
    private static LicenseData sideLicense;

    public static LicenseData getSideLicense() {
        return sideLicense;
    }

    public static void setSideLicense() {
        if (IUMListener.PLUGIN_ENABLED.booleanValue()) {
            sideLicense = VerifyMessage.checkSideLicenses();
        }
    }

    public static void setSideLicense(String sideLicense) {
        ConditionEvaluatorImpl.sideLicense = VerifyMessage.checkSideLicenses(sideLicense);
    }

    public static void deleteSideLicense() {
        sideLicense = null;
    }

    @Inject
    public ConditionEvaluatorImpl(PluginLicenseManager licenseManager) {
        ConditionEvaluatorImpl.licenseManager = licenseManager;
        ConditionEvaluatorImpl.setSideLicense();
    }

    @Override
    public boolean evaluate(ConditionType type) {
        switch (type) {
            case LICENSED: {
                return ConditionEvaluatorImpl.isLicenseValid();
            }
            case SIDELICENSED: {
                return VerifyMessage.isSideLicenseValid(sideLicense);
            }
            case WRONGSIDELICENSE: {
                if ("".equals(DAO.getSideLicense())) {
                    return false;
                }
                boolean ignoreResult = ConditionEvaluatorImpl.isLicenseValid();
                return true;
            }
        }
        return false;
    }

    public static boolean isAtlassianLicenseValid() {
        return true;
    }

    public static boolean isLicenseValid() {
        boolean isLicensed;
        boolean isDebugging = false;
        boolean bl = isLicensed = isDebugging || ConditionEvaluatorImpl.isAtlassianLicenseValid();
        if (isLicensed) {
            return true;
        }
        return VerifyMessage.isSideLicenseValid(sideLicense);
    }

    public static boolean isFreeVersion() {
        return !VerifyMessage.isSideLicenseValid(sideLicense);
    }

    public static boolean isEvaluation() {
        boolean isEval = false;
        for (PluginLicense pluginLicense : licenseManager.getLicense()) {
            if (!pluginLicense.isEvaluation()) continue;
            return true;
        }
        return isEval;
    }

    public static boolean isToOldEval(String timestampStr) {
        if (timestampStr != null && !"".equals(timestampStr)) {
            Timestamp timestamp = new Timestamp(Long.parseLong(timestampStr));
            Timestamp now = new Timestamp(System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(timestamp.getTime());
            cal.add(5, 45);
            Timestamp newtimestamp = new Timestamp(cal.getTime().getTime());
            if (newtimestamp.before(now)) {
                return true;
            }
        }
        return false;
    }

    static {
        sideLicense = null;
    }
}

