/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.job;

import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.job.IJob;
import de.accxia.jira.addon.IUM.job.ProcessResult;
import de.accxia.jira.addon.IUM.repository.JobResultRepository;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import de.accxia.jira.addon.IUM.servlet.HelperTrialProcessing;
import de.accxia.jira.addon.IUM.utils.ParseUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMLicenseJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMLicenseJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMLicenseJob instance;
    private JobResultRepository jobResultRepository;
    private PocketRepository pocketRepository;
    private HelperTrialProcessing helperTrialProcessing;
    private JiraLicenseManager jiraLicenseManager;
    private ApplicationRoleManager applicationRoleManager;
    private static UserUtil userUtil;

    public static IUMLicenseJob getInstance() {
        if (instance == null) {
            instance = new IUMLicenseJob();
        }
        return instance;
    }

    @Override
    public void injectService(HelperTrialProcessing helperTrialProcessing, PocketRepository pocketRepository, JobResultRepository jobResultRepository) {
        IUMLicenseJob.instance.helperTrialProcessing = helperTrialProcessing;
        IUMLicenseJob.instance.pocketRepository = pocketRepository;
        IUMLicenseJob.instance.jobResultRepository = jobResultRepository;
    }

    @Override
    public void injectService(JiraLicenseManager jiraLicenseManager) {
        this.jiraLicenseManager = jiraLicenseManager;
    }

    @Override
    public void injectService(ApplicationRoleManager applicationRoleManager) {
        IUMLicenseJob.instance.applicationRoleManager = applicationRoleManager;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMLicenseJob Process #[" + SDF.format(new Date()) + "] ");
        }
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        boolean isFreeVersion = ConditionEvaluatorImpl.isFreeVersion();
        int reservedLicense = ParseUtil.safeParseInt(DAO.getReservedLicense(), isFreeVersion ? 1 : 3);
        String group = DAO.getIUMGroups();
        if (StringUtils.isEmpty((CharSequence)group)) {
            return processResultList;
        }
        String[] enableGroupNames = group.split(",");
        CharSequence[] iumQueueSize = DAO.getQueueSize().split(",");
        if (isFreeVersion) {
            int countQueue;
            int reducedSharedLicense;
            int licenseFromQueues;
            if (iumQueueSize.length > 0 && (licenseFromQueues = ParseUtil.safeParseInt(iumQueueSize[0], 0)) > 5) {
                reducedSharedLicense = licenseFromQueues - 5;
                processResultList.add(new ProcessResult("LicenseJob", String.format("The shared license were reduced by %d", reducedSharedLicense), reducedSharedLicense));
                countQueue = ParseUtil.safeParseInt((String)iumQueueSize[0], 0);
                if (countQueue > reducedSharedLicense) {
                    countQueue = reducedSharedLicense;
                }
                iumQueueSize[0] = String.valueOf(countQueue);
            }
            if (iumQueueSize.length > 1 && (licenseFromQueues = ParseUtil.safeParseInt(iumQueueSize[1], 0)) > 5) {
                reducedSharedLicense = licenseFromQueues - 5;
                processResultList.add(new ProcessResult("LicenseJob", String.format("The shared license were reduced by %d", reducedSharedLicense), reducedSharedLicense));
                countQueue = ParseUtil.safeParseInt((String)iumQueueSize[1], 0);
                if (countQueue > reducedSharedLicense) {
                    countQueue = reducedSharedLicense;
                }
                iumQueueSize[1] = String.valueOf(countQueue);
            }
            DAO.updateQueueSize(String.join((CharSequence)",", iumQueueSize));
        } else {
            int licenseFromQueues;
            int licenseConsumingSoftwareUsers = this.getUsersWithJiraAccess(enableGroupNames.length > 0 ? enableGroupNames[0] : "").size();
            int licenseConsumingSDeskUsers = this.getUsersWithSDeskAccess(enableGroupNames.length > 1 ? enableGroupNames[1] : "").size();
            int softwareSeats = this.helperTrialProcessing.getSeats(ApplicationKeys.SOFTWARE);
            int sDeskSeats = this.helperTrialProcessing.getSeats(ApplicationKeys.SERVICE_DESK);
            if (iumQueueSize.length > 0) {
                licenseFromQueues = ParseUtil.safeParseInt((String)iumQueueSize[0], 0);
                if (softwareSeats > 0 && licenseFromQueues + licenseConsumingSoftwareUsers + reservedLicense > softwareSeats) {
                    processResultList.add(new ProcessResult("LicenseJob", String.format("Number of users %d vs %d", licenseFromQueues + licenseConsumingSoftwareUsers + reservedLicense, softwareSeats), licenseFromQueues + licenseConsumingSoftwareUsers + reservedLicense - softwareSeats));
                    iumQueueSize[0] = String.valueOf(softwareSeats - licenseConsumingSoftwareUsers - reservedLicense);
                }
            }
            if (iumQueueSize.length > 1) {
                licenseFromQueues = ParseUtil.safeParseInt((String)iumQueueSize[1], 0);
                if (sDeskSeats > 0 && licenseFromQueues + licenseConsumingSDeskUsers + reservedLicense > sDeskSeats) {
                    processResultList.add(new ProcessResult("LicenseJob", String.format("Number of users %d vs %d", licenseFromQueues + licenseConsumingSDeskUsers + reservedLicense, sDeskSeats), licenseFromQueues + licenseConsumingSDeskUsers + reservedLicense - sDeskSeats));
                    iumQueueSize[1] = String.valueOf(sDeskSeats - licenseConsumingSDeskUsers - reservedLicense);
                }
            }
            DAO.updateQueueSize(String.join((CharSequence)",", iumQueueSize));
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMLicenseJob Processed #[" + SDF.format(new Date()) + "] ");
        }
        return processResultList;
    }

    private int getLicenseFromQueues() {
        int licenseFromQueues = 0;
        String[] iumQueueSize = DAO.getQueueSize().split(",");
        for (int i = 0; i < iumQueueSize.length; ++i) {
            licenseFromQueues += ParseUtil.safeParseInt(iumQueueSize[i], 0);
        }
        return licenseFromQueues;
    }

    private boolean decrementLicenseFromQueues(int cnt) {
        boolean licenseFromQueues = false;
        CharSequence[] iumQueueSize = DAO.getQueueSize().split(",");
        for (int i = 0; i < iumQueueSize.length; ++i) {
            int countQueue = ParseUtil.safeParseInt(iumQueueSize[i], 0);
            if (countQueue > cnt) {
                iumQueueSize[i] = String.valueOf(countQueue - cnt);
                cnt = 0;
                break;
            }
            iumQueueSize[i] = String.valueOf(1);
            cnt = cnt - countQueue + 1;
        }
        DAO.updateQueueSize(String.join((CharSequence)",", iumQueueSize));
        return cnt == 0;
    }

    public Set<ApplicationUser> getUsersWithJiraAccess(String iumEnableGroup) {
        return this.helperTrialProcessing.getUsersWithGenericAccessExceptGroup(ApplicationKeys.SOFTWARE, iumEnableGroup);
    }

    public Set<ApplicationUser> getUsersWithSDeskAccess(String iumEnableSDGroup) {
        return this.helperTrialProcessing.getUsersWithGenericAccessExceptGroup(ApplicationKeys.SERVICE_DESK, iumEnableSDGroup);
    }

    static {
        userUtil = ComponentAccessor.getUserUtil();
    }
}

