/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ServletHelper.class);
    public static final String xssPattern = "<script>|<\\/script>|javascript:|<|>|&|\"|'";
    public static final Pattern pattern = Pattern.compile("<script>|<\\/script>|javascript:|<|>|&|\"|'", 2);

    public static boolean doCheckOriginAndReferrer(String baseURL, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws MalformedURLException {
        String referer = httpRequest.getHeader("referer");
        String origin = httpRequest.getHeader("origin");
        if (origin != null && !"null".equalsIgnoreCase(origin) && origin.startsWith(baseURL)) {
            URL urlOrigin = new URL(origin);
            URL urlBaseURL = new URL(baseURL);
            if (!urlBaseURL.getHost().equalsIgnoreCase(urlOrigin.getHost())) {
                LOG.info("origin.startsWith(baseURL)  {} {}", (Object)origin, (Object)baseURL);
                return false;
            }
        }
        if (referer != null && !"null".equalsIgnoreCase(referer) && !referer.startsWith(baseURL)) {
            LOG.info("referer.startsWith(baseURL)  {} {}", (Object)referer, (Object)baseURL);
            return false;
        }
        return true;
    }

    public static boolean doValidateInput(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        Enumeration parameterNames = httpRequest.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            Matcher matcher = pattern.matcher(httpRequest.getParameter(parameterName));
            if (!matcher.find()) continue;
            LOG.warn(parameterName + "=" + httpRequest.getParameter(parameterName));
            return false;
        }
        return true;
    }
}

