/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.filter;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class XSSHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private Map<String, String[]> sanitized;

    public XSSHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        this.sanitized = this.sanitizeParamMap(request.getParameterMap());
    }

    public String getParameter(String name) {
        String[] vals = this.getParameterValues(name);
        if (vals != null && vals.length > 0) {
            return vals[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return this.sanitized;
    }

    public String[] getParameterValues(String name) {
        return this.sanitized.get(name);
    }

    private Map<String, String[]> sanitizeParamMap(Map<String, String[]> raw) {
        HashMap<String, String[]> res = new HashMap<String, String[]>();
        if (raw != null) {
            for (String key : raw.keySet()) {
                String[] rawVals = raw.get(key);
                if (rawVals != null && rawVals.length > 0) {
                    String[] snzVals = new String[rawVals.length];
                    for (int i = 0; i < rawVals.length; ++i) {
                        snzVals[i] = this.sanitize(rawVals[i]);
                    }
                    res.put(key, snzVals);
                    continue;
                }
                res.put(key, rawVals);
            }
        }
        return res;
    }

    private String sanitize(String s) {
        if (s == null || "".equals(s.trim())) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 16);
        block9: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '>': {
                    sb.append('\uff1e');
                    continue block9;
                }
                case '<': {
                    sb.append('\uff1c');
                    continue block9;
                }
                case '\'': {
                    sb.append('\u2018');
                    continue block9;
                }
                case '\"': {
                    sb.append('\u201c');
                    continue block9;
                }
                case '&': {
                    sb.append('\uff06');
                    continue block9;
                }
                case '\\': {
                    sb.append('\uff3c');
                    continue block9;
                }
                case '#': {
                    sb.append('\uff03');
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

