/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.impl.OldestUser;
import de.accxia.jira.addon.IUM.model.NavUserDTO;
import de.accxia.jira.addon.IUM.model.TrialProcessing;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import de.accxia.jira.addon.IUM.servlet.HelperTrialProcessing;
import de.accxia.jira.addon.IUM.servlet.Pagination;
import de.accxia.jira.addon.IUM.servlet.ServletHelper;
import de.accxia.jira.addon.IUM.servlet.filter.XSSHttpServletRequestWrapper;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IntelligentUserManagerManagementServlet
extends HttpServlet {
    private static final long serialVersionUID = -5623574103725530973L;
    private static final Logger LOG = LoggerFactory.getLogger(IntelligentUserManagerManagementServlet.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final LoginUriProvider loginUriProvider;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final WebSudoManager webSudoManager;
    @ComponentImport
    private final ApplicationProperties applicationProperties;
    private final PocketRepository pocketRepository;
    private final HelperTrialProcessing helperTrialProcessing;
    private static final GroupManager groupManager = ComponentAccessor.getGroupManager();
    private static final I18nHelper i18Helper = ComponentAccessor.getI18nHelperFactory().getInstance(Locale.getDefault());
    private final BuildUtilsInfo buildUtilsInfo;
    private String fromgroup = null;
    private String togroup = null;
    private String filtergroup = null;
    private String noof = null;

    @Inject
    public IntelligentUserManagerManagementServlet(PocketRepository pocketRepository, UserManager userManager, LoginUriProvider loginUriProvider, TemplateRenderer renderer, ApplicationProperties applicationProperties, WebSudoManager webSudoManager, HelperTrialProcessing helperTrialProcessing) {
        this.pocketRepository = pocketRepository;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.applicationProperties = applicationProperties;
        this.helperTrialProcessing = helperTrialProcessing;
        this.buildUtilsInfo = (BuildUtilsInfo)ComponentAccessor.getComponent(BuildUtilsInfo.class);
        this.webSudoManager = webSudoManager;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            XSSHttpServletRequestWrapper xssRrequest = new XSSHttpServletRequestWrapper(request);
            if (!ServletHelper.doCheckOriginAndReferrer(this.applicationProperties.getBaseUrl(), request, response)) {
                this.forceToLogin(request, response);
                return;
            }
            UserKey userKey = this.userManager.getRemoteUserKey();
            if (userKey == null || !this.userManager.isAdmin(userKey)) {
                this.redirectToLogin((HttpServletRequest)xssRrequest, response);
                return;
            }
            if (!ServletHelper.doValidateInput(request, response)) {
                this.redirectToLogin(request, response);
                return;
            }
            this.webSudoManager.willExecuteWebSudoRequest((HttpServletRequest)xssRrequest);
            String action = xssRrequest.getParameter("action");
            if (!ConditionEvaluatorImpl.isLicenseValid()) {
                this.renderLicenseErrorVM(response, false);
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            if ("list".equals(action)) {
                String fromGroup = "";
                if (xssRrequest.getParameter("fromgroup") != null) {
                    fromGroup = xssRrequest.getParameter("fromgroup");
                }
                String toGroup = "";
                if (xssRrequest.getParameter("togroup") != null) {
                    toGroup = xssRrequest.getParameter("togroup");
                }
                String filterGroup = "";
                if (xssRrequest.getParameter("filtergroup") != null) {
                    filterGroup = xssRrequest.getParameter("filtergroup");
                }
                int noof = 10;
                try {
                    if (xssRrequest.getParameter("noof") != null) {
                        noof = Integer.parseInt(xssRrequest.getParameter("noof"));
                    }
                }
                catch (Exception e) {
                    noof = 10;
                }
                this.fromgroup = this.setValue("fromgroup", fromGroup);
                this.togroup = this.setValue("togroup", toGroup);
                this.filtergroup = this.setValue("filtergroup", filterGroup);
                this.noof = this.setValue("noof", "" + noof);
                Pagination<NavUserDTO> pagination = this.createPagination(this.fromgroup, this.filtergroup, 1, noof);
                map.put("fromgroup", fromGroup);
                map.put("togroup", toGroup);
                map.put("filtergroup", filterGroup);
                map.put("noof", this.getValue("noof", "" + noof));
                map.put("pagination", pagination);
                this.renderUserVM(response, map);
                return;
            }
            if ("move".equals(action) || "copy".equals(action)) {
                String[] selectedUsers = null;
                String fromGroup = "";
                if (xssRrequest.getParameter("fromgroup") != null) {
                    fromGroup = xssRrequest.getParameter("fromgroup");
                }
                String toGroup = "";
                if (xssRrequest.getParameter("togroup") != null) {
                    toGroup = xssRrequest.getParameter("togroup");
                }
                this.fromgroup = this.setValue("fromgroup", fromGroup);
                this.togroup = this.setValue("togroup", toGroup);
                String res = "";
                boolean stopCopied = false;
                if (xssRrequest.getParameter("selUser") != null) {
                    selectedUsers = xssRrequest.getParameterValues("selUser");
                    TrialProcessing trialProcessing = this.helperTrialProcessing.exceedLimitByCopyUsers2DisabledGroups(toGroup, selectedUsers.length);
                    if (trialProcessing.isTrial() && trialProcessing.isWarning()) {
                        map.put("trialErrorMessages", HelperTrialProcessing.getMessageForManagementOperation(trialProcessing));
                        stopCopied = true;
                    }
                    if (!stopCopied) {
                        res = IntelligentUserManagerHelper.moveUsersInListFromGroupToGroup(selectedUsers, fromGroup, toGroup, "move".equals(action));
                    }
                }
                map.put("fromgroup", this.getValue("fromgroup", fromGroup));
                map.put("togroup", this.getValue("togroup", toGroup));
                map.put("noof", this.getValue("noof", this.noof));
                map.put("successMessage", res);
                this.renderUserVM(response, map);
                return;
            }
            this.renderUserVM(response, map);
        }
        catch (WebSudoSessionException wes) {
            response.sendError(403);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            boolean showSideLicense;
            XSSHttpServletRequestWrapper xssRrequest = new XSSHttpServletRequestWrapper(request);
            UserKey userKey = this.userManager.getRemoteUserKey();
            if (userKey == null || !this.userManager.isAdmin(userKey)) {
                this.redirectToLogin((HttpServletRequest)xssRrequest, response);
                return;
            }
            this.webSudoManager.willExecuteWebSudoRequest((HttpServletRequest)xssRrequest);
            boolean bl = showSideLicense = xssRrequest.getParameter("sl") != null;
            if (showSideLicense) {
                this.renderSideLicenseVM(response);
                return;
            }
            boolean bl2 = showSideLicense = !"".equals(DAO.getSideLicense());
            if (!ConditionEvaluatorImpl.isLicenseValid()) {
                this.renderLicenseErrorVM(response, showSideLicense);
                return;
            }
            if (xssRrequest.getParameter("oldest") != null) {
                String group = DAO.getIUMGroups();
                String[] enableGroupNames = group != null ? group.split(",") : null;
                StringBuffer sb = new StringBuffer();
                boolean found = false;
                for (int i = 0; i < enableGroupNames.length; ++i) {
                    if (enableGroupNames[i] == null || enableGroupNames[i].length() < 1) continue;
                    Group testGroup = groupManager.getGroup(enableGroupNames[i]);
                    List<OldestUser> oldestUserList = IntelligentUserManagerHelper.getOldestUser(testGroup, null, 10);
                    String separator = "\n";
                    sb.append(separator).append("Analyse Group " + enableGroupNames[i]).append("  for duration ").append(DAO.getDuration()).append(separator).append(" Found at least  " + oldestUserList.size()).append(separator);
                    if (oldestUserList.size() > 0) {
                        found = true;
                        sb.append(oldestUserList.stream().map(oUser -> oUser.getUser().getUsername() + " - " + SDF.format(oUser.getTimeStamp())).collect(Collectors.joining(separator)));
                    }
                    sb.append(separator);
                }
                response.setContentType("text/plain");
                if (found) {
                    response.getWriter().write(sb.toString());
                } else {
                    response.getWriter().write("No Oldest User found for Group(s) " + group);
                }
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("fromgroup", this.getValue("fromgroup", this.fromgroup));
            map.put("togroup", this.getValue("togroup", this.togroup));
            map.put("filtergroup", this.getValue("filtergroup", this.filtergroup));
            map.put("noof", this.getValue("noof", this.noof));
            if (xssRrequest.getParameter("list") != null) {
                Pagination<NavUserDTO> pagination = this.createPagination((ServletRequestWrapper)xssRrequest);
                map.put("pagination", pagination);
            } else {
                this.fromgroup = this.getValue("fromgroup", this.fromgroup);
                this.filtergroup = this.getValue("filtergroup", this.filtergroup);
                if (!StringUtils.isEmpty((CharSequence)this.fromgroup)) {
                    Pagination<NavUserDTO> pagination = this.createPagination(this.fromgroup, this.filtergroup, 1, 10);
                    map.put("pagination", pagination);
                }
            }
            this.renderUserVM(response, map);
        }
        catch (WebSudoSessionException wes) {
            LOG.error("WebSudoSessionException " + wes.getMessage(), (Throwable)wes);
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    private Pagination<NavUserDTO> createPagination(ServletRequestWrapper xssRrequest) {
        String fromGroup = this.getValue("fromgroup", this.fromgroup);
        String filterGroup = this.getValue("filtergroup", this.filtergroup);
        int page = 1;
        int pageSize = 10;
        try {
            if (xssRrequest.getParameter("page") != null) {
                page = Integer.parseInt(xssRrequest.getParameter("page"));
            }
        }
        catch (Exception e) {
            page = 1;
        }
        try {
            if (xssRrequest.getParameter("noof") != null) {
                pageSize = Integer.parseInt(xssRrequest.getParameter("noof"));
            }
        }
        catch (Exception e) {
            pageSize = 10;
        }
        return this.createPagination(fromGroup, filterGroup, page, pageSize);
    }

    private Pagination<NavUserDTO> createPagination(String fromGroup, String filterGroup, int page, int pageSize) {
        List<NavUserDTO> navUsers = this.pocketRepository.getOldestUsers(fromGroup, filterGroup, (page - 1) * pageSize, pageSize);
        long countUsers = this.pocketRepository.countOldestUsers(fromGroup, filterGroup);
        int pageCount = (int)(countUsers / (long)pageSize + (long)(countUsers % (long)pageSize != 0L ? 1 : 0));
        Pagination<NavUserDTO> pagination = new Pagination<NavUserDTO>(navUsers, page, pageSize, pageCount);
        return pagination;
    }

    private void renderLicenseErrorVM(HttpServletResponse response, boolean showSideLicense) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        response.setContentType("text/html;charset=utf-8");
        context.put("showSideLicense", showSideLicense);
        context.put("baseurl", this.applicationProperties.getBaseUrl());
        this.renderer.render("templates/checklicense_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderUserVM(HttpServletResponse response, Map<String, Object> context) throws IOException {
        context.put("isJira8", this.isJira8x());
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/user_IUM.vm", context, (Writer)response.getWriter());
    }

    private void forceToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        URI origin = this.getUri(request);
        request.getSession().invalidate();
        response.sendRedirect(this.loginUriProvider.getLoginUri(origin).toASCIIString());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void renderSideLicenseVM(HttpServletResponse response) throws IOException {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("sideLicense", DAO.getSideLicense());
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/sidelicense_IUM.vm", context, (Writer)response.getWriter());
    }

    public String getValue(String key, String currentVal) {
        return currentVal == null ? DAO.getValue(key) : currentVal;
    }

    public String setValue(String key, String value) {
        if (value == null) {
            value = "";
        }
        DAO.setValue(key, value);
        return value;
    }

    private boolean isEmpty(String contextPath) {
        return contextPath == null || contextPath.isEmpty();
    }

    private boolean isJira8x() {
        int[] versions = this.buildUtilsInfo.getVersionNumbers();
        return versions != null && versions.length > 0 && versions[0] > 7;
    }
}

