/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.session;

import de.accxia.jira.addon.IUM.servlet.session.AccxiaMutableJiraUserSession;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

class AccxiaUserSessionTrackerDeletionStrategy {
    private final AtomicBoolean deleteStaleSessionsPermit = new AtomicBoolean(false);
    private long nextCheckTime = System.currentTimeMillis();
    private static final long MAX_SESSION_AGE = 14400000L;
    private static final long MIN_TIME_BETWEEN_CHECKS = 30000L;

    AccxiaUserSessionTrackerDeletionStrategy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteStaleSessions(ConcurrentMap<String, AccxiaMutableJiraUserSession> liveSessionMap) {
        long now = System.currentTimeMillis();
        if (now >= this.nextCheckTime && this.deleteStaleSessionsPermit.compareAndSet(false, true)) {
            try {
                this.cleanupStaleSessions(liveSessionMap);
            }
            finally {
                this.nextCheckTime = now + 30000L;
                this.deleteStaleSessionsPermit.set(false);
            }
        }
    }

    private void cleanupStaleSessions(ConcurrentMap<String, AccxiaMutableJiraUserSession> liveSessionMap) {
        Iterator it = liveSessionMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            AccxiaMutableJiraUserSession accxiaMutableJiraUserSession = (AccxiaMutableJiraUserSession)next.getValue();
            if (!this.sessionHasExpired(accxiaMutableJiraUserSession)) continue;
            accxiaMutableJiraUserSession.removeDB();
            it.remove();
        }
    }

    private boolean sessionHasExpired(AccxiaMutableJiraUserSession userSession) {
        if (userSession == null) {
            return false;
        }
        Date lastAccessTime = userSession.getLastAccessTime();
        long sessionAgeMillis = System.currentTimeMillis() - lastAccessTime.getTime();
        return sessionAgeMillis > 14400000L;
    }
}

