// Equivalent of yyyy-mm-ddTHH:MM:SS.SSS
// this is the ISO8601 date time format.
// It is something your server-side code should be able to decode in to a proper date+time using,
// e.g., DateTimeFormatter, or Joda-Time.
var formatToSendToServer = "%Y-%m-%dT%H:%M:%S";

// Outputs something like "10/Dec/19, 11:15 AM"
var formatToDisplay = "%e/%b/%y, %I:%M %p";

// call this code when appropriate -- i.e., when you know your element is rendered
// typically you do this on a NEW_CONTENT_ADDED event
function initDateTimePicker(element, formatToSendToServer, formatToDisplay) {
    Calendar.setup({
        inputField: element,
        ifFormat: formatToSendToServer,
        daFormat: formatToDisplay,
        showsTime: true
    });
}


AJS.$( document ).ready(function() {
    var myInputField = AJS.$('#startingAt');
    initDateTimePicker(myInputField, formatToSendToServer, formatToSendToServer);
});