/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.repository;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import de.accxia.jira.addon.IUM.model.JobMessage;
import de.accxia.jira.addon.IUM.model.JobMessageDTO;
import java.util.Date;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={JobMessageRepository.class})
@Named(value="JobMessageRepository")
public class JobMessageRepository {
    private static final Logger logger = LoggerFactory.getLogger(JobMessageRepository.class);
    @ComponentImport
    private final ActiveObjects ao;

    @Inject
    public JobMessageRepository(ActiveObjects ao) {
        this.ao = ao;
    }

    public JobMessage save(JobMessageDTO jobMessageDTO) {
        final HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("ADMIN_READ", jobMessageDTO.getAdminRead());
        values.put("VALID", jobMessageDTO.getValid());
        values.put("USER_NAME", jobMessageDTO.getUserName());
        values.put("MESSAGE", jobMessageDTO.getMessage());
        values.put("CREATION_TIME", jobMessageDTO.getCreationTime());
        values.put("MESSAGE_TYPE", jobMessageDTO.getMessageType().getValue());
        values.put("ADJUST_SEATS", jobMessageDTO.getAdjustSeats());
        JobMessage response = (JobMessage)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<JobMessage>(){

            public JobMessage doInTransaction() {
                JobMessage response = (JobMessage)JobMessageRepository.this.ao.create(JobMessage.class, values);
                return response;
            }
        });
        logger.debug("Successfully save for user {}", (Object)jobMessageDTO.getUserName());
        return response;
    }

    public JobMessage[] getLatestMessage(Date date) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called getLatestMessage for date  {} ", (Object)date);
        }
        JobMessage[] queryResult = (JobMessage[])this.ao.find(JobMessage.class, Query.select().where("ADMIN_READ= ? AND CREATION_TIME > ? ", new Object[]{0, date}).order("ID DESC").limit(1));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully fetch result for date  {} ", (Object)date);
        }
        return queryResult;
    }

    public JobMessage[] getUnreadMessage() {
        if (logger.isDebugEnabled()) {
            logger.debug("Called getUnreadMessage");
        }
        JobMessage[] queryResult = (JobMessage[])this.ao.find(JobMessage.class, Query.select().where("ADMIN_READ = ?  AND VALID = ? ", new Object[]{0, 0}).order("ID DESC"));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully fetch result ");
        }
        return queryResult;
    }

    public JobMessage[] getByUserName(String userName, int idx, int ctx) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called getByUserName for userName {} ", (Object)userName);
        }
        JobMessage[] queryResult = (JobMessage[])this.ao.find(JobMessage.class, Query.select().where("USER_NAME = ? ", new Object[]{userName}).order("ID DESC").offset(idx).limit(ctx));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully fetch result for userName {} ", (Object)userName);
        }
        return queryResult;
    }

    public JobMessage[] findAll(int idx, int ctx) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called findAll from  {} to {}", (Object)idx, (Object)ctx);
        }
        JobMessage[] queryResult = (JobMessage[])this.ao.find(JobMessage.class, Query.select().order("ID DESC").offset(idx).limit(ctx));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully findAll from  {} to {}", (Object)idx, (Object)ctx);
        }
        return queryResult;
    }

    public boolean markReadMessage(long id) {
        JobMessage[] queryResult;
        if (logger.isDebugEnabled()) {
            logger.debug("Called markReadMessage for date  {} ", (Object)id);
        }
        for (JobMessage jobMessage : queryResult = (JobMessage[])this.ao.find(JobMessage.class, Query.select().where("ID = ? ", new Object[]{id}))) {
            jobMessage.setAdminRead(1);
            jobMessage.save();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully fetch result for date  {} ", (Object)id);
        }
        return queryResult.length > 0;
    }
}

