/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.job.ProcessResult;
import de.accxia.jira.addon.IUM.model.AlertType;
import de.accxia.jira.addon.IUM.model.FreeProcessing;
import de.accxia.jira.addon.IUM.model.FreeProcessingFactory;
import de.accxia.jira.addon.IUM.model.IUMAlertDTO;
import de.accxia.jira.addon.IUM.model.TrialProcessing;
import de.accxia.jira.addon.IUM.repository.IUMAlertRepository;
import de.accxia.jira.addon.IUM.utils.Constants;
import de.accxia.jira.addon.IUM.utils.ParseUtil;
import io.atlassian.fugue.Option;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HelperTrialProcessing {
    private static final Logger LOG = LoggerFactory.getLogger(HelperTrialProcessing.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final ApplicationRoleManager applicationRoleManager;
    @ComponentImport
    private final JiraLicenseManager jiraLicenseManager;
    private static JiraAuthenticationContext jiraAuthenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
    private final IUMAlertRepository alertRepository;
    private static UserUtil userUtil = ComponentAccessor.getUserUtil();

    @Inject
    public HelperTrialProcessing(GroupManager groupManager, ApplicationRoleManager applicationRoleManager, JiraLicenseManager jiraLicenseManager, IUMAlertRepository alertRepository) {
        this.groupManager = groupManager;
        this.applicationRoleManager = applicationRoleManager;
        this.jiraLicenseManager = jiraLicenseManager;
        this.alertRepository = alertRepository;
    }

    public int getSeats(ApplicationKey applicationKey) {
        Option optLicenseDetails = this.jiraLicenseManager.getLicense(applicationKey);
        int licenseCount = 0;
        if (!optLicenseDetails.isEmpty()) {
            LicenseDetails licenseDetails = (LicenseDetails)optLicenseDetails.get();
            if (licenseDetails.getJiraLicense().isUnlimitedNumberOfUsers()) {
                licenseCount = applicationKey == ApplicationKeys.SOFTWARE ? Constants.SOFTWARE_SEATS.intValue() : Constants.SERVICE_SEATS.intValue();
            } else if (licenseDetails.getJiraLicense().getMaximumNumberOfUsers() > 0) {
                licenseCount = licenseDetails.getJiraLicense().getMaximumNumberOfUsers();
            }
        }
        return licenseCount;
    }

    public List<ProcessResult> adjustStatus4FreeVersion(String username) {
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        String sourceGroups = DAO.getIUMGroups();
        String targetGroup = DAO.getIUMGroupsDisabled();
        String queueSize = DAO.getQueueSize();
        DAO.updateReservedLicense(String.valueOf(1));
        if (!StringUtils.isEmpty((CharSequence)targetGroup)) {
            ProcessResult processResult;
            int adjustSeats;
            int qSize;
            String[] iumGroups = sourceGroups.split(",");
            String[] iumGroupDISs = targetGroup.split(",");
            CharSequence[] queueSizes = queueSize.split(",");
            GroupManager groupManager = (GroupManager)ComponentLocator.getComponent(GroupManager.class);
            ArrayList<String> users = new ArrayList<String>();
            if (iumGroups.length > 0 && iumGroupDISs.length > 0) {
                qSize = ParseUtil.safeParseInt(queueSizes[0], 0);
                adjustSeats = 0;
                if (qSize > 5) {
                    adjustSeats = qSize - 5;
                    qSize = 5;
                    queueSizes[0] = String.valueOf(5);
                }
                processResult = this.doProcessPair(groupManager, iumGroupDISs[0], iumGroups[0], 5, qSize);
                processResult.setAdjustSeats(adjustSeats);
                processResultList.add(processResult);
                users.addAll(processResult.getUsers());
            }
            if (iumGroups.length > 1 && iumGroupDISs.length > 1) {
                qSize = ParseUtil.safeParseInt(queueSizes[1], 0);
                adjustSeats = 0;
                if (qSize > 5) {
                    adjustSeats = qSize - 5;
                    qSize = 5;
                    queueSizes[1] = String.valueOf(5);
                }
                processResult = this.doProcessPair(groupManager, iumGroupDISs[1], iumGroups[1], 5, qSize);
                processResult.setAdjustSeats(adjustSeats);
                processResultList.add(processResult);
                users.addAll(processResult.getUsers());
            }
            if (iumGroups.length > 2 && iumGroupDISs.length > 2) {
                qSize = ParseUtil.safeParseInt((String)queueSizes[2], 0);
                adjustSeats = 0;
                if (qSize > 5) {
                    adjustSeats = qSize - 5;
                    qSize = 5;
                    queueSizes[2] = String.valueOf(5);
                }
                processResult = this.doProcessPair(groupManager, iumGroupDISs[2], iumGroups[2], 5, qSize);
                processResult.setAdjustSeats(adjustSeats);
                processResultList.add(processResult);
                users.addAll(processResult.getUsers());
            }
            DAO.updateQueueSize(String.join((CharSequence)",", queueSizes));
        }
        return processResultList;
    }

    public List<ProcessResult> adjustStatus4NormalVersion(String username) {
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        String sourceGroups = DAO.getIUMGroups();
        String targetGroup = DAO.getIUMGroupsDisabled();
        String queueSize = DAO.getQueueSize();
        DAO.updateReservedLicense(String.valueOf(1));
        if (!StringUtils.isEmpty((CharSequence)targetGroup)) {
            String[] iumGroups = sourceGroups.split(",");
            String[] iumGroupDISs = targetGroup.split(",");
            String[] queueSizes = queueSize.split(",");
            GroupManager groupManager = (GroupManager)ComponentLocator.getComponent(GroupManager.class);
            ArrayList<String> users = new ArrayList<String>();
            for (int i = 0; i < queueSizes.length; ++i) {
                int qGroupUsers;
                int qSize;
                if (iumGroups.length <= i || iumGroupDISs.length <= i || (qSize = ParseUtil.safeParseInt(queueSizes[i], 0)) >= (qGroupUsers = groupManager.getUsersInGroupCount(iumGroupDISs[i]))) continue;
                ProcessResult processResult = this.doProcessPair(groupManager, iumGroupDISs[i], iumGroups[i], -1, qSize);
                processResult.setAdjustSeats(qGroupUsers - qSize);
                processResultList.add(processResult);
                users.addAll(processResult.getUsers());
            }
        }
        return processResultList;
    }

    private ProcessResult doProcessPair(GroupManager groupManager, String sourceGroup, String targetGroup, Integer maxUsers, Integer maxSlots) {
        ProcessResult processResult;
        block10: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HelperTrialProcessing process groups = {} -> {}  at [ {} ] ", new Object[]{sourceGroup, targetGroup, SDF.format(new Date())});
            }
            int groupNameCount = groupManager.getUsersInGroupCount(sourceGroup);
            processResult = new ProcessResult("MembershipJob", sourceGroup, targetGroup);
            processResult.setUserRemoved(0L);
            try {
                int removeCount;
                Collection users;
                Group tGroup;
                Group sGroup = !StringUtils.isEmpty((CharSequence)sourceGroup) ? groupManager.getGroup(sourceGroup) : null;
                Group group = tGroup = !StringUtils.isEmpty((CharSequence)targetGroup) ? groupManager.getGroup(targetGroup) : null;
                if (maxUsers > 0 && groupNameCount > maxUsers && sGroup != null) {
                    users = groupManager.getUsersInGroup(sGroup);
                    removeCount = groupNameCount - maxUsers;
                    for (ApplicationUser user : users) {
                        try {
                            userUtil.removeUserFromGroup(sGroup, user);
                            userUtil.removeUserFromGroup(tGroup, user);
                            processResult.getUsers().add(user.getName());
                            --removeCount;
                            processResult.setUserRemoved(processResult.getUserRemoved() + 1L);
                        }
                        catch (Exception e) {
                            LOG.error("Exception while removing user from group [{}]", (Object)sourceGroup, (Object)e);
                        }
                        if (removeCount != 0) continue;
                        break;
                    }
                    maxUsers = 0;
                }
                if (tGroup == null || (removeCount = (users = groupManager.getUsersInGroup(tGroup)).size() - maxSlots) <= 0) break block10;
                for (ApplicationUser user : users) {
                    try {
                        userUtil.removeUserFromGroup(tGroup, user);
                        --removeCount;
                    }
                    catch (Exception e) {
                        LOG.error("Exception while removing user from group [{}]", (Object)sourceGroup, (Object)e);
                    }
                    if (removeCount != 0) continue;
                    break;
                }
            }
            catch (Exception e) {
                LOG.error("Exception while removing user from group [{}]", (Object)sourceGroup, (Object)e);
            }
        }
        return processResult;
    }

    public Set<ApplicationUser> getUsersWithGenericAccessExceptGroup(ApplicationKey applicationKey, String filterGroup) {
        Option applicationRole = this.applicationRoleManager.getRole(applicationKey);
        if (!applicationRole.isEmpty() && applicationRole.isDefined() && applicationRole.get() != null) {
            List groups = ((ApplicationRole)applicationRole.get()).getGroups().stream().map(Group::getName).filter(name -> !name.equalsIgnoreCase(filterGroup)).collect(Collectors.toList());
            Set users = userUtil.getAllUsersInGroupNamesUnsorted(groups);
            return users;
        }
        return Collections.EMPTY_SET;
    }

    public IUMAlertDTO markSyncProcessingError(AlertType alertType, String userName, String targetGroup, int size) {
        IUMAlertDTO alertDTO = new IUMAlertDTO();
        alertDTO.setActive(true);
        alertDTO.setAdmin(true);
        alertDTO.setUser(false);
        alertDTO.setUserName(userName);
        alertDTO.setType(alertType != null ? alertType.getValue() : AlertType.ALERT_NONE.getValue());
        alertDTO.setMessage(HelperTrialProcessing.getMessageForSyncAlerts(targetGroup, size));
        this.alertRepository.save(alertDTO);
        return alertDTO;
    }

    public IUMAlertDTO markMembershipChanges(AlertType alertType, String userName, String targetGroup, int adjustUsers, int adjustSeats) {
        IUMAlertDTO alertDTO = new IUMAlertDTO();
        alertDTO.setActive(true);
        alertDTO.setAdmin(true);
        alertDTO.setUser(false);
        alertDTO.setUserName(userName);
        alertDTO.setType(alertType != null ? alertType.getValue() : AlertType.ALERT_NONE.getValue());
        alertDTO.setMessage(HelperTrialProcessing.getMessageForMembershipAlerts(targetGroup, adjustUsers, adjustSeats));
        this.alertRepository.save(alertDTO);
        return alertDTO;
    }

    public IUMAlertDTO markMembershipChanges(AlertType alertType, String userName, boolean isFreeVersion, List<ProcessResult> processResultList) {
        IUMAlertDTO alertDTO = new IUMAlertDTO();
        I18nHelper i18nHelper = (I18nHelper)ComponentAccessor.getComponent(I18nHelper.class);
        alertDTO.setActive(true);
        alertDTO.setAdmin(true);
        alertDTO.setUser(false);
        alertDTO.setUserName(userName);
        alertDTO.setType(alertType != null ? alertType.getValue() : AlertType.ALERT_NONE.getValue());
        ArrayList<String> processResultMessage = new ArrayList<String>();
        for (ProcessResult processResult : processResultList) {
            if (processResult.getUserRemoved() <= 0L) continue;
            processResultMessage.add(String.format(i18nHelper.getText(isFreeVersion ? "de.accxia.apps.jira.IUM.removed.free.group.body" : "de.accxia.apps.jira.IUM.removed.normal.group.body"), processResult.getUserRemoved(), processResult.getSourceGroups()));
        }
        if (!processResultMessage.isEmpty()) {
            alertDTO.setMessage(String.format(i18nHelper.getText(isFreeVersion ? "de.accxia.apps.jira.IUM.removed.free.group.ex" : "de.accxia.apps.jira.IUM.removed.normal.group.ex"), 5, String.join((CharSequence)"<br/> ", processResultMessage)));
            this.alertRepository.save(alertDTO);
            return alertDTO;
        }
        return null;
    }

    public IUMAlertDTO markGroupSizeAdjust(AlertType alertType, String userName, boolean isFreeVersion) {
        IUMAlertDTO alertDTO = new IUMAlertDTO();
        I18nHelper i18nHelper = (I18nHelper)ComponentAccessor.getComponent(I18nHelper.class);
        alertDTO.setActive(true);
        alertDTO.setAdmin(true);
        alertDTO.setUser(false);
        alertDTO.setUserName(userName);
        alertDTO.setType(alertType != null ? alertType.getValue() : AlertType.ALERT_NONE.getValue());
        alertDTO.setMessage(String.format(i18nHelper.getText("de.accxia.apps.jira.IUM.removed.free.queue"), 5));
        this.alertRepository.save(alertDTO);
        return alertDTO;
    }

    public IUMAlertDTO markLicenseExpireError(AlertType alertType, long days) {
        IUMAlertDTO alertDTO = new IUMAlertDTO();
        alertDTO.setActive(true);
        alertDTO.setAdmin(true);
        alertDTO.setUser(false);
        alertDTO.setType(alertType != null ? alertType.getValue() : AlertType.ALERT_NONE.getValue());
        if (days > 0L) {
            alertDTO.setMessage(HelperTrialProcessing.getMessageForLicenseWillExpireAlerts(days));
        } else if (days < 0L) {
            alertDTO.setMessage(HelperTrialProcessing.getMessageForLicenseWasExpiredAlerts(days));
        } else {
            alertDTO.setMessage(HelperTrialProcessing.getMessageForLicenseTodayExpiredAlerts(days));
        }
        this.alertRepository.save(alertDTO);
        return alertDTO;
    }

    public FreeProcessing exceedLimitByCopyUsers2TargetGroup(String toGroup, String[] selectedUsers) {
        FreeProcessing freeProcessing = FreeProcessingFactory.createFreeProcessing();
        if (!freeProcessing.isFree()) {
            return freeProcessing;
        }
        String[] groupsDisabled = DAO.getIUMGroupsDisabled().split(",");
        if (!HelperTrialProcessing.checkArray(groupsDisabled, toGroup)) {
            freeProcessing.setWarning(false);
            return freeProcessing;
        }
        freeProcessing.setDisableGroup(toGroup);
        freeProcessing.setCountDisableGroup(this.groupManager.getUsersInGroupCount(toGroup));
        if (freeProcessing.getCountDisableGroup() + selectedUsers.length > 5) {
            HashSet<String> users = new HashSet<String>();
            users.addAll(this.groupManager.getUserNamesInGroup(toGroup));
            users.addAll(Arrays.asList(selectedUsers));
            if (users.size() > 5) {
                freeProcessing.setWarning(true);
                freeProcessing.setCountUsers(selectedUsers.length);
                freeProcessing.setExceed(users.size() - 5);
                return freeProcessing;
            }
        }
        freeProcessing.setWarning(false);
        return freeProcessing;
    }

    public IUMAlertDTO markGroupQueueSizeAdjust(AlertType alertType, String userName) {
        IUMAlertDTO alertDTO = new IUMAlertDTO();
        I18nHelper i18nHelper = (I18nHelper)ComponentAccessor.getComponent(I18nHelper.class);
        alertDTO.setActive(true);
        alertDTO.setAdmin(true);
        alertDTO.setUser(false);
        alertDTO.setUserName(userName);
        alertDTO.setType(alertType != null ? alertType.getValue() : AlertType.ALERT_NONE.getValue());
        alertDTO.setMessage(String.format(i18nHelper.getText("de.accxia.apps.jira.IUM.removed.free.seats"), 5));
        this.alertRepository.save(alertDTO);
        return alertDTO;
    }

    public FreeProcessing exceedLimitByCopyUsers2TargetGroup(String targetGroup, Set<String> selectedUsers) {
        return this.exceedLimitByCopyUsers2TargetGroup(targetGroup, selectedUsers.toArray(new String[selectedUsers.size()]));
    }

    public static String getMessageForManagementOperation(FreeProcessing freeProcessing) {
        LocaleManager lManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
        I18nHelper i18nHelper = (I18nHelper)ComponentAccessor.getComponent(I18nHelper.class);
        Locale locale = lManager.getLocaleFor(jiraAuthenticationContext.getLoggedInUser());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Locale=" + locale.getLanguage() + "default=" + Locale.getDefault().getLanguage());
            LOG.debug("de.accxia.apps.jira.IUM.exceed.license= " + i18nHelper.getText("de.accxia.apps.jira.IUM.exceed.license"));
        }
        return freeProcessing.isWarning() ? String.format(i18nHelper.getText("de.accxia.apps.jira.IUM.exceed.license"), freeProcessing.getCountUsers(), freeProcessing.getDisableGroup(), 5, freeProcessing.getExceed()) : null;
    }

    public static String getMessageForMembershipAlerts(String targetGroup, int adjustUsers, int adjustSeats) {
        LocaleManager lManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
        I18nHelper i18nHelper = (I18nHelper)ComponentAccessor.getComponent(I18nHelper.class);
        Locale locale = lManager.getLocaleFor(jiraAuthenticationContext.getLoggedInUser());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Locale=" + locale.getLanguage() + "default=" + Locale.getDefault().getLanguage());
            LOG.debug("de.accxia.apps.jira.IUM.removed.free.group= " + i18nHelper.getText("de.accxia.apps.jira.IUM.removed.free.group"));
        }
        return String.format(i18nHelper.getText("de.accxia.apps.jira.IUM.removed.free.group"), 5, adjustUsers, targetGroup, adjustSeats);
    }

    public static String getMessageForGroupSizeAlerts(String targetGroup, int adjustUsers, int adjustSeats) {
        LocaleManager lManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
        I18nHelper i18nHelper = (I18nHelper)ComponentAccessor.getComponent(I18nHelper.class);
        Locale locale = lManager.getLocaleFor(jiraAuthenticationContext.getLoggedInUser());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Locale=" + locale.getLanguage() + "default=" + Locale.getDefault().getLanguage());
            LOG.debug("de.accxia.apps.jira.IUM.removed.free.queue= " + i18nHelper.getText("de.accxia.apps.jira.IUM.removed.free.queue"));
        }
        return String.format(i18nHelper.getText("de.accxia.apps.jira.IUM.removed.free.queue"), 5, adjustUsers, targetGroup, adjustSeats);
    }

    public static String getMessageForQueueSizeAlerts(int adjustSeats) {
        LocaleManager lManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
        I18nHelper i18nHelper = (I18nHelper)ComponentAccessor.getComponent(I18nHelper.class);
        Locale locale = lManager.getLocaleFor(jiraAuthenticationContext.getLoggedInUser());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Locale=" + locale.getLanguage() + "default=" + Locale.getDefault().getLanguage());
            LOG.debug("de.accxia.apps.jira.IUM.removed.free.seats= " + i18nHelper.getText("de.accxia.apps.jira.IUM.removed.free.seats"));
        }
        return String.format(i18nHelper.getText("de.accxia.apps.jira.IUM.removed.free.seats"), 5, adjustSeats);
    }

    public static String getMessageForSyncAlerts(String targetGroup, int len) {
        LocaleManager lManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
        I18nHelper i18nHelper = (I18nHelper)ComponentAccessor.getComponent(I18nHelper.class);
        Locale locale = lManager.getLocaleFor(jiraAuthenticationContext.getLoggedInUser());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Locale=" + locale.getLanguage() + "default=" + Locale.getDefault().getLanguage());
            LOG.debug("de.accxia.apps.jira.IUM.copy.group= " + i18nHelper.getText("de.accxia.apps.jira.IUM.copy.group"));
        }
        return String.format(i18nHelper.getText("de.accxia.apps.jira.IUM.copy.group"), 5, targetGroup);
    }

    public static String getMessageForLicenseTodayExpiredAlerts(long days) {
        LocaleManager lManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
        I18nHelper i18nHelper = (I18nHelper)ComponentAccessor.getComponent(I18nHelper.class);
        Locale locale = lManager.getLocaleFor(jiraAuthenticationContext.getLoggedInUser());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Locale=" + locale.getLanguage() + "default=" + Locale.getDefault().getLanguage());
            LOG.debug("de.accxia.apps.jira.IUM.expire.today.license.html= " + i18nHelper.getText("de.accxia.apps.jira.IUM.expire.today.license.html"));
        }
        return i18nHelper.getText("de.accxia.apps.jira.IUM.expire.today.license.html");
    }

    public static String getMessageForLicenseWillExpireAlerts(long days) {
        LocaleManager lManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
        I18nHelper i18nHelper = (I18nHelper)ComponentAccessor.getComponent(I18nHelper.class);
        Locale locale = lManager.getLocaleFor(jiraAuthenticationContext.getLoggedInUser());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Locale=" + locale.getLanguage() + "default=" + Locale.getDefault().getLanguage());
            LOG.debug("de.accxia.apps.jira.IUM.expire.will.license.html= " + i18nHelper.getText("de.accxia.apps.jira.IUM.expire.will.license.html"));
        }
        return String.format(i18nHelper.getText("de.accxia.apps.jira.IUM.expire.will.license.html"), days);
    }

    public static String getMessageForLicenseWasExpiredAlerts(long days) {
        LocaleManager lManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
        I18nHelper i18nHelper = (I18nHelper)ComponentAccessor.getComponent(I18nHelper.class);
        Locale locale = lManager.getLocaleFor(jiraAuthenticationContext.getLoggedInUser());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Locale=" + locale.getLanguage() + "default=" + Locale.getDefault().getLanguage());
            LOG.debug("de.accxia.apps.jira.IUM.expire.was.license.html= " + i18nHelper.getText("de.accxia.apps.jira.IUM.expire.was.license.html"));
        }
        return String.format(i18nHelper.getText("de.accxia.apps.jira.IUM.expire.was.license.html"), -1L * days);
    }

    public IUMAlertDTO markMembershipProcessingError(AlertType alertType, String userName, String targetGroup, int size) {
        IUMAlertDTO alertDTO = new IUMAlertDTO();
        alertDTO.setActive(true);
        alertDTO.setAdmin(true);
        alertDTO.setUser(false);
        alertDTO.setUserName(userName);
        alertDTO.setType(alertType != null ? alertType.getValue() : AlertType.ALERT_NONE.getValue());
        alertDTO.setMessage(HelperTrialProcessing.getMessageForMembershipAlerts(targetGroup, size));
        this.alertRepository.save(alertDTO);
        return alertDTO;
    }

    public TrialProcessing exceedLimitByCopyUsers2DisabledGroups(String toGroup, int len) {
        TrialProcessing trialProcessing = new TrialProcessing(ConditionEvaluatorImpl.isFreeVersion());
        if (!trialProcessing.isTrial()) {
            return trialProcessing;
        }
        String[] groupsDisabled = DAO.getIUMGroupsDisabled().split(",");
        if (!HelperTrialProcessing.checkArray(groupsDisabled, toGroup)) {
            return trialProcessing;
        }
        trialProcessing.setDisableGroup(toGroup);
        trialProcessing.setCountDisableGroup(this.groupManager.getUsersInGroupCount(toGroup));
        if (trialProcessing.getCountDisableGroup() + len > 5) {
            trialProcessing.setWarning(true);
            trialProcessing.setCountUsers(len);
            trialProcessing.setExceed(trialProcessing.getCountDisableGroup() + len - 5);
            return trialProcessing;
        }
        return trialProcessing;
    }

    public TrialProcessing exceedLimitByCopyUsers2Group(String targetGroup, int len) {
        TrialProcessing trialProcessing = new TrialProcessing(ConditionEvaluatorImpl.isFreeVersion());
        if (len == 0 || !trialProcessing.isTrial()) {
            return trialProcessing;
        }
        trialProcessing.setDisableGroup(targetGroup);
        trialProcessing.setCountDisableGroup(this.groupManager.getUsersInGroupCount(targetGroup));
        if (trialProcessing.getCountDisableGroup() + len > 5) {
            trialProcessing.setWarning(true);
            trialProcessing.setCountUsers(len);
            trialProcessing.setExceed(trialProcessing.getCountDisableGroup() + len - 5);
            return trialProcessing;
        }
        return trialProcessing;
    }

    public static String getMessageForManagementOperation(TrialProcessing trialProcessing) {
        Locale locale = ComponentAccessor.getJiraAuthenticationContext().getLocale();
        I18nHelper i18Helper = ComponentAccessor.getI18nHelperFactory().getInstance(locale);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Locale=" + locale.getLanguage() + "default=" + Locale.getDefault().getLanguage());
            LOG.debug("de.accxia.apps.jira.IUM.exceed.license= " + i18Helper.getText("de.accxia.apps.jira.IUM.exceed.license"));
        }
        return trialProcessing.isWarning() ? String.format(i18Helper.getText("de.accxia.apps.jira.IUM.exceed.license"), trialProcessing.getCountUsers(), trialProcessing.getDisableGroup(), 5, trialProcessing.getExceed()) : null;
    }

    public static String getMessageForMembershipAlerts(String targetGroup, int len) {
        Locale locale = ComponentAccessor.getJiraAuthenticationContext().getLocale();
        I18nHelper i18Helper = ComponentAccessor.getI18nHelperFactory().getInstance(locale);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Locale=" + locale.getLanguage() + "default=" + Locale.getDefault().getLanguage());
            LOG.debug("de.accxia.apps.jira.IUM.removed.group= " + i18Helper.getText("de.accxia.apps.jira.IUM.exceed.license"));
        }
        return String.format(i18Helper.getText("de.accxia.apps.jira.IUM.removed.group"), 5, len, targetGroup);
    }

    public static ApplicationRole getApplicationRole(ApplicationRoleManager applicationRoleManager, ApplicationKey applicationKey) {
        if (applicationRoleManager == null || applicationKey == null) {
            return null;
        }
        List applicationRoleList = applicationRoleManager.getRoles().stream().filter(applicationRole -> applicationRole.getKey().equals((Object)applicationKey)).collect(Collectors.toList());
        return applicationRoleList.size() > 0 ? (ApplicationRole)applicationRoleList.get(0) : null;
    }

    private static boolean checkArray(String[] arr, String targetValue) {
        for (String s : arr) {
            if (!s.equals(targetValue)) continue;
            return true;
        }
        return false;
    }
}

