/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.annotations.security.UnlicensedSiteAccess;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.JiraMultipartRequestWrapper;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.servlet.filter.ResettableStreamHttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import webwork.config.Configuration;

@Component
@UnlicensedSiteAccess
public class IUMAssignIssueFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(IUMAssignIssueFilter.class);
    public static final String WATCHERS = "/rest/api/[\\d\\.\\w]+/issue/[\\d\\-\\w]+/watchers";
    public static final String WATCHERS_FILTER = "/rest/api/[\\d\\.\\w]+/users/picker/filter";
    public static final Pattern PATTERN_WATCHERS = Pattern.compile("/rest/api/[\\d\\.\\w]+/issue/[\\d\\-\\w]+/watchers");
    public static final Pattern PATTERN_WATCHERS_FILTER = Pattern.compile("/rest/api/[\\d\\.\\w]+/users/picker/filter");
    private static UserManager userManagerJira = ComponentAccessor.getUserManager();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!ConditionEvaluatorImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        Object httpRequest = (HttpServletRequest)request;
        if (httpRequest.getRequestURI() == null) {
            chain.doFilter(request, response);
            return;
        }
        if (httpRequest.getRequestURI().contains("/secure/") && httpRequest.getMethod().equalsIgnoreCase("POST")) {
            String[] unamesAssignee = null;
            String[] unamesUsers = null;
            if (request.getContentType() != null && request.getContentType().indexOf("multipart/form-data") != -1) {
                ResettableStreamHttpServletRequest resettableStreamHttpServletRequest = new ResettableStreamHttpServletRequest((HttpServletRequest)httpRequest);
                String maxSizeStr = Configuration.getString((String)"webwork.multipart.maxSize");
                JiraMultipartRequestWrapper jiraMultipartRequestWrapper = new JiraMultipartRequestWrapper((HttpServletRequest)resettableStreamHttpServletRequest, ((File)request.getServletContext().getAttribute("javax.servlet.context.tempdir")).getAbsolutePath(), Integer.parseInt(maxSizeStr));
                resettableStreamHttpServletRequest.resetInputStream();
                unamesAssignee = jiraMultipartRequestWrapper.getParameterValues("assignee");
                unamesUsers = jiraMultipartRequestWrapper.getParameterValues("userNames");
                httpRequest = resettableStreamHttpServletRequest;
                request = httpRequest;
            } else {
                unamesAssignee = request.getParameterValues("assignee");
                unamesUsers = request.getParameterValues("userNames");
                String string = request.getParameter("issueId");
            }
            ArrayList<String> unames = new ArrayList<String>();
            if (unamesAssignee != null && unamesAssignee.length > 0) {
                unames.addAll(Arrays.asList(unamesAssignee));
            }
            if (unamesUsers != null && unamesUsers.length > 0) {
                unames.addAll(Arrays.stream(unamesUsers).flatMap(uname -> Arrays.stream(uname.split(","))).map(uname -> uname.trim()).filter(uname -> uname.length() > 0).collect(Collectors.toList()));
            }
            if (unames.size() == 0) {
                chain.doFilter(request, response);
                return;
            }
            this.shouldEnableUser(unames);
            chain.doFilter(request, response);
            return;
        }
        if (PATTERN_WATCHERS.matcher(httpRequest.getRequestURI()).matches() && httpRequest.getRequestURI().startsWith("/rest/api/") && httpRequest.getMethod().equalsIgnoreCase("POST") && request.getContentType() != null && request.getContentType().indexOf("application/json") != -1) {
            ResettableStreamHttpServletRequest resettableStreamHttpServletRequest = new ResettableStreamHttpServletRequest((HttpServletRequest)httpRequest);
            String watchers = IOUtils.toString((InputStream)resettableStreamHttpServletRequest.getInputStream());
            ArrayList<String> unames = new ArrayList<String>();
            resettableStreamHttpServletRequest.resetInputStream();
            if (watchers != null && watchers.length() > 0) {
                unames.addAll(Arrays.asList(watchers.replaceAll("\"", "").split(",")));
            }
            if (unames.size() == 0) {
                chain.doFilter(request, response);
                return;
            }
            this.shouldEnableUser(unames);
            chain.doFilter((ServletRequest)resettableStreamHttpServletRequest, response);
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private void shouldEnableUser(List<String> unames) {
        if (unames == null || unames.size() == 0) {
            return;
        }
        for (String uname : unames) {
            ApplicationUser user = userManagerJira.getUserByName(uname);
            if (IntelligentUserManagerHelper.isUserInJiraAndSDGroups(user, DAO.getIUMGroups()) || !IntelligentUserManagerHelper.isUserInGroups(user, DAO.getIUMGroupsDisabled())) continue;
            try {
                boolean success = IntelligentUserManagerHelper.simulateUserToEnabledGroup(user);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Simulation " + user.getUsername() + " " + success);
            }
            catch (Exception e) {
                LOG.error("Exception " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

