/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.side;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import de.accxia.jira.addon.IUM.model.IUMAlert;
import de.accxia.jira.addon.IUM.model.IUMAlertDTO;
import de.accxia.jira.addon.IUM.repository.IUMAlertRepository;
import de.accxia.jira.addon.IUM.servlet.HelperTrialProcessing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Path(value="/ium-alert")
@Component
@UnrestrictedAccess
public class IUMAlertResource {
    private final IUMAlertRepository iumAlertRepository;
    private final HelperTrialProcessing helperTrialProcessing;

    public IUMAlertResource(IUMAlertRepository iumAlertRepository, HelperTrialProcessing helperTrialProcessing) {
        this.iumAlertRepository = iumAlertRepository;
        this.helperTrialProcessing = helperTrialProcessing;
    }

    @GET
    @Path(value="/alerts")
    @Produces(value={"application/json"})
    public Response getAdminAlert() {
        IUMAlert[] alerts;
        ApplicationUser user = ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser();
        HashMap map = new HashMap();
        if (user != null && this.isUserAdmin(user) && (alerts = this.iumAlertRepository.getAdminActiveAlerts()) != null && alerts.length > 0) {
            Map<Integer, List<IUMAlertDTO>> mapAlerts = Arrays.stream(alerts).map(IUMAlertDTO::fromAO).collect(Collectors.groupingBy(IUMAlertDTO::getType));
            ArrayList<String> messages = new ArrayList<String>();
            for (Integer key : mapAlerts.keySet()) {
                List<IUMAlertDTO> values = mapAlerts.get(key);
                Optional alert = values.stream().findFirst();
                if (!alert.isPresent()) continue;
                messages.add(((IUMAlertDTO)alert.get()).getMessage());
            }
            map.put("messages", messages);
            return Response.ok(map).build();
        }
        return Response.ok(map).build();
    }

    @POST
    @Path(value="/dismiss")
    @Produces(value={"application/json"})
    public Response dismissAdminAlert() {
        IUMAlert[] alerts;
        ApplicationUser user = ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser();
        HashMap map = new HashMap();
        if (user != null && this.isUserAdmin(user) && (alerts = this.iumAlertRepository.dismissAdminActiveAlert()) != null && alerts.length > 0) {
            Map<Integer, List<IUMAlertDTO>> mapAlerts = Arrays.stream(alerts).map(IUMAlertDTO::fromAO).collect(Collectors.groupingBy(IUMAlertDTO::getType));
            ArrayList<String> messages = new ArrayList<String>();
            for (Integer key : mapAlerts.keySet()) {
                List<IUMAlertDTO> values = mapAlerts.get(key);
                Optional alert = values.stream().findFirst();
                if (!alert.isPresent()) continue;
                messages.add(((IUMAlertDTO)alert.get()).getMessage());
            }
            map.put("messages", messages);
            return Response.ok(map).build();
        }
        return Response.ok(map).build();
    }

    private boolean isUserAdmin(ApplicationUser user) {
        return ComponentAccessor.getGroupManager().isUserInGroup(user, "jira-administrators");
    }
}

