/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.cache;

import de.accxia.jira.addon.IUM.cache.AccxiaCacheComponent;
import de.accxia.jira.addon.IUM.cache.AccxiaCachePropertySet;
import de.accxia.jira.addon.IUM.config.DAO;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/cache")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Component
public class InfoCacheController {
    private static final Logger LOG = LoggerFactory.getLogger(InfoCacheController.class);
    private AccxiaCacheComponent accxiaCacheComponent;
    private AccxiaCachePropertySet accxiaCachePropertySet;

    @Inject
    public InfoCacheController(AccxiaCacheComponent accxiaCacheComponent, AccxiaCachePropertySet accxiaCachePropertySet) {
        this.accxiaCacheComponent = accxiaCacheComponent;
        this.accxiaCachePropertySet = accxiaCachePropertySet;
    }

    @Path(value="/property/list")
    @GET
    @Produces(value={"application/json"})
    public Response getCurrentConfig() {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        Map<String, String> properties = DAO.getValues();
        map.put("properties", properties);
        return Response.ok(map).build();
    }

    @Path(value="/list")
    @GET
    @Produces(value={"application/json"})
    public Response getCacheList() {
        HashMap<String, String> map = new HashMap<String, String>();
        Collection keys = this.accxiaCacheComponent.getCache().getKeys();
        for (String key : keys) {
            map.put(key, (String)this.accxiaCacheComponent.getCache().get((Object)key));
        }
        return Response.ok(map).build();
    }

    @Path(value="/get")
    @GET
    @Produces(value={"application/json"})
    public Response getCacheKey(@QueryParam(value="field") String field) {
        String value = this.accxiaCacheComponent.getValue(field);
        return Response.ok((Object)(value == null ? "NULL" : value)).build();
    }

    @Path(value="/set")
    @GET
    @Produces(value={"application/json"})
    public Response setCacheKey(@QueryParam(value="field") String field, @QueryParam(value="value") String value) {
        this.accxiaCacheComponent.setValue(field, value);
        String newValue = this.accxiaCacheComponent.getValue(field);
        return Response.ok((Object)(newValue == null ? "NULL" : newValue)).build();
    }

    @Path(value="/list2")
    @GET
    @Produces(value={"application/json"})
    public Response getCacheKey2() {
        HashMap<String, String> map = new HashMap<String, String>();
        Set<String> keys = this.accxiaCachePropertySet.getKeys();
        for (String key : keys) {
            map.put(key, (String)this.accxiaCacheComponent.getCache().get((Object)key));
        }
        return Response.ok(map).build();
    }

    @Path(value="/get2")
    @GET
    @Produces(value={"application/json"})
    public Response getPropertyKey(@QueryParam(value="field") String field) {
        String value = this.accxiaCachePropertySet.getValue(field);
        return Response.ok((Object)(value == null ? "NULL" : value)).build();
    }

    @Path(value="/set2")
    @GET
    @Produces(value={"application/json"})
    public Response setPropertyKey(@QueryParam(value="field") String field, @QueryParam(value="value") String value) {
        this.accxiaCachePropertySet.setValue(field, value);
        String newValue = this.accxiaCachePropertySet.getValue(field);
        return Response.ok((Object)(newValue == null ? "NULL" : newValue)).build();
    }
}

