/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.conditions;

import com.atlassian.jira.plugin.webfragment.conditions.UrlReadingBooleanSystemPropertyCondition;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsIUMUser
extends UrlReadingBooleanSystemPropertyCondition {
    private static final Logger log = LoggerFactory.getLogger(IsIUMUser.class);
    private final JiraAuthenticationContext authenticationContext;

    @Inject
    public IsIUMUser(JiraAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    protected String queryKey() {
        return "IUM-confirm";
    }

    protected boolean isConditionTrue() {
        if (!ConditionEvaluatorImpl.isLicenseValid()) {
            return true;
        }
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        return IntelligentUserManagerHelper.isUserInGroups(user, DAO.getIUMGroupsDisabled());
    }
}

