/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.repository;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.jira.addon.IUM.model.JobResult;
import de.accxia.jira.addon.IUM.model.JobResultDTO;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={JobResultRepository.class})
@Named(value="JobResultRepository")
public class JobResultRepository {
    private static final Logger logger = LoggerFactory.getLogger(JobResultRepository.class);
    @ComponentImport
    private final ActiveObjects ao;

    @Inject
    public JobResultRepository(ActiveObjects ao) {
        this.ao = ao;
    }

    public JobResult save(JobResultDTO jobResultDTO) {
        logger.debug("Called save for user {}", (Object)jobResultDTO.getUserName());
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("USER_NAME", jobResultDTO.getUserName());
        values.put("USER_COPIED", jobResultDTO.getUserCopied());
        values.put("USER_REMOVED", jobResultDTO.getUserRemoved());
        values.put("SOURCE_GROUPS", jobResultDTO.getSourceGroups());
        values.put("TARGET_GROUP", jobResultDTO.getTargetGroup());
        values.put("START_TIME", jobResultDTO.getStartTime());
        values.put("END_TIME", jobResultDTO.getEndTime());
        values.put("PROCESS", jobResultDTO.getProcess());
        values.put("ERROR", jobResultDTO.getError());
        JobResult response = (JobResult)this.ao.create(JobResult.class, values);
        logger.debug("Successfully save for user {}", (Object)jobResultDTO.getUserName());
        return response;
    }

    public JobResult[] getByUserName(String userName) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called getByUserName for userName {} ", (Object)userName);
        }
        JobResult[] queryResult = (JobResult[])this.ao.find(JobResult.class, Query.select().where("USER_NAME = ? ", new Object[]{userName}).order("ID DESC"));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully fetch result for userName {} ", (Object)userName);
        }
        return queryResult;
    }

    public JobResult[] getByUserName(String userName, int idx, int ctx) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called getByUserName for userName {} ", (Object)userName);
        }
        JobResult[] queryResult = (JobResult[])this.ao.find(JobResult.class, Query.select().where("USER_NAME = ? ", new Object[]{userName}).order("ID DESC").offset(idx).limit(ctx));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully fetch result for userName {} ", (Object)userName);
        }
        return queryResult;
    }

    public JobResult[] findAll(int idx, int ctx) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called findAll from  {} to {}", (Object)idx, (Object)ctx);
        }
        JobResult[] queryResult = (JobResult[])this.ao.find(JobResult.class, Query.select().order("ID DESC").offset(idx).limit(ctx));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully findAll from  {} to {}", (Object)idx, (Object)ctx);
        }
        return queryResult;
    }

    public JobResult[] findAll(String[] process, int idx, int ctx) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called findAll from  {} to {}", (Object)idx, (Object)ctx);
        }
        JobResult[] queryResult = (JobResult[])this.ao.find(JobResult.class, Query.select().where("PROCESS in ( ? ) ", new Object[]{Arrays.stream(process).collect(Collectors.joining(","))}).order("ID DESC").offset(idx).limit(ctx));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully findAll from  {} to {}", (Object)idx, (Object)ctx);
        }
        return queryResult;
    }
}

