/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.job;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.session.currentusers.JiraUserSession;
import de.accxia.jira.addon.IUM.job.IJob;
import de.accxia.jira.addon.IUM.job.JobData;
import de.accxia.jira.addon.IUM.job.ProcessResult;
import de.accxia.jira.addon.IUM.repository.JobResultRepository;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import de.accxia.jira.addon.IUM.servlet.HelperTrialProcessing;
import de.accxia.jira.addon.IUM.servlet.session.AccxiaUserSessionTracker;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class IUMJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMJob instance;
    private HelperTrialProcessing helperTrialProcessing;
    private PocketRepository pocketRepository;
    private JobResultRepository jobResultRepository;

    private IUMJob() {
    }

    public static IUMJob getInstance() {
        if (instance == null) {
            instance = new IUMJob();
        }
        return instance;
    }

    @Override
    public void injectService(HelperTrialProcessing helperTrialProcessing, PocketRepository pocketRepository, JobResultRepository jobResultRepository) {
        IUMJob.instance.helperTrialProcessing = helperTrialProcessing;
        IUMJob.instance.pocketRepository = pocketRepository;
        IUMJob.instance.jobResultRepository = jobResultRepository;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) throws RemoveException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMJob Process #[" + SDF.format(new Date()) + "] ");
        }
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        String enableGroups = (String)((Object)parameters.get("enable_groups"));
        long inactivityInterval = (Long)parameters.get("inactivity_interval");
        if (inactivityInterval <= 0L) {
            inactivityInterval = JobData.DEFAULT_USER_INACTIVITY_INTERVAL;
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMJob Process with groups={} interval={} at [ {} ] ", new Object[]{enableGroups, inactivityInterval, SDF.format(new Date())});
        }
        ProcessResult processResult = new ProcessResult("CleanJob", (String)((Object)parameters.get("enable_groups")), (String)((Object)parameters.get("disable_groups")));
        GroupManager groupManager = ComponentAccessor.getGroupManager();
        UserManager userManager = ComponentAccessor.getUserManager();
        UserUtil userUtil = ComponentAccessor.getUserUtil();
        HashMap usersEnabled = new HashMap();
        HashMap usersSession = new HashMap();
        if (!IUMJob.isEmpty(enableGroups)) {
            Arrays.stream(enableGroups.split(",")).forEach(group -> groupManager.getUserNamesInGroup(group).stream().forEach(username -> {
                this.doAddUserActive((String)username, (String)group, usersEnabled);
                usersSession.put(username, new ArrayList());
            }));
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Verify enabled users count #" + usersEnabled.size());
                if (usersEnabled.size() > 0) {
                    this.LOG.debug("Verify " + usersEnabled.keySet().stream().collect(Collectors.joining(",")));
                }
            }
            processResult.setUserRemoved(0L);
            if (usersEnabled.size() > 0) {
                long now = new Date().getTime();
                AccxiaUserSessionTracker accxiaUserSessionTracker = AccxiaUserSessionTracker.getInstance();
                List<JiraUserSession> snapshotSession = accxiaUserSessionTracker.getAccxiaSnapshot();
                for (JiraUserSession jiraUserSession : snapshotSession) {
                    if (jiraUserSession.getUserName() == null || usersEnabled.get(jiraUserSession.getUserName()) == null) continue;
                    if (now - jiraUserSession.getLastAccessTime().getTime() < inactivityInterval) {
                        if (this.LOG.isDebugEnabled()) {
                            this.LOG.debug("IUMJob user {} has active http session will not removed from enable group  {} / {}", new Object[]{jiraUserSession.getUserName(), SDF.format(jiraUserSession.getCreationTime()), SDF.format(jiraUserSession.getLastAccessTime())});
                        }
                        usersEnabled.put(jiraUserSession.getUserName(), null);
                        continue;
                    }
                    if (!usersSession.containsKey(jiraUserSession.getUserName())) continue;
                    ((List)usersSession.get(jiraUserSession.getUserName())).add(jiraUserSession.getId());
                }
                for (String ukey : usersEnabled.keySet()) {
                    List userActiveList = (List)usersEnabled.get(ukey);
                    if (userActiveList == null || userActiveList.size() <= 0) continue;
                    for (UserActive userActive : userActiveList) {
                        try {
                            userUtil.removeUserFromGroup(groupManager.getGroup(userActive.group), userManager.getUserByName(ukey));
                            processResult.setUserRemoved(processResult.getUserRemoved() + 1L);
                            if (!this.LOG.isInfoEnabled()) continue;
                            this.LOG.info("IUMJob removed user {} from group {} ", new Object[]{ukey, userActive.group});
                        }
                        catch (Exception e) {
                            this.LOG.error("Exception[removeUserFromGroup]: " + e.getMessage(), (Throwable)e);
                        }
                    }
                }
                for (String ukey : usersSession.keySet()) {
                    List sessionList = (List)usersSession.get(ukey);
                    if (sessionList == null || sessionList.size() <= 0) continue;
                    for (String sessionId : sessionList) {
                        try {
                            if (this.LOG.isInfoEnabled()) {
                                this.LOG.info("IUMJob markSessionAsInvalid user {} from sessionId {} ", new Object[]{ukey, sessionId});
                            }
                            accxiaUserSessionTracker.markSessionAsInvalid(sessionId);
                        }
                        catch (Exception e) {
                            this.LOG.error("Exception[markSessionAsInvalid]: " + e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("IUMJob Processed #[" + SDF.format(new Date()) + "] ");
            }
        }
        processResultList.add(processResult);
        return processResultList;
    }

    private void addSessionUserActive(String username, String sessionId, Map<String, List<String>> usersSession) {
        if (!usersSession.containsKey(username)) {
            usersSession.put(username, new ArrayList());
        }
        usersSession.get(username).add(sessionId);
    }

    private void doAddUserActive(String username, String group, Map<String, List<UserActive>> usersEnabled) {
        if (!usersEnabled.containsKey(username)) {
            usersEnabled.put(username, new ArrayList());
        }
        List<UserActive> userActiveList = usersEnabled.get(username);
        userActiveList.add(new UserActive(group));
    }

    private static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    class UserActive {
        String group;
        Boolean active = false;
        List<String> sessions = new ArrayList<String>();

        public UserActive(String group) {
            this.group = group;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserActive that = (UserActive)o;
            if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
                return false;
            }
            return this.active != null ? this.active.equals(that.active) : that.active == null;
        }

        public int hashCode() {
            int result = this.group != null ? this.group.hashCode() : 0;
            result = 31 * result + (this.active != null ? this.active.hashCode() : 0);
            return result;
        }
    }
}

